/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.autoupdate.event.listener;

import com.els.base.autoupdate.entity.UpgradeLog;
import com.els.base.autoupdate.service.UpgradeLogService;
import com.els.base.autoupdate.utils.UpgradeLogUtils;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class UpgradeLogListener
implements ApplicationContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(UpgradeLogListener.class);
    @Value(value="${auto.upgrade.is.enable:false}")
    private String isEnable;
    @Autowired
    private UpgradeLogService upgradeLogService;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.isEnable.equalsIgnoreCase("true")) {
            logger.debug("\u81ea\u52a8\u5347\u7ea7\u529f\u80fd\uff0c\u5df2\u7ecf\u7981\u7528\u3002\u542f\u7528\u8bf7\u914d\u7f6e auto.upgrade.is.enable \u4e3atrue");
            return;
        }
        logger.info("###############\u6267\u884c\u5347\u7ea7\u811a\u672c\u5f00\u59cb#######################");
        UpgradeLog lastSuccessLog = this.upgradeLogService.findLastUpdateLog();
        if (lastSuccessLog == null) {
            this.upgradeLogService.initNewUpdateLog();
            return;
        }
        List<Object> sqlFileList = new ArrayList();
        try {
            sqlFileList = UpgradeLogUtils.findUpdateSqlFile(lastSuccessLog.getLastUpdateTime());
        }
        catch (Exception e1) {
            logger.error("\u5347\u7ea7\u5931\u8d25", (Throwable)e1);
            throw new CommonException("\u5347\u7ea7\u5931\u8d25\uff0c\u539f\u56e0:" + e1.getMessage());
        }
        if (CollectionUtils.isEmpty(sqlFileList)) {
            logger.info("###############\u6267\u884c\u5347\u7ea7\u811a\u672c\u7ed3\u675f,\u6ca1\u6709\u53ef\u6267\u884c\u7684sql#######################");
            return;
        }
        for (Resource resource : sqlFileList) {
            try {
                List<String> list;
                if (this.upgradeLogService.hasSuccessRecord(resource.getFilename()) || CollectionUtils.isEmpty(list = UpgradeLogUtils.readSQLContent(resource))) continue;
                logger.info("=========================\u6267\u884csql\u5f00\u59cb==========================");
                this.upgradeLogService.executeSql(list);
                logger.info("=========================\u6267\u884csql\u7ed3\u675f==========================");
                UpgradeLog newLog = new UpgradeLog();
                newLog.setSqlFileName(resource.getFilename());
                newLog.setLastUpdateTime(new Date());
                newLog.setIsSuccess(Constant.YES_INT);
                this.upgradeLogService.addObj(newLog);
            }
            catch (Exception e) {
                logger.error("sql\u6267\u884c\u5931\u8d25", (Throwable)e);
                UpgradeLog errLog = new UpgradeLog();
                errLog.setSqlFileName(resource.getFilename());
                errLog.setIsSuccess(Constant.NO_INT);
                errLog.setFailReason(e.getMessage());
                errLog.setLastUpdateTime(new Date());
                this.upgradeLogService.addObj(errLog);
            }
        }
        logger.info("###############\u6267\u884c\u5347\u7ea7\u811a\u672c\u7ed3\u675f#######################");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.onApplicationEvent(null);
    }
}

