-- ----------------------------
-- 升级日志表
-- ----------------------------
-- DROP TABLE "T_BASE_UPGRADE_LOG";
CREATE TABLE "T_BASE_UPGRADE_LOG"
(
    "ID"               VARCHAR2(32 BYTE) NOT NULL,
    "LAST_UPDATE_TIME" DATE,
    "SQL_FILE_NAME"    VARCHAR2(32 BYTE),
    "IS_SUCCESS"       NUMBER(5),
    "FAIL_REASON"      NCLOB
);

COMMENT ON COLUMN "T_BASE_UPGRADE_LOG"."ID" IS '更新编号';
COMMENT ON COLUMN "T_BASE_UPGRADE_LOG"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_UPGRADE_LOG"."SQL_FILE_NAME" IS 'SQL文件名称';
COMMENT ON COLUMN "T_BASE_UPGRADE_LOG"."IS_SUCCESS" IS '是否成功';
COMMENT ON COLUMN "T_BASE_UPGRADE_LOG"."FAIL_REASON" IS '升级失败原因';
COMMENT ON TABLE "T_BASE_UPGRADE_LOG" IS '升级日志表';

ALTER TABLE "T_BASE_UPGRADE_LOG"
    ADD PRIMARY KEY ("ID");
