/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryMould;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.inquiry.web.vo.GenerateMouldVO;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldMaterial;
import com.els.base.mould.master.entity.MouldMaterialExample;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GenerateMouldCommand
extends AbstractInquiryCommand<List<InquiryMould>> {
    private List<GenerateMouldVO> vos;

    public GenerateMouldCommand(List<GenerateMouldVO> vos) {
        this.vos = vos;
    }

    @Override
    public List<InquiryMould> execute(InquiryCommandInvoker invoker) {
        HashMap<String, List> mouldIdMap = new HashMap<String, List>();
        ArrayList<InquiryMould> mouldsList = new ArrayList<InquiryMould>();
        for (GenerateMouldVO vo : this.vos) {
            if (StringUtils.isBlank((String)vo.getMaterialDesc())) continue;
            InquiryMould inquiryMould = new InquiryMould();
            if (StringUtils.isBlank((String)vo.getMaterialCode())) {
                inquiryMould.setMaterialDesc(vo.getMaterialDesc());
                mouldsList.add(inquiryMould);
                continue;
            }
            MouldMaterialExample example = new MouldMaterialExample();
            example.createCriteria().andMaterialCodeEqualTo(vo.getMaterialCode());
            List mouldMaterials = invoker.getMouldMaterialService().queryAllObjByExample(example);
            if (mouldMaterials.isEmpty()) {
                inquiryMould.setMaterialCode(vo.getMaterialCode());
                inquiryMould.setMaterialDesc(vo.getMaterialDesc());
                mouldsList.add(inquiryMould);
                continue;
            }
            for (MouldMaterial mouldMaterial : mouldMaterials) {
                ArrayList<String> materialList2 = new ArrayList<String>();
                materialList2.add(mouldMaterial.getMaterialCode());
                materialList2.add(mouldMaterial.getMaterialDesc());
                mouldIdMap.put(mouldMaterial.getMouldId(), materialList2);
            }
        }
        mouldIdMap.forEach((mouldId, materialList) -> {
            Mould mould = (Mould)invoker.getMouldService().queryObjById(mouldId);
            if (mould != null && Constant.YES_INT.equals(mould.getIsEnable()) && Constant.YES_INT.equals(mould.getMouldStatus())) {
                InquiryMould inquiryMould = new InquiryMould();
                inquiryMould.setMaterialCode((String)materialList.get(0));
                inquiryMould.setMaterialDesc((String)materialList.get(1));
                inquiryMould.setMouldCode(mould.getMouldCode());
                inquiryMould.setMouldName(mould.getMouldDesc());
                inquiryMould.setMoldMaterial(mould.getMouldMaterial());
                if (mould.getMouldLifetime() != null) {
                    inquiryMould.setMoldLife(mould.getMouldLifetime().intValue());
                }
                inquiryMould.setWaitMaterialId(mould.getId());
                inquiryMould.setRowStatus(OperationTypeEnum.NO_OPERATION.getCode());
                mouldsList.add(inquiryMould);
            }
        });
        return mouldsList;
    }
}

