/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.MaterialSealRef;
import com.els.base.material.entity.MaterialSealRefExample;
import com.els.base.material.service.MaterialSealRefService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.uuid.UUIDGenerator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u7269\u6599\u5173\u5c01\u5173\u8054\u8868")
@Controller
@RequestMapping(value={"materialSealRef"})
public class MaterialSealRefController {
    @Resource
    protected MaterialSealRefService materialSealRefService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7269\u6599\u5173\u5c01\u5173\u8054\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MaterialSealRef materialSealRef) {
        materialSealRef.setProjectId(ProjectUtils.getProjectId());
        String currentCompanyId = CompanyUtils.currentCompanyId();
        materialSealRef.setCompanyId(currentCompanyId);
        materialSealRef.setCreateTime(new Date());
        this.materialSealRefService.addObj(materialSealRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7269\u6599\u5173\u5c01\u5173\u8054\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterialSealRef materialSealRef) {
        if (StringUtils.isBlank((String)materialSealRef.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "id_is_blank");
        }
        this.materialSealRefService.modifyObj(materialSealRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599\u5173\u5c01\u5173\u8054\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25", "id_is_blank");
        }
        this.materialSealRefService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599\u5173\u5c01\u5173\u8054\u8868")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialSealRef>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialSealRef") @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialSealRefExample example = new MaterialSealRefExample();
        example.setPageView(new PageView<MaterialSealRef>(pageNo, pageSize));
        if (wapper != null) {
            MaterialSealRefExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.materialSealRefService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u5bfc\u51fa\u7269\u6599\u5173\u5c01\u4fe1\u606f")
    @RequestMapping(value={"service/exportMaterialSealRefInfo"})
    public ModelAndView exportMaterialSealRefInfo(HttpServletResponse response, HttpServletRequest request) {
        try {
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            MaterialSealRef materialSealRef = new MaterialSealRef();
            String attrs = materialSealRef.getAttrs();
            String[] split = attrs.split(",");
            for (int i = 0; i < split.length; ++i) {
                String string = split[i];
                String[] split2 = string.split("_");
                TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey((String)split2[0], (String)split2[1]);
                titleAndModelKeys.add(titleAndModelKey);
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u7269\u6599\u5173\u5c01\u6a21\u677f.xlsx", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/x-msdownload;");
            ServletOutputStream outputStream = response.getOutputStream();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, null, (String)"\u7269\u6599\u5173\u5c01", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(httpMethod="POST", value="\u7269\u6599\u5173\u5c01\u5173\u8054\u8868excel\u5bfc\u5165")
    @RequestMapping(value={"service/materialSealRefUpload"})
    @ResponseBody
    public void materialSealRefUpload(MultipartHttpServletRequest request) throws IOException {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        Set fileKeySet = fileMap.keySet();
        ArrayList fileList = new ArrayList();
        Iterator keyIterator = fileKeySet.iterator();
        while (keyIterator.hasNext()) {
            fileList.add(fileMap.get(keyIterator.next()));
        }
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6d77\u5173\u54c1\u53f7", (String)"customsNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u53f7", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName"));
        for (MultipartFile file : fileList) {
            InputStream inputStream = file.getInputStream();
            List importExcelDataToMap = null;
            try {
                importExcelDataToMap = ExcelUtils.importExcelDataToMap((InputStream)inputStream, (int)0, (int)2, (int)1, titleAndModelKeys, new MaterialSealRef().getClass());
            }
            catch (Exception e) {
                throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
            }
            for (MaterialSealRef materialSealRef : importExcelDataToMap) {
                MaterialSealRef sealRef = new MaterialSealRef();
                sealRef.setCustomsNo(materialSealRef.getCustomsNo());
                sealRef.setMaterialCode(materialSealRef.getMaterialCode());
                sealRef.setMaterialName(materialSealRef.getMaterialName());
                sealRef.setCreateTime(new Date());
                sealRef.setCompanyId(CompanyUtils.currentCompanyId());
                sealRef.setProjectId(ProjectUtils.getProjectId());
                sealRef.setId(UUIDGenerator.generateUUID());
                this.materialSealRefService.addObj(sealRef);
            }
        }
    }
}

