/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingMatterStepMapper;
import com.els.base.bidding.entity.BiddingMatterStep;
import com.els.base.bidding.entity.BiddingMatterStepExample;
import com.els.base.bidding.service.BiddingMatterStepService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultBiddingMatterStepService")
public class BiddingMatterStepServiceImpl
implements BiddingMatterStepService {
    @Resource
    protected BiddingMatterStepMapper biddingMatterStepMapper;

    @Override
    @CacheEvict(value={"biddingMatterStep"}, allEntries=true)
    public void addObj(BiddingMatterStep t) {
        this.biddingMatterStepMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"biddingMatterStep"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingMatterStepMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"biddingMatterStep"}, allEntries=true)
    public void modifyObj(BiddingMatterStep t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingMatterStepMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"biddingMatterStep"}, keyGenerator="redisKeyGenerator")
    public BiddingMatterStep queryObjById(String id) {
        return this.biddingMatterStepMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"biddingMatterStep"}, keyGenerator="redisKeyGenerator")
    public List<BiddingMatterStep> queryAllObjByExample(BiddingMatterStepExample example) {
        return this.biddingMatterStepMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"biddingMatterStep"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingMatterStep> queryObjByPage(BiddingMatterStepExample example) {
        PageView<BiddingMatterStep> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingMatterStepMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteObjByMatterId(String id) {
        BiddingMatterStepExample biddingMatterStepExample = new BiddingMatterStepExample();
        biddingMatterStepExample.createCriteria().andMatterIdEqualTo(id);
        this.biddingMatterStepMapper.deleteByExample(biddingMatterStepExample);
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingMatterStepExample biddingMatterStepExample = new BiddingMatterStepExample();
        biddingMatterStepExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingMatterStep> biddingMatterSteps = this.biddingMatterStepMapper.selectByExample(biddingMatterStepExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingMatterSteps) && i < biddingMatterSteps.size(); ++i) {
            this.biddingMatterStepMapper.deleteByPrimaryKey(biddingMatterSteps.get(i).getId());
        }
    }
}

