/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.SyncPriceService;
import com.els.base.inquiry.command.pur.ViewPricingDetailCommand;
import com.els.base.inquiry.entity.InformationRecord;
import com.els.base.inquiry.entity.InformationRecordExample;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.SystemPrice;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.inquiry.web.vo.OrderItemVo;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.entity.SupplierMaterialExample;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class SyncPriceToSapCmd
extends AbstractInquiryCommand<String> {
    private List<OrderItemVo> vos;

    public SyncPriceToSapCmd(List<OrderItemVo> vos) {
        this.vos = vos;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        PurOrder purOrder = invoker.invoke(new ViewPricingDetailCommand(this.vos.get((int)0).purOrderId));
        Assert.isNotNull(purOrder, "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(purOrder.getId(), "\u4f20\u5165\u7684\u91c7\u8d2d\u5546\u8868\u5934ID\u4e3a\u7a7a");
        Assert.isNotEmpty(purOrder.getItemList(), "\u4f20\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u53cd\u5199sap\u5931\u8d25");
        InformationRecordExample example = new InformationRecordExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrder.getId());
        List inforList = invoker.getInformationRecordService().queryAllObjByExample(example);
        Assert.isNotEmpty(inforList, "\u6839\u636e\u91c7\u8d2d\u5546\u8868\u5934ID\u67e5\u8be2\u51fa\u7684\u4fe1\u606f\u8bb0\u5f55\u4e3a\u7a7a");
        InformationRecord infor = (InformationRecord)inforList.get(0);
        this.validInfoRecord(infor);
        ArrayList<IOrderItem> orderItemList = new ArrayList<IOrderItem>();
        TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(purOrder.getTemplateId());
        for (OrderItemVo vo : this.vos) {
            IOrderItem orderItem2 = (IOrderItem)templateConf.getOrderItemService().queryObjById(vo.itemId);
            if (!OperationTypeEnum.ACCEPTED.getCode().equals(orderItem2.getOperation())) {
                throw new CommonException("\u8be5\u5355\u636e\u672a\u63a5\u53d7,\u65e0\u6cd5\u5bfc\u5165");
            }
            OrderItemM001 tempOrderItem = new OrderItemM001();
            tempOrderItem.setId(orderItem2.getId());
            if (StringUtils.isNotBlank((String)vo.supSapCompanyCode)) {
                tempOrderItem.setSupCompanySapCode(vo.supSapCompanyCode);
            }
            templateConf.getOrderItemService().modifyObj(tempOrderItem);
            orderItemList.add(orderItem2);
        }
        orderItemList.stream().forEach(orderItem -> {
            OrderItemM001 data = (OrderItemM001)orderItem;
            this.validOrderItem(data);
            InquiryBusiCondition busiCondition = this.getBusiCondition(data, purOrder);
            SystemPrice sys = this.buildSystemPrice(data, busiCondition, infor);
            OrderItemM001 tempOrderItem = new OrderItemM001();
            tempOrderItem.setId(orderItem.getId());
            tempOrderItem.setSaleTaxCode(busiCondition.getTaxRate());
            templateConf.getOrderItemService().modifyObj(tempOrderItem);
            SyncPriceService syncPriceService = (SyncPriceService)SpringContextHolder.getOneBean(SyncPriceService.class);
            if (syncPriceService == null) {
                throw new CommonException("\u7cfb\u7edf\u8fd8\u6ca1\u6709\u542f\u52a8\u4ef7\u683c\u56de\u5199\u5230sap\u7684\u914d\u7f6e");
            }
            try {
                syncPriceService.sendData(sys, data);
            }
            catch (Exception e) {
                this.logger.error("\u4f9b\u5e94\u5546\u62a5\u4ef7\u4fe1\u606f\u53cd\u5199SAP\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
                throw new CommonException("\u4f9b\u5e94\u5546\u62a5\u4ef7\u4fe1\u606f\u53cd\u5199SAP\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:" + e.getMessage());
            }
            invoker.getSystemPriceService().addObj(sys);
            tempOrderItem.setIsImportSap(Constant.YES_INT);
            templateConf.getOrderItemService().modifyObj(tempOrderItem);
        });
        return null;
    }

    private SystemPrice buildSystemPrice(OrderItemM001 data, InquiryBusiCondition busiCondition, InformationRecord infor) {
        SystemPrice sys = new SystemPrice();
        sys.setInformationRecordCategory(infor.getInformationRecordCategory());
        sys.setFactoryCode(infor.getFactoryCode());
        sys.setPurchaseOrganization(infor.getPurchaseOrganization());
        sys.setPurchasingGroup(infor.getPurchasingGroup());
        sys.setConditionalType(infor.getConditionalType());
        sys.setOrderItemId(data.getId());
        sys.setCreateTime(new Date());
        sys.setUpdateTime(new Date());
        sys.setIsEnable(Constant.YES_INT);
        sys.setUntaxedUnitPrice(data.getUntaxedUnitPrice());
        sys.setCompanySapCode(data.getSupCompanySapCode());
        if (StringUtils.isNotBlank((String)data.getMeasurementUnit())) {
            sys.setPurPriceUnit(data.getMeasurementUnit());
        }
        if (data.getValuationUnit() != null) {
            sys.setPriceUnit(data.getValuationUnit());
        }
        sys.setMaterialCode(data.getMaterialCode());
        sys.setSupMaterialGroup(data.getSupMaterialGroup());
        if (StringUtils.isNotBlank((String)data.getSupMaterialCode())) {
            sys.setSupMaterialCode(data.getSupMaterialCode());
        } else {
            String supMaterialCode = this.getSupMaterialCode(data.getMaterialCode(), data.getSupCompanySapCode());
            if (StringUtils.isNotBlank((String)supMaterialCode)) {
                sys.setSupMaterialCode(supMaterialCode);
            } else {
                sys.setSupMaterialCode(data.getSupMaterialGroup());
            }
        }
        if (data.getPriceValidTime() != null) {
            sys.setPriceEffectiveStartTime(DateUtils.truncate((Date)data.getPriceValidTime(), (int)5));
        } else {
            sys.setPriceEffectiveStartTime(DateUtils.truncate((Date)new Date(), (int)5));
        }
        if (data.getPriceExpiredTime() != null) {
            Date expiredTime = DateUtils.truncate((Date)data.getPriceExpiredTime(), (int)5);
            expiredTime = DateUtils.addDays((Date)expiredTime, (int)1);
            expiredTime = DateUtils.addSeconds((Date)expiredTime, (int)-1);
            sys.setPriceEffectiveEndTime(expiredTime);
        }
        if (busiCondition != null) {
            sys.setCountry(busiCondition.getCountry());
            sys.setRegion(busiCondition.getRegion());
            sys.setCurrency(busiCondition.getCurrency());
        }
        return sys;
    }

    private String getSupMaterialCode(String materialCode, String companySapCode) {
        SupplierMaterialExample materExample = new SupplierMaterialExample();
        materExample.createCriteria().andCompanySapCodeEqualTo(companySapCode).andMaterialCodeEqualTo(materialCode);
        SupplierMaterialService service = (SupplierMaterialService)SpringContextHolder.getOneBean(SupplierMaterialService.class);
        List materialList = service.queryAllObjByExample(materExample);
        if (CollectionUtils.isNotEmpty(materialList) && StringUtils.isNotBlank((String)((SupplierMaterial)materialList.get(0)).getSupplierMaterial())) {
            return ((SupplierMaterial)materialList.get(0)).getSupplierMaterial();
        }
        return null;
    }

    private InquiryBusiCondition getBusiCondition(OrderItemM001 data, PurOrder purOrder) {
        return purOrder.getBusiConditions().stream().filter(busiCondition -> busiCondition.getSupCompanyId().equals(data.getSupCompanyId())).findAny().orElse(null);
    }

    private void validInfoRecord(InformationRecord infor) {
        Assert.isNotBlank(infor.getConditionalType(), "\u4fe1\u606f\u8bb0\u5f55\u4e2d\u6761\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(infor.getFactoryCode(), "\u4fe1\u606f\u8bb0\u5f55\u4e2d\u5de5\u5382\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(infor.getInformationRecordCategory(), "\u4fe1\u606f\u8bb0\u5f55\u4e2d\u4fe1\u606f\u8bb0\u5f55\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(infor.getPurchaseOrganization(), "\u4fe1\u606f\u8bb0\u5f55\u4e2d\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(infor.getPurchasingGroup(), "\u4fe1\u606f\u8bb0\u5f55\u4e2d\u91c7\u8d2d\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void validOrderItem(OrderItemM001 data) {
        Assert.isNotNull(data.getUntaxedUnitPrice(), "\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(data.getMeasurementUnit(), "\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(data.getValuationUnit(), "\u8ba1\u4ef7\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(data.getMaterialDesc(), "\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(data.getMaterialCode(), "\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(data.getSupMaterialGroup(), "\u539f\u4ea7\u5730\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

