/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.dao.TplMouldDetailMapper;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplMouldDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultTplMouldDetailService")
public class TplMouldDetailServiceImpl
implements TplMouldDetailService {
    @Resource
    protected TplMouldDetailMapper tplMouldDetailMapper;
    @Resource
    protected PropertyDefService propertyDefService;

    @Override
    @CacheEvict(value={"tplMouldDetail"}, allEntries=true)
    public void addObj(TplMouldDetail t) {
        Assert.isNotBlank(t.getCode(), "\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        TplMouldDetailExample example = new TplMouldDetailExample();
        example.createCriteria().andCodeEqualTo(t.getCode()).andIsHisEqualTo(Constant.NO_INT);
        if (this.tplMouldDetailMapper.countByExample(example) > 0) {
            throw new CommonException("\u7f16\u7801\u5df2\u5b58\u5728");
        }
        this.tplMouldDetailMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"tplMouldDetail"}, allEntries=true)
    public void deleteObjById(String id) {
        this.tplMouldDetailMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"tplMouldDetail"}, allEntries=true)
    public void modifyObj(TplMouldDetail t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        if (t.getCode() != null) {
            TplMouldDetailExample example = new TplMouldDetailExample();
            example.createCriteria().andCodeEqualTo(t.getCode()).andIdNotEqualTo(t.getId()).andIsHisEqualTo(Constant.YES_INT);
            if (this.tplMouldDetailMapper.countByExample(example) > 0) {
                throw new CommonException("\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        this.tplMouldDetailMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"tplMouldDetail"}, keyGenerator="redisKeyGenerator")
    public TplMouldDetail queryObjById(String id) {
        TplMouldDetail tplMouLdDetail = this.tplMouldDetailMapper.selectByPrimaryKey(id);
        if (tplMouLdDetail == null) {
            return tplMouLdDetail;
        }
        if (!Constant.YES_INT.equals(tplMouLdDetail.getIsHis())) {
            tplMouLdDetail.setPropertyDefList(PropertyDefUtils.queryMouldDetailProDef(tplMouLdDetail));
        } else {
            List<PropertyDef> tplMouldProDefList = this.propertyDefService.queryHisPropertyDefList(id, PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
            tplMouLdDetail.setPropertyDefList(tplMouldProDefList);
        }
        return tplMouLdDetail;
    }

    @Override
    @Cacheable(value={"tplMouldDetail"}, keyGenerator="redisKeyGenerator")
    public List<TplMouldDetail> queryAllObjByExample(TplMouldDetailExample example) {
        return this.tplMouldDetailMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"tplMouldDetail"}, keyGenerator="redisKeyGenerator")
    public PageView<TplMouldDetail> queryObjByPage(TplMouldDetailExample example) {
        PageView<TplMouldDetail> pageView = example.getPageView();
        pageView.setQueryResult(this.tplMouldDetailMapper.selectByExampleByPage(example));
        return pageView;
    }
}

