/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.entity.SystemPrice;
import com.els.base.inquiry.entity.SystemPriceExample;
import com.els.base.inquiry.service.SystemPriceService;
import com.els.base.inquiry.web.vo.SystemPriceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8be2\u62a5\u4ef7-\u7269\u6599\u7684ERP\u7cfb\u7edf\u4ef7")
@Controller
@RequestMapping(value={"systemPrice"})
public class SystemPriceController {
    @Resource
    protected SystemPriceService systemPriceService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8be2\u62a5\u4ef7-\u7269\u6599\u7684ERP\u7cfb\u7edf\u4ef7")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody SystemPrice systemPrice) {
        this.systemPriceService.addObj(systemPrice);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8be2\u62a5\u4ef7-\u7269\u6599\u7684ERP\u7cfb\u7edf\u4ef7")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody SystemPrice systemPrice) {
        Assert.isNotBlank(systemPrice.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.systemPriceService.modifyObj(systemPrice);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8be2\u62a5\u4ef7-\u7269\u6599\u7684ERP\u7cfb\u7edf\u4ef7")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.systemPriceService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8be2\u62a5\u4ef7-\u7269\u6599\u7684ERP\u7cfb\u7edf\u4ef7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SystemPrice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SystemPrice>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SystemPriceExample example = new SystemPriceExample();
        example.setPageView(new PageView<SystemPrice>(pageNo, pageSize));
        SystemPriceExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.systemPriceService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5386\u53f2\u4ef7\u683c\u5bf9\u6bd4-\u7269\u6599\u7684ERP\u7cfb\u7edf\u4ef7")
    @RequestMapping(value={"service/historicalPrice"})
    @ResponseBody
    public ResponseResult<List<SystemPrice>> historicalPrice(@RequestParam(required=true) String materialCode, @RequestParam(required=true) String supCompanySapCode) {
        Assert.isNotBlank(materialCode, "\u4f20\u5165\u7684\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
        SystemPriceExample example = new SystemPriceExample();
        example.setOrderByClause("PRICE_EFFECTIVE_START_TIME DESC");
        example.setPageView(new PageView<SystemPrice>(1, 7));
        SystemPriceExample.Criteria criteria = example.createCriteria();
        criteria.andPriceEffectiveStartTimeGreaterThanOrEqualTo(DateUtils.addYears((Date)new Date(), (int)-3));
        criteria.andMaterialCodeEqualTo(materialCode);
        criteria.andCompanySapCodeEqualTo(supCompanySapCode);
        example.or().andMaterialCodeEqualTo(materialCode).andCompanySapCodeEqualTo(supCompanySapCode).andPriceEffectiveStartTimeIsNull();
        List priceList = this.systemPriceService.queryObjByPage(example).getQueryResult();
        Assert.isNotEmpty(priceList, "\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u51fa\u7684\u5386\u53f2\u4ef7\u6570\u636e\u4e3a\u7a7a");
        return ResponseResult.success(priceList);
    }

    @ApiOperation(httpMethod="POST", value="\u540c\u7c7b\u7269\u6599\u53c2\u8003\u6bd4\u4ef7-\u7269\u6599\u7684ERP\u7cfb\u7edf\u4ef7")
    @RequestMapping(value={"service/materielPriceParity"})
    @ResponseBody
    public ResponseResult<List<SystemPriceVo>> materielPriceParity(@RequestBody(required=true) List<String> materialCodeList, @RequestParam(required=true) BigDecimal untaxedUnitPrice) {
        Assert.isNotEmpty(materialCodeList, "\u4f20\u5165\u7684\u7269\u6599\u7f16\u7801\u6570\u636e\u4e3a\u7a7a");
        Assert.isNotNull(untaxedUnitPrice, "\u4f20\u5165\u7684\u62a5\u4ef7\u4e3a\u7a7a");
        SystemPriceExample example = new SystemPriceExample();
        SystemPriceExample.Criteria criteria = example.createCriteria();
        criteria.andMaterialCodeIn((List)materialCodeList);
        criteria.andPriceEffectiveEndTimeGreaterThanOrEqualTo(new Date());
        List systemPriceList = this.systemPriceService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(systemPriceList)) {
            return ResponseResult.success(new ArrayList());
        }
        ArrayList<SystemPriceVo> list = new ArrayList<SystemPriceVo>(systemPriceList.size());
        for (SystemPrice sp : systemPriceList) {
            SystemPriceVo vo = new SystemPriceVo();
            BeanUtils.copyProperties((Object)sp, (Object)vo);
            vo.setPriceRatio(untaxedUnitPrice.subtract(sp.getUntaxedUnitPrice()).multiply(new BigDecimal(100)).divide(sp.getUntaxedUnitPrice(), 2, 4));
            list.add(vo);
        }
        return ResponseResult.success(list);
    }
}

