/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.inquiry.dao.InquirySupOrderMapper;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.service.InquirySupOrderService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultInquirySupOrderService")
public class InquirySupOrderServiceImpl
implements InquirySupOrderService {
    @Resource
    protected InquirySupOrderMapper inquirySupOrderMapper;

    @Override
    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
    public void addObj(InquirySupOrder t) {
        this.inquirySupOrderMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.inquirySupOrderMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
    public void modifyObj(InquirySupOrder t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.inquirySupOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"inquirySupOrder"}, keyGenerator="redisKeyGenerator")
    public InquirySupOrder queryObjById(String id) {
        return this.inquirySupOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"inquirySupOrder"}, keyGenerator="redisKeyGenerator")
    public List<InquirySupOrder> queryAllObjByExample(InquirySupOrderExample example) {
        return this.inquirySupOrderMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"inquirySupOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<InquirySupOrder> queryObjByPage(InquirySupOrderExample example) {
        PageView<InquirySupOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.inquirySupOrderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
    public void deleteByExample(InquirySupOrderExample example) {
        if (example == null || CollectionUtils.isEmpty(example.getOredCriteria())) {
            return;
        }
        this.inquirySupOrderMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
    public void addAll(List<InquirySupOrder> supOrderList) {
        if (CollectionUtils.isEmpty(supOrderList)) {
            return;
        }
        for (InquirySupOrder inquirySupOrder : supOrderList) {
            if (!StringUtils.isBlank((String)inquirySupOrder.getId())) continue;
            inquirySupOrder.setId(UUIDGenerator.generateUUID());
        }
        this.inquirySupOrderMapper.insertBatch(supOrderList);
    }

    @Override
    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
    public void modifyByExample(InquirySupOrder supOrder, InquirySupOrderExample supOrderExample) {
        this.inquirySupOrderMapper.updateByExampleSelective(supOrder, supOrderExample);
    }
}

