/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils.json;

import com.els.base.core.exception.CommonException;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryPurFile;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.impl.TemplateConfServiceImpl;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.json.JsonUtils;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SupOrderJsonDeserialzer
extends JsonDeserializer<InquirySupOrder> {
    private String itemsJson;
    private String mouldJson;
    private TemplateConf templateConf;

    public InquirySupOrder deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        try {
            return this.deserialize(p);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u89e3\u6790\u8be2\u4ef7\u5355\u53c2\u6570\u5931\u8d25");
        }
    }

    private InquirySupOrder deserialize(JsonParser p) throws IOException, NoSuchFieldException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        InquirySupOrder supOrder = new InquirySupOrder();
        ObjectNode objectNode = (ObjectNode)p.readValueAsTree();
        Iterator fieldNamesIterator = objectNode.fieldNames();
        while (fieldNamesIterator.hasNext()) {
            String fieldName = (String)fieldNamesIterator.next();
            if ("templateConf".equals(fieldName)) continue;
            JsonNode value = objectNode.get(fieldName);
            if ("itemList".equals(fieldName)) {
                this.itemsJson = value.toString();
                continue;
            }
            if ("mouldList".equals(fieldName)) {
                this.mouldJson = value.toString();
                continue;
            }
            if ("purFileList".equals(fieldName)) {
                List inquiryPurFiles = (List)JsonUtils.convertCollection((String)value.toString(), List.class, null, (Class[])new Class[]{InquiryPurFile.class});
                supOrder.setPurFileList(inquiryPurFiles);
                continue;
            }
            if ("supFileList".equals(fieldName)) {
                List inquirySupFiles = (List)JsonUtils.convertCollection((String)value.toString(), List.class, null, (Class[])new Class[]{InquirySupFile.class});
                supOrder.setSupFileList(inquirySupFiles);
                continue;
            }
            if ("busiConditions".equals(fieldName)) {
                List busiConditions = (List)JsonUtils.convertCollection((String)value.toString(), List.class, null, (Class[])new Class[]{InquiryBusiCondition.class});
                supOrder.setBusiConditions(busiConditions);
                continue;
            }
            Field field = null;
            try {
                field = InquirySupOrder.class.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                field = InquirySupOrder.class.getSuperclass().getDeclaredField(fieldName);
            }
            ReflectUtils.setValue((Object)supOrder, (String)fieldName, (Object)JsonUtils.convertValue((String)value.toString(), field.getType()));
        }
        if (StringUtils.isNotBlank((String)this.itemsJson)) {
            this.setItemsFromValue(supOrder);
        }
        if (StringUtils.isNotBlank((String)this.mouldJson)) {
            this.setMouldFromValue(supOrder);
        }
        return supOrder;
    }

    private void setItemsFromValue(InquirySupOrder supOrder) throws ClassNotFoundException, InstantiationException, IllegalAccessException, JsonParseException, JsonMappingException, IOException {
        TemplateConf templateConf = ((TemplateConfServiceImpl)SpringContextHolder.getOneBean(TemplateConfServiceImpl.class)).queryObjById(supOrder.getTemplateId());
        String className = templateConf.getItemClassName();
        Class<?> clazz = Class.forName(className);
        JavaType javaType = JsonUtils.getObjectMapper().getTypeFactory().constructParametrizedType(List.class, null, new Class[]{clazz});
        List items = (List)JsonUtils.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(this.itemsJson, javaType);
        supOrder.setItemList(items);
    }

    private void setMouldFromValue(InquirySupOrder order) throws JsonParseException, JsonMappingException, IOException {
        TemplateConf templateConf = this.geTemplateConf(order);
        Class<? extends IMould> clazz = templateConf.getMouldClass();
        JavaType javaType = JsonUtils.getObjectMapper().getTypeFactory().constructParametrizedType(List.class, null, new Class[]{clazz});
        List moulds = (List)JsonUtils.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(this.mouldJson, javaType);
        order.setMouldList(moulds);
    }

    private TemplateConf geTemplateConf(InquirySupOrder order) {
        if (this.templateConf != null) {
            return this.templateConf;
        }
        this.templateConf = ((TemplateConfServiceImpl)SpringContextHolder.getOneBean(TemplateConfServiceImpl.class)).queryObjById(order.getTemplateId());
        return this.templateConf;
    }
}

