/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.master.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.mould.master.dao.MouldMaterialMapper;
import com.els.base.mould.master.entity.MouldMaterial;
import com.els.base.mould.master.entity.MouldMaterialExample;
import com.els.base.mould.master.service.MouldMaterialService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultMouldMaterialService")
public class MouldMaterialServiceImpl
implements MouldMaterialService {
    @Resource
    protected MouldMaterialMapper mouldMaterialMapper;

    @Override
    @CacheEvict(value={"mouldMaterial"}, allEntries=true)
    public void addObj(MouldMaterial t) {
        this.mouldMaterialMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"mouldMaterial"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mouldMaterialMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"mouldMaterial"}, allEntries=true)
    public void modifyObj(MouldMaterial t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mouldMaterialMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"mouldMaterial"}, keyGenerator="redisKeyGenerator")
    public MouldMaterial queryObjById(String id) {
        return this.mouldMaterialMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"mouldMaterial"}, keyGenerator="redisKeyGenerator")
    public List<MouldMaterial> queryAllObjByExample(MouldMaterialExample example) {
        return this.mouldMaterialMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"mouldMaterial"}, keyGenerator="redisKeyGenerator")
    public PageView<MouldMaterial> queryObjByPage(MouldMaterialExample example) {
        PageView<MouldMaterial> pageView = example.getPageView();
        pageView.setQueryResult(this.mouldMaterialMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"mouldMaterial"}, allEntries=true)
    public void deleteByMouldId(String mouldId) {
        Assert.isNotBlank(mouldId, "\u6a21\u5177id\u4e3a\u7a7a,\u5220\u9664\u7269\u6599\u4fe1\u606f\u5931\u8d25!");
        MouldMaterialExample example = new MouldMaterialExample();
        example.createCriteria().andMouldIdEqualTo(mouldId);
        this.mouldMaterialMapper.deleteByExample(example);
    }
}

