/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils.json;

import com.els.base.core.utils.Constant;
import com.els.base.inquiry.IExtendable;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.utils.ClassReflectionUtils;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class ExtendableObjectJsonDeSerialzer<T extends IExtendable>
extends JsonDeserializer<T> {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        try {
            return this.deserialize(p);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", e);
        }
    }

    protected T deserialize(JsonParser p) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, IOException, NoSuchFieldException {
        ObjectNode objectNode = (ObjectNode)p.readValueAsTree();
        IExtendable t = (IExtendable)this.getInstanceClass().newInstance();
        this.setValueIntoInstance(t, objectNode);
        this.setValueIntoPropertyValue(t, objectNode);
        return (T)t;
    }

    protected void setValueIntoPropertyValue(T t, ObjectNode objectNode) {
        List<PropertyDef> propertyDefList = t.getPropertyDefList();
        if (CollectionUtils.isEmpty(propertyDefList)) {
            return;
        }
        List<PropertyValue> propertyValueList = propertyDefList.stream().filter(propertyDef -> !Constant.YES_INT.equals(propertyDef.getIsPrimitive())).map(propertyDef -> {
            PropertyValue propertyValue = new PropertyValue();
            BeanUtils.copyProperties((Object)propertyDef, (Object)propertyValue);
            propertyValue.setId(null);
            return propertyValue;
        }).collect(Collectors.toList());
        propertyValueList.stream().forEach(propertyValue -> {
            String fieldName = propertyValue.getCode();
            JsonNode fieldNode = objectNode.get(fieldName);
            if (fieldNode == null || fieldNode.isNull()) {
                propertyValue.setValueStr(null);
                return;
            }
            String value = fieldNode.asText();
            if (StringUtils.isBlank((String)value)) {
                propertyValue.setValueStr(null);
            } else {
                value = PropertyValueUtils.validStr(value, propertyValue.getType(), propertyValue.getCode());
                propertyValue.setValueStr(value);
            }
        });
        t.setPropertyValueList(propertyValueList);
    }

    protected void setValueIntoInstance(T t, ObjectNode objectNode) {
        List<Field> primitiveFieldList = ClassReflectionUtils.getPrimitiveField(t.getClass());
        Iterator fieldNameIterator = objectNode.fieldNames();
        while (fieldNameIterator.hasNext()) {
            String fieldName = (String)fieldNameIterator.next();
            Optional<Field> primitive = primitiveFieldList.stream().filter(field -> field.getName().equals(fieldName)).findAny();
            primitive.ifPresent(field -> {
                String valueStr = objectNode.get(fieldName).asText();
                try {
                    this.setPrimitFieldValue(t, (Field)field, objectNode.get(fieldName));
                }
                catch (Exception e) {
                    this.logger.error(String.format("\u53cd\u5e8f\u5217\u5316\u5b57\u6bb5field[%s]:[%s]", field.getName(), valueStr), (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }
    }

    protected void setPrimitFieldValue(T instance, Field field, JsonNode jsonNode) throws Exception {
        String valueStr = null;
        valueStr = !jsonNode.isValueNode() ? jsonNode.toString() : jsonNode.asText();
        PropertyValueUtils.setValueToInstance(instance, field, valueStr);
    }

    public abstract Class<T> getInstanceClass();
}

