/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.entity.SupplierMaterialExample;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u534e\u9633\u4f9b\u5e94\u5546\u7269\u6599")
@Controller
@RequestMapping(value={"supplierMaterial"})
public class SupplierMaterialController {
    private static Logger logger = LoggerFactory.getLogger(SupplierMaterialController.class);
    @Resource
    protected SupplierMaterialService supplierMaterialService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u534e\u9633\u4f9b\u5e94\u5546\u7269\u6599")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody SupplierMaterial supplierMaterial) {
        supplierMaterial = this.init(supplierMaterial);
        this.supplierMaterialService.addObj(supplierMaterial);
        return ResponseResult.success();
    }

    private SupplierMaterial init(SupplierMaterial supplierMaterial) {
        Company company = CompanyUtils.currentCompany();
        supplierMaterial.setProjectId(ProjectUtils.getProjectId());
        supplierMaterial.setCompanyId(company.getId());
        supplierMaterial.setSupplierCode(company.getCompanyCode());
        supplierMaterial.setSupplierName(company.getCompanyName());
        supplierMaterial.setLastUpdateTime(new Date());
        supplierMaterial.setLastUpdateUser(SpringSecurityUtils.getLoginUserName());
        if (supplierMaterial.getMinPackage() == null) {
            supplierMaterial.setMinPackage("0");
        }
        if (StringUtils.isBlank((String)supplierMaterial.getId())) {
            supplierMaterial.setCreateTime(new Date());
            supplierMaterial.setCreateUser(SpringSecurityUtils.getLoginUserName());
        }
        return supplierMaterial;
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u534e\u9633\u4f9b\u5e94\u5546\u7269\u6599")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody SupplierMaterial supplierMaterial) {
        if (StringUtils.isNotBlank((String)(supplierMaterial = this.init(supplierMaterial)).getId())) {
            this.supplierMaterialService.modifyObj(supplierMaterial);
        } else {
            this.supplierMaterialService.addObj(supplierMaterial);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u534e\u9633\u4f9b\u5e94\u5546\u7269\u6599")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.supplierMaterialService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u534e\u9633\u4f9b\u5e94\u5546\u7269\u6599")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String id : ids) {
            if (StringUtils.isBlank((String)id)) {
                throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.supplierMaterialService.deleteObjById(id);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u534e\u9633\u4f9b\u5e94\u5546\u7269\u6599")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupplierMaterial>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupplierMaterial") @RequestBody(required=false) QueryParamWapper wapper) {
        SupplierMaterialExample example = new SupplierMaterialExample();
        example.setPageView(new PageView<SupplierMaterial>(pageNo, pageSize));
        example.setOrderByClause(" MATERIAL_CODE ASC ");
        SupplierMaterialExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.supplierMaterialService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u54c1\u53f7\u5bf9\u7167\u5bfc\u5165Excel", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importExcel"})
    public ResponseResult<String> importExcel(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
        ArrayList<SupplierMaterial> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, SupplierMaterial.class);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5f02\u5e38\uff1a", (Throwable)e);
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.supplierMaterialService.importSupplierMaterial(list, ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUserName());
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u54c1\u53f7\u5bf9\u7167\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ModelAndView downloadExcel(HttpServletResponse response, @ApiParam(value="\u8868\u4e3b\u952eID\u5217\u8868\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7(,)\u9694\u5f00", defaultValue="", required=false) @RequestParam(required=false) String ids, @ApiParam(value="queryParams", required=false) @RequestParam(required=false) String queryParams) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u4f9b\u5e94\u5546\u54c1\u53f7\u5bf9\u7167.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            SupplierMaterialExample supplierMaterialExample = new SupplierMaterialExample();
            SupplierMaterialExample.Criteria criteria = supplierMaterialExample.createCriteria();
            String companyId = CompanyUtils.currentCompanyId();
            String projectId = ProjectUtils.getProjectId();
            criteria.andProjectIdEqualTo(projectId);
            criteria.andCompanyIdEqualTo(companyId);
            QueryParamWapper wapper = null;
            if (StringUtils.isNotBlank((String)queryParams)) {
                wapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            }
            if (wapper != null) {
                CriteriaUtils.addCriterion(criteria, wapper);
            }
            List<Object> list = new ArrayList();
            if (StringUtils.isNotEmpty((String)ids)) {
                String[] idArray = ids.split(",");
                ArrayList<String> idList = new ArrayList<String>();
                for (String id : idArray) {
                    idList.add(id);
                }
                criteria.andIdIn(idList);
            }
            list = this.supplierMaterialService.queryAllObjByExample(supplierMaterialExample);
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)"\u4f9b\u5e94\u5546\u54c1\u53f7\u5bf9\u7167", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKey() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801", (String)"supplierCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"companySapCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supplierName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba2\u6237\u516c\u53f8\u7f16\u7801", (String)"purCompanyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba2\u6237\u516c\u53f8\u540d\u79f0", (String)"purCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba2\u6237\u7269\u6599\u53f7", (String)"materialCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba2\u6237\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7269\u6599\u53f7", (String)"supplierMaterial", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7269\u6599\u63cf\u8ff0", (String)"supplierMaterialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba2\u6237\u7269\u6599\u7248\u672c", (String)"materialVersion", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8f6f\u4ef6\u7248\u672cSVER", (String)"version"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u724c", (String)"brand", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u5730", (String)"productArea", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6700\u5c0f\u5305\u88c5", (String)"minPackage"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"MSL\u7b49\u7ea7", (String)"msdRank"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"ESD\u7b49\u7ea7", (String)"esdRank"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"PCB\u7b49\u7ea7", (String)"pcbRank"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"LED\u7b49\u7ea7", (String)"ledRank"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u724c\u7c7b\u578b", (String)"brandType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6253\u5370\u5c3a\u5bf8", (String)"printSize", (boolean)true));
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u8be2\u534e\u9633\u4f9b\u5e94\u5546\u7269\u6599")
    @RequestMapping(value={"service/findByPageForPurchase"})
    @ResponseBody
    public ResponseResult<PageView<SupplierMaterial>> findByPageForPurchase(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupplierMaterial") @RequestBody(required=false) QueryParamWapper wapper) {
        SupplierMaterialExample example = new SupplierMaterialExample();
        example.setPageView(new PageView<SupplierMaterial>(pageNo, pageSize));
        example.setOrderByClause(" MATERIAL_CODE ASC ");
        SupplierMaterialExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.supplierMaterialService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

