/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PricingCommand
extends AbstractInquiryCommand<String> {
    private PurOrder purOrder;

    public PricingCommand(PurOrder purOrder) {
        this.purOrder = purOrder;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotBlank(this.purOrder.getTemplateId(), "\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        this.valid(this.purOrder);
        TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.purOrder.getTemplateId());
        List<IOrderItem> orderItemList = this.purOrder.getItemList().parallelStream().filter(orderItem -> {
            IOrderItem temp = (IOrderItem)templateConf.getOrderItemService().queryObjById(orderItem.getId());
            return InquiryQuoteStatus.QUOTED.getCode().equals(temp.getQuotationStatus()) || InquiryQuoteStatus.REQUOTED.getCode().equals(temp.getQuotationStatus()) || InquiryQuoteStatus.REQUOTE.getCode().equals(temp.getQuotationStatus());
        }).filter(orderItem -> StringUtils.isNotBlank((String)orderItem.getMaterialCode()) || StringUtils.isNotBlank((String)orderItem.getSupCompanySapCode()) || OperationTypeEnum.isPricingOperation(orderItem.getOperation())).collect(Collectors.toList());
        List<IMould> mouldList = this.purOrder.getMouldList();
        if (CollectionUtils.isEmpty(mouldList)) {
            orderItemList.forEach(orderItem -> this.modifyStatus(templateConf, (IOrderItem)orderItem, null));
        } else {
            orderItemList.forEach(orderItem -> mouldList.forEach(mould -> {
                if (StringUtils.isNotBlank((String)mould.getMaterialDesc()) && mould.getSupOrderId().equals(orderItem.getSupOrderId()) && mould.getMaterialDesc().equals(orderItem.getMaterialDesc())) {
                    this.modifyStatus(templateConf, (IOrderItem)orderItem, (IMould)mould);
                } else {
                    this.modifyStatus(templateConf, (IOrderItem)orderItem, null);
                }
            }));
        }
        return null;
    }

    public void modifyStatus(TemplateConf templateConf, IOrderItem orderItem, IMould mould) {
        try {
            IOrderItem tempItem = templateConf.getOrderItemClass().newInstance();
            tempItem.setId(orderItem.getId());
            tempItem.setOperation(orderItem.getOperation());
            tempItem.setMaterialCode(orderItem.getMaterialCode());
            tempItem.setSupCompanySapCode(orderItem.getSupCompanySapCode());
            templateConf.getOrderItemService().modifyObj(tempItem);
            if (mould != null) {
                IMould tempMould = templateConf.getMouldClass().newInstance();
                tempMould.setId(mould.getId());
                tempMould.setRowStatus(orderItem.getOperation());
                tempMould.setMaterialDesc(mould.getMaterialDesc());
                templateConf.getMouldService().modifyStatus(tempMould);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private void valid(PurOrder purOrder) {
        if (!InquiryOrderStatus.PUBLISHED.getCode().equals(purOrder.getInquiryOrderStatus())) {
            throw new CommonException("\u8be2\u4ef7\u5355\u53d1\u5e03\u4e4b\u540e\u624d\u80fd\u8fdb\u884c\u5b9a\u4ef7");
        }
        if (InquiryAuditStatus.AUDITING.getCode().equals(purOrder.getAuditStatus())) {
            throw new CommonException("\u8be2\u4ef7\u5355\u5ba1\u6838\u4e2d\uff0c\u65e0\u6cd5\u5b9a\u4ef7");
        }
        if (InquiryAuditStatus.AUDIT_PASS.getCode().equals(purOrder.getAuditStatus())) {
            throw new CommonException("\u8be2\u4ef7\u5355\u5ba1\u6838\u5df2\u901a\u8fc7\uff0c\u65e0\u6cd5\u5b9a\u4ef7");
        }
        purOrder.getItemList().forEach(item -> {
            if (OperationTypeEnum.isPricingOperation(item.getOperation()) && !InquiryQuoteStatus.QUOTED.getCode().equals(item.getQuotationStatus()) && !InquiryQuoteStatus.REQUOTED.getCode().equals(item.getQuotationStatus())) {
                throw new CommonException("\u53ea\u6709\u5df2\u62a5\u4ef7\u6216\u5df2\u91cd\u62a5\u7684\u7269\u6599\u624d\u80fd\u6267\u884c\u5b9a\u4ef7\u64cd\u4f5c");
            }
        });
    }
}

