/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.OrderItemM001Example;
import com.els.base.inquiry.service.OrderItemM001Service;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"orderItemM001"})
public class OrderItemM001Controller {
    @Resource
    protected OrderItemM001Service orderItemM001Service;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody OrderItemM001 orderItemM001) {
        this.orderItemM001Service.addObj(orderItemM001);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody OrderItemM001 orderItemM001) {
        Assert.isNotBlank(orderItemM001.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.orderItemM001Service.modifyObj(orderItemM001);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.orderItemM001Service.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OrderItemM001", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OrderItemM001>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OrderItemM001Example example = new OrderItemM001Example();
        example.setPageView(new PageView<OrderItemM001>(pageNo, pageSize));
        OrderItemM001Example.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.orderItemM001Service.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u8be2\u62a5\u4ef7M001\u6253\u5370")
    @RequestMapping(value={"service/print"})
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u6570\u636e\u4e3a\u7a7a");
        FileData fileData = this.orderItemM001Service.print(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), ids);
        return ResponseResult.success(fileData);
    }
}

