/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.material.dao.MaterialMapper;
import com.els.base.material.dao.MaterialSealRefMapper;
import com.els.base.material.entity.MaterialSealRef;
import com.els.base.material.entity.MaterialSealRefExample;
import com.els.base.material.service.MaterialSealRefService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialSealRefService")
public class MaterialSealRefServiceImpl
implements MaterialSealRefService {
    @Resource
    protected MaterialSealRefMapper materialSealRefMapper;
    @Resource
    protected MaterialMapper materialMapper;

    @Override
    @CacheEvict(value={"materialSealRef"}, allEntries=true)
    @Transactional
    public void addObj(MaterialSealRef t) {
        this.materialSealRefMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"materialSealRef"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialSealRefMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"materialSealRef"}, allEntries=true)
    public void modifyObj(MaterialSealRef t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialSealRefMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"materialSealRef"}, keyGenerator="redisKeyGenerator")
    public MaterialSealRef queryObjById(String id) {
        return this.materialSealRefMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"materialSealRef"}, keyGenerator="redisKeyGenerator")
    public List<MaterialSealRef> queryAllObjByExample(MaterialSealRefExample example) {
        return this.materialSealRefMapper.selectByExample(example);
    }

    @Override
    public PageView<MaterialSealRef> queryObjByPage(MaterialSealRefExample example) {
        PageView<MaterialSealRef> pageView = example.getPageView();
        example.setOrderByClause(" create_time desc ");
        pageView.setQueryResult(this.materialSealRefMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"materialSealRef"}, allEntries=true)
    public void importMaterailRefSeal(List<MaterialSealRef> materialSeals) {
        if (materialSeals != null) {
            for (MaterialSealRef ms : materialSeals) {
                MaterialSealRefExample example = new MaterialSealRefExample();
                MaterialSealRefExample.Criteria criteria = example.createCriteria();
                criteria.andCompanyIdEqualTo(ms.getCompanyId());
                criteria.andProjectIdEqualTo(ms.getProjectId());
                criteria.andCustomsNoEqualTo(ms.getCustomsNo());
                criteria.andMaterialCodeEqualTo(ms.getMaterialCode());
                List<MaterialSealRef> lists = this.materialSealRefMapper.selectByExample(example);
                if (lists == null || lists.isEmpty()) {
                    this.addObj(ms);
                    continue;
                }
                for (MaterialSealRef temp : lists) {
                    temp.setModifyTime(ms.getModifyTime());
                    temp.setDisabledDate(ms.getDisabledDate());
                    temp.setIsEnable(ms.getIsEnable());
                    temp.setDisabledState(ms.getDisabledState());
                    this.modifyObj(temp);
                }
            }
        }
    }
}

