/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.MaterialSeal;
import com.els.base.material.entity.MaterialSealExample;
import com.els.base.material.service.MaterialSealService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5173\u5c01\u4fe1\u606f")
@Controller
@RequestMapping(value={"materialSeal"})
public class MaterialSealController {
    @Resource
    protected MaterialSealService materialSealService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5173\u5c01\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MaterialSeal materialSeal) {
        materialSeal.setCompanyId(CompanyUtils.currentCompanyId());
        materialSeal.setProjectId(ProjectUtils.getProjectId());
        this.materialSealService.addObj(materialSeal);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5173\u5c01\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterialSeal materialSeal) {
        if (StringUtils.isBlank((String)materialSeal.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "id_is_blank");
        }
        this.materialSealService.modifyObj(materialSeal);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5173\u5c01\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25", "id_is_blank");
        }
        this.materialSealService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5173\u5c01\u4fe1\u606f")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialSeal>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialSeal") @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialSealExample example = new MaterialSealExample();
        example.setPageView(new PageView<MaterialSeal>(pageNo, pageSize));
        MaterialSealExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.materialSealService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

