/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingBondMapper;
import com.els.base.bidding.entity.BiddingBond;
import com.els.base.bidding.entity.BiddingBondExample;
import com.els.base.bidding.service.BiddingBondService;
import com.els.base.core.entity.PageView;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultBiddingBondService")
public class BiddingBondServiceImpl
implements BiddingBondService {
    @Resource
    protected BiddingBondMapper biddingBondMapper;

    @Override
    @CacheEvict(value={"biddingBond"}, allEntries=true)
    public void addObj(BiddingBond t) {
        t.setCreateTime(new Date());
        this.biddingBondMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"biddingBond"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingBondMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"biddingBond"}, allEntries=true)
    public void modifyObj(BiddingBond t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingBondMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"biddingBond"}, keyGenerator="redisKeyGenerator")
    public BiddingBond queryObjById(String id) {
        return this.biddingBondMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<BiddingBond> queryAllObjByExample(BiddingBondExample example) {
        return this.biddingBondMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"biddingBond"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingBond> queryObjByPage(BiddingBondExample example) {
        PageView<BiddingBond> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingBondMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingBondExample biddingBondExample = new BiddingBondExample();
        biddingBondExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingBond> biddingBondList = this.biddingBondMapper.selectByExample(biddingBondExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingBondList) && i < biddingBondList.size(); ++i) {
            this.biddingBondMapper.deleteByPrimaryKey(biddingBondList.get(i).getId());
        }
    }

    @Override
    @CacheEvict(value={"biddingBond"}, allEntries=true)
    public void modifyObjSup(BiddingBond biddingBond, BiddingBondExample biddingBondExample) {
        this.biddingBondMapper.updateByExampleSelective(biddingBond, biddingBondExample);
    }
}

