/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingContentMatterMapper;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentMatterExample;
import com.els.base.bidding.service.BiddingContentMatterService;
import com.els.base.core.entity.PageView;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingContentMatterService")
public class BiddingContentMatterServiceImpl
implements BiddingContentMatterService {
    @Resource
    protected BiddingContentMatterMapper biddingContentMatterMapper;

    @Override
    @CacheEvict(value={"biddingContentMatter"}, allEntries=true)
    public void addObj(BiddingContentMatter t) {
        this.biddingContentMatterMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingContentMatter"}, allEntries=true)
    public void addAll(List<BiddingContentMatter> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingContentMatterMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"biddingContentMatter"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingContentMatterMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"biddingContentMatter"}, allEntries=true)
    public void modifyObj(BiddingContentMatter t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingContentMatterMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"biddingContentMatter"}, keyGenerator="redisKeyGenerator")
    public BiddingContentMatter queryObjById(String id) {
        return this.biddingContentMatterMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"biddingContentMatter"}, keyGenerator="redisKeyGenerator")
    public List<BiddingContentMatter> queryAllObjByExample(BiddingContentMatterExample example) {
        return this.biddingContentMatterMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"biddingContentMatter"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingContentMatter> queryObjByPage(BiddingContentMatterExample example) {
        PageView<BiddingContentMatter> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingContentMatterMapper.selectByExampleByPage(example));
        return pageView;
    }
}

