/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingFileMapper;
import com.els.base.bidding.entity.BiddingFile;
import com.els.base.bidding.entity.BiddingFileExample;
import com.els.base.bidding.service.BiddingFileService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultBiddingFileService")
public class BiddingFileServiceImpl
implements BiddingFileService {
    @Resource
    protected BiddingFileMapper biddingFileMapper;

    @Override
    @CacheEvict(value={"biddingFile"}, allEntries=true)
    public void addObj(BiddingFile t) {
        this.biddingFileMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"biddingFile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingFileMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"biddingFile"}, allEntries=true)
    public void modifyObj(BiddingFile t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingFileMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"biddingFile"}, keyGenerator="redisKeyGenerator")
    public BiddingFile queryObjById(String id) {
        return this.biddingFileMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<BiddingFile> queryAllObjByExample(BiddingFileExample example) {
        return this.biddingFileMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"biddingFile"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingFile> queryObjByPage(BiddingFileExample example) {
        PageView<BiddingFile> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingFileExample biddingFileExample = new BiddingFileExample();
        biddingFileExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingFile> biddingFileList = this.biddingFileMapper.selectByExample(biddingFileExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingFileList) && i < biddingFileList.size(); ++i) {
            this.biddingFileMapper.deleteByPrimaryKey(biddingFileList.get(i).getId());
        }
    }
}

