/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.bidding.dao.BiddingOnlineMapper;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingOnline;
import com.els.base.bidding.entity.BiddingOnlineExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.enums.ContentTypeEnum;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingOnlineService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingOnlineService")
public class BiddingOnlineServiceImpl
implements BiddingOnlineService {
    @Resource
    protected BiddingOnlineMapper biddingOnlineMapper;
    @Resource
    private BiddingHeaderService biddingHeaderService;
    @Resource
    private BiddingSupplierService biddingSupplierService;

    @Override
    @CacheEvict(value={"biddingOnline"}, allEntries=true)
    public void addObj(BiddingOnline t) {
        this.biddingOnlineMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"biddingOnline"}, allEntries=true)
    @Transactional
    public void insert(Company supCompany, User loginUser, BiddingOnline biddingOnline) {
        if (0 != biddingOnline.getPriceCutPercentage().compareTo(BigDecimal.ZERO.toString()) && null != biddingOnline.getBeforeUntaxedPrice()) {
            BigDecimal tamp = null;
            tamp = "%".equals(biddingOnline.getAmplitudeUnit()) ? new BigDecimal(biddingOnline.getBeforeUntaxedPrice()).multiply(new BigDecimal(100).subtract(new BigDecimal(biddingOnline.getPriceCutPercentage()))).divide(new BigDecimal(100)).setScale(2, 4) : new BigDecimal(biddingOnline.getBeforeUntaxedPrice()).subtract(new BigDecimal(biddingOnline.getPriceCutPercentage())).setScale(2, 4);
            BigDecimal bigDecimal = new BigDecimal(biddingOnline.getUntaxedUnitPrice());
            if (bigDecimal.doubleValue() > tamp.doubleValue()) {
                throw new CommonException("\u6839\u636e\u964d\u4ef7\u5e45\u5ea6\uff0c\u6b64\u6b21\u62a5\u4ef7\u7684\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u5927\u4e8e\uff1a" + tamp);
            }
        }
        biddingOnline.setSupCompanyId(supCompany.getId());
        biddingOnline.setSupCompanyName(supCompany.getCompanyFullName());
        biddingOnline.setSupCompanySrmCode(supCompany.getCompanyCode());
        biddingOnline.setSupUserId(loginUser.getId());
        biddingOnline.setSupUserName(loginUser.getLoginName());
        biddingOnline.setOfferTime(new Date());
        biddingOnline.setCreateTime(new Date());
        biddingOnline.setQuotationState("1");
        if (biddingOnline.getContentType() == null) {
            biddingOnline.setContentType(ContentTypeEnum.MATERIAL.getCode());
        }
        this.biddingOnlineMapper.insertSelective(biddingOnline);
        BiddingSupplier supplier = new BiddingSupplier();
        supplier.setSupBidding("1");
        supplier.setLastUpdateTime(new Date());
        supplier.setLastUpdateUser(loginUser.getNickName());
        BiddingSupplierExample supplierExample = new BiddingSupplierExample();
        supplierExample.createCriteria().andBiddingNoEqualTo(biddingOnline.getBiddingNo()).andSupCompanyIdEqualTo(supCompany.getId());
        this.biddingSupplierService.modifyObjSup(supplier, supplierExample);
    }

    @Override
    @CacheEvict(value={"biddingOnline"}, allEntries=true)
    public void batchInvalidationById(List<String> ids) {
        Assert.isNotEmpty(ids, "ID\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        BiddingOnline biddingOnline = this.queryObjById(ids.get(0));
        BiddingHeaderExample headerExample = new BiddingHeaderExample();
        headerExample.createCriteria().andBiddingNoEqualTo(biddingOnline.getBiddingNo());
        List biddingHeaderList = this.biddingHeaderService.queryAllObjByExample(headerExample);
        Assert.isNotEmpty(biddingHeaderList, "\u6839\u636e\u62db\u6807\u5355\u53f7\u67e5\u8be2\u51fa\u7684\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        if ("2".equals(((BiddingHeader)biddingHeaderList.get(0)).getBiddingAuditstatus())) {
            throw new CommonException("\u5355\u636e\u5b9a\u6807\u5ba1\u6279\u5df2\u901a\u8fc7\uff0c\u4e0d\u80fd\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c");
        }
        if (TenderStatusEumn.BIDOVER.getValue().equals(((BiddingHeader)biddingHeaderList.get(0)).getBiddingStatus())) {
            throw new CommonException("\u5355\u636e\u5df2\u8bc4\u6807\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c");
        }
        BiddingOnlineExample example = new BiddingOnlineExample();
        example.createCriteria().andIdIn((List)ids).andQuotationStateEqualTo("0");
        if (this.biddingOnlineMapper.countByExample(example) > 0) {
            throw new CommonException("\u6240\u9009\u62a5\u4ef7\u4fe1\u606f\u5305\u542b\u65e0\u6548\u7ade\u4ef7\uff0c\u4f5c\u5e9f\u5931\u8d25");
        }
        example.clear();
        BiddingOnline online = new BiddingOnline();
        online.setQuotationState("0");
        example.createCriteria().andIdIn((List)ids);
        this.biddingOnlineMapper.updateByExampleSelective(online, example);
    }

    @Override
    @CacheEvict(value={"biddingOnline"}, allEntries=true)
    public void winTheBiddingById(String id) {
        BiddingOnline biddingOnline = this.queryObjById(id);
        BiddingHeaderExample headerExample = new BiddingHeaderExample();
        headerExample.createCriteria().andBiddingNoEqualTo(biddingOnline.getBiddingNo());
        List biddingHeaderList = this.biddingHeaderService.queryAllObjByExample(headerExample);
        Assert.isNotEmpty(biddingHeaderList, "\u6839\u636e\u62db\u6807\u5355\u53f7\u67e5\u8be2\u51fa\u7684\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        if ("2".equals(((BiddingHeader)biddingHeaderList.get(0)).getBiddingAuditstatus())) {
            throw new CommonException("\u5355\u636e\u5b9a\u6807\u5ba1\u6279\u5df2\u901a\u8fc7\uff0c\u4e0d\u80fd\u518d\u4fee\u6539\u4e2d\u6807\u72b6\u6001");
        }
        if (TenderStatusEumn.BIDOVER.getValue().equals(((BiddingHeader)biddingHeaderList.get(0)).getBiddingStatus())) {
            throw new CommonException("\u5355\u636e\u5df2\u8bc4\u6807\uff0c\u4e0d\u80fd\u518d\u4fee\u6539\u4e2d\u6807\u72b6\u6001");
        }
        if (!"1".equals(biddingOnline.getQuotationState())) {
            throw new CommonException("\u6240\u9009\u62a5\u4ef7\u4fe1\u606f\u4e3a\u65e0\u6548\u7ade\u4ef7\u6216\u5df2\u4e2d\u6807\u72b6\u6001\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        BiddingOnlineExample example = new BiddingOnlineExample();
        example.createCriteria().andBiddingNoEqualTo(biddingOnline.getBiddingNo()).andTempMaterialCodeEqualTo(biddingOnline.getTempMaterialCode());
        List<BiddingOnline> onlineList = this.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(onlineList)) {
            onlineList.forEach(online -> {
                if ("2".equals(online.getQuotationState())) {
                    throw new CommonException("\u5df2\u6709\u4e00\u6761\u62a5\u4ef7\u4e2d\u6807\uff0c\u4e0d\u80fd\u518d\u9009\u62e9\u5176\u4ed6\u62a5\u4ef7");
                }
            });
        }
        biddingOnline.setQuotationState("2");
        this.modifyObj(biddingOnline);
    }

    @Override
    @CacheEvict(value={"biddingOnline"}, allEntries=true)
    public void noWinTheBiddingById(String id) {
        BiddingOnline biddingOnline = this.queryObjById(id);
        BiddingHeaderExample headerExample = new BiddingHeaderExample();
        headerExample.createCriteria().andBiddingNoEqualTo(biddingOnline.getBiddingNo());
        List biddingHeaderList = this.biddingHeaderService.queryAllObjByExample(headerExample);
        Assert.isNotEmpty(biddingHeaderList, "\u6839\u636e\u62db\u6807\u5355\u53f7\u67e5\u8be2\u51fa\u7684\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        if ("2".equals(((BiddingHeader)biddingHeaderList.get(0)).getBiddingAuditstatus())) {
            throw new CommonException("\u5355\u636e\u5b9a\u6807\u5ba1\u6279\u5df2\u901a\u8fc7\uff0c\u4e0d\u80fd\u518d\u4fee\u6539\u4e2d\u6807\u72b6\u6001");
        }
        if (TenderStatusEumn.BIDOVER.getValue().equals(((BiddingHeader)biddingHeaderList.get(0)).getBiddingStatus())) {
            throw new CommonException("\u5355\u636e\u5df2\u8bc4\u6807\uff0c\u4e0d\u80fd\u518d\u4fee\u6539\u4e2d\u6807\u72b6\u6001");
        }
        if (!"2".equals(biddingOnline.getQuotationState())) {
            throw new CommonException("\u6240\u9009\u62a5\u4ef7\u4e0d\u662f\u4e2d\u6807\u72b6\u6001\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        biddingOnline.setQuotationState("1");
        this.modifyObj(biddingOnline);
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingOnline"}, allEntries=true)
    public void addAll(List<BiddingOnline> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingOnlineMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"biddingOnline"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingOnlineMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"biddingOnline"}, allEntries=true)
    public void deleteByExample(BiddingOnlineExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.biddingOnlineMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"biddingOnline"}, allEntries=true)
    public void modifyObj(BiddingOnline t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.biddingOnlineMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingOnline"}, allEntries=true)
    public void submitResult(List<BiddingOnline> list) {
        BiddingHeaderExample headerExample = new BiddingHeaderExample();
        headerExample.createCriteria().andBiddingNoEqualTo(list.get(0).getBiddingNo());
        List headerList = this.biddingHeaderService.queryAllObjByExample(headerExample);
        Assert.isNotEmpty(headerList, "\u6839\u636e\u62db\u6807\u5355\u53f7\u67e5\u8be2\u7684\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        if (System.currentTimeMillis() < ((BiddingHeader)headerList.get(0)).getBiddingEnddate().getTime()) {
            throw new CommonException("\u6700\u540e\u4e00\u8f6e\u6295\u6807\u6ca1\u7ed3\u675f\uff0c\u4e0d\u80fd\u63d0\u4ea4\u8bc4\u6807\u7ed3\u679c");
        }
        if (TenderStatusEumn.BIDOVER.getValue().equals(((BiddingHeader)headerList.get(0)).getBiddingStatus()) || TenderStatusEumn.ISFINISH.getValue().equals(((BiddingHeader)headerList.get(0)).getBiddingStatus()) || TenderStatusEumn.ISSCALING.getValue().equals(((BiddingHeader)headerList.get(0)).getBiddingStatus())) {
            throw new CommonException("\u8bc4\u6807\u7ed3\u679c\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u91cd\u590d\u6267\u884c\u63d0\u4ea4\u8bc4\u6807\u7ed3\u679c\u64cd\u4f5c");
        }
        Boolean flag = true;
        for (BiddingOnline biddingOnline : list) {
            if (!"2".equals(biddingOnline.getQuotationState())) continue;
            flag = false;
            break;
        }
        if (flag.booleanValue()) {
            throw new CommonException("\u63d0\u4ea4\u7684\u8bc4\u6807\u7ed3\u679c\u4e2d\uff0c\u6ca1\u6709\u8bbe\u7f6e\u4f9b\u5e94\u5546\u4e2d\u6807");
        }
        BiddingOnlineExample biddingOnlineExample = new BiddingOnlineExample();
        biddingOnlineExample.createCriteria().andBiddingIdEqualTo(list.get(0).getBiddingNo()).andTempMaterialCodeNotEqualTo(list.get(0).getTempMaterialCode());
        List<BiddingOnline> otherBiddingOnlines = this.queryAllObjByExample(biddingOnlineExample);
        if (CollectionUtils.isNotEmpty(otherBiddingOnlines)) {
            biddingOnlineExample.createCriteria().andQuotationStateEqualTo("2");
            List<BiddingOnline> otherQuotation = this.queryAllObjByExample(biddingOnlineExample);
            if (CollectionUtils.isEmpty(otherQuotation)) {
                return;
            }
        }
        if (CollectionUtils.isNotEmpty(headerList)) {
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(((BiddingHeader)headerList.get(0)).getId());
            biddingHeader.setBiddingStatus(TenderStatusEumn.BIDOVER.getValue());
            biddingHeader.setBiddingAuditstatus("0");
            biddingHeader.setBidSubmitDate(new Date());
            this.biddingHeaderService.modifyObj(biddingHeader);
        }
        BiddingSupplierExample supplierExample = new BiddingSupplierExample();
        supplierExample.createCriteria().andBiddingNoEqualTo(list.get(0).getBiddingNo()).andSupBiddingStatusEqualTo(TenderStatusEumn.ISBID.getValue());
        supplierExample.or().andSupBiddingStatusEqualTo(TenderStatusEumn.INBID.getValue());
        List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample(supplierExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
            BiddingSupplier biddingSupplier = new BiddingSupplier();
            biddingSupplier.setId(((BiddingSupplier)biddingSupplierList.get(i)).getId());
            biddingSupplier.setSupBiddingStatus(TenderStatusEumn.BIDOVER.getValue());
            this.biddingSupplierService.modifyObj(biddingSupplier);
        }
    }

    @Override
    @Cacheable(value={"biddingOnline"}, keyGenerator="redisKeyGenerator")
    public BiddingOnline queryObjById(String id) {
        return this.biddingOnlineMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"biddingOnline"}, keyGenerator="redisKeyGenerator")
    public List<BiddingOnline> queryAllObjByExample(BiddingOnlineExample example) {
        return this.biddingOnlineMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"biddingOnline"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingOnline> queryObjByPage(BiddingOnlineExample example) {
        PageView<BiddingOnline> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingOnlineMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<BiddingOnline> queryAllObj(BiddingOnlineExample example) {
        return this.biddingOnlineMapper.selectCompanyRankingByExample(example);
    }
}

