/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingSupplierHisMapper;
import com.els.base.bidding.entity.BiddingSupplierHis;
import com.els.base.bidding.entity.BiddingSupplierHisExample;
import com.els.base.bidding.service.BiddingSupplierHisService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingSupplierHisService")
public class BiddingSupplierHisServiceImpl
implements BiddingSupplierHisService {
    @Resource
    protected BiddingSupplierHisMapper biddingSupplierHisMapper;

    @Override
    @CacheEvict(value={"biddingSupplierHis"}, allEntries=true)
    public void addObj(BiddingSupplierHis t) {
        this.biddingSupplierHisMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingSupplierHis"}, allEntries=true)
    public void addAll(List<BiddingSupplierHis> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingSupplierHisMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"biddingSupplierHis"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingSupplierHisMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"biddingSupplierHis"}, allEntries=true)
    public void deleteByExample(BiddingSupplierHisExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.biddingSupplierHisMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"biddingSupplierHis"}, allEntries=true)
    public void modifyObj(BiddingSupplierHis t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.biddingSupplierHisMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"biddingSupplierHis"}, keyGenerator="redisKeyGenerator")
    public BiddingSupplierHis queryObjById(String id) {
        return this.biddingSupplierHisMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"biddingSupplierHis"}, keyGenerator="redisKeyGenerator")
    public List<BiddingSupplierHis> queryAllObjByExample(BiddingSupplierHisExample example) {
        return this.biddingSupplierHisMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"biddingSupplierHis"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingSupplierHis> queryObjByPage(BiddingSupplierHisExample example) {
        PageView<BiddingSupplierHis> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingSupplierHisMapper.selectByExampleByPage(example));
        return pageView;
    }
}

