/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.bidding.dao.BiddingSupplierMapper;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultBiddingSupplierService")
public class BiddingSupplierServiceImpl
implements BiddingSupplierService {
    @Resource
    protected BiddingSupplierMapper biddingSupplierMapper;
    @Resource
    protected BiddingHeaderService biddingHeaderService;
    @Resource
    protected BiddingOfferService biddingOfferService;
    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;

    @Override
    @CacheEvict(value={"biddingSupplier"}, allEntries=true)
    public void addObj(BiddingSupplier t) {
        t.setCreateTime(new Date());
        this.biddingSupplierMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"biddingSupplier"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingSupplierMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"biddingSupplier"}, allEntries=true)
    public void modifyObj(BiddingSupplier t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingSupplierMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @CacheEvict(value={"biddingSupplier"}, allEntries=true)
    public void modifyObjCustom(BiddingSupplier t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingSupplierMapper.updateByPrimaryKeySelectiveCustom(t);
    }

    @Override
    @CacheEvict(value={"biddingSupplier"}, allEntries=true)
    public void modifyObjSup(BiddingSupplier biddingSupplier, BiddingSupplierExample biddingSupplierExample) {
        this.biddingSupplierMapper.updateByExampleSelective(biddingSupplier, biddingSupplierExample);
    }

    @Override
    @Cacheable(value={"biddingSupplier"}, keyGenerator="redisKeyGenerator")
    public BiddingSupplier queryObjById(String id) {
        return this.biddingSupplierMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<BiddingSupplier> queryAllObjByExample(BiddingSupplierExample example) {
        return this.biddingSupplierMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"biddingSupplier"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingSupplier> queryObjByPage(BiddingSupplierExample example) {
        PageView<BiddingSupplier> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingSupplierMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        biddingSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierMapper.selectByExample(biddingSupplierExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
            this.biddingSupplierMapper.deleteByPrimaryKey(biddingSupplierList.get(i).getId());
        }
    }

    @Override
    @CacheEvict(value={"biddingSupplier"}, allEntries=true)
    public void supEditStatus(String biddingNo, String statuType, String statu, Company company, User user) {
        BiddingSupplier biddingSupplier = new BiddingSupplier();
        biddingSupplier.setLastUpdateTime(new Date());
        biddingSupplier.setLastUpdateUser(user.getNickName());
        if (statuType.equals("A")) {
            String supBiddingStatus = "";
            String supParticipate = "";
            if (statu.equals("Y")) {
                supBiddingStatus = TenderStatusEumn.ISBID.getValue();
                supParticipate = "1";
            } else if (statu.equals("N")) {
                supBiddingStatus = TenderStatusEumn.REFUSEBID.getValue();
                supParticipate = "2";
            }
            biddingSupplier.setSupParticipate(supParticipate);
            biddingSupplier.setSupBiddingStatus(supBiddingStatus);
            this.updateBiddingStatus(biddingSupplier, biddingNo, company);
            BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria createCriteria = biddingSupplierExample.createCriteria();
            createCriteria.andBiddingNoEqualTo(biddingNo);
            List<BiddingSupplier> totalSumList = this.biddingSupplierMapper.selectByExample(biddingSupplierExample);
            int totalSum = totalSumList.size();
            createCriteria.andSupBiddingStatusEqualTo(supBiddingStatus);
            List<BiddingSupplier> sumList = this.biddingSupplierMapper.selectByExample(biddingSupplierExample);
            int sum = sumList.size();
            String purBiddingStatus = "";
            if (statu.equals("Y")) {
                purBiddingStatus = sum >= totalSum ? TenderStatusEumn.ALLBID.getValue() : TenderStatusEumn.PARTBID.getValue();
            } else if (statu.equals("N")) {
                purBiddingStatus = sum >= totalSum ? TenderStatusEumn.ALLREFUSEBID.getValue() : null;
            }
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setLastUpdateTime(new Date());
            biddingHeader.setLastUpdateUser(user.getNickName());
            biddingHeader.setBiddingStatus(purBiddingStatus);
            BiddingHeaderExample example = new BiddingHeaderExample();
            BiddingHeaderExample.Criteria biddingCriteria = example.createCriteria();
            biddingCriteria.andBiddingNoEqualTo(biddingNo);
            this.biddingHeaderService.editStatus(biddingHeader, example);
        } else if (statuType.equals("B")) {
            biddingSupplier.setSupBidding(statu);
            this.updateBiddingStatus(biddingSupplier, biddingNo, company);
        }
    }

    private void updateBiddingStatus(BiddingSupplier biddingSupplier, String biddingNo, Company company) {
        BiddingSupplierExample example = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria biddingCriteria = example.createCriteria();
        biddingCriteria.andBiddingNoEqualTo(biddingNo);
        biddingCriteria.andSupCompanyIdEqualTo(company.getId());
        this.biddingSupplierMapper.updateByExampleSelective(biddingSupplier, example);
    }

    @Override
    public void save(BiddingBaseVo biddingBaseVo, Company currentCompany, User loginUser) throws InstantiationException, IllegalAccessException {
        int i;
        BiddingHeader biddingHeader = biddingBaseVo.getBiddingHeader();
        BiddingSupplierExample example = new BiddingSupplierExample();
        example.createCriteria().andBiddingNoEqualTo(biddingHeader.getBiddingNo());
        List<BiddingSupplier> biddingSupplierListDataBase = this.biddingSupplierMapper.selectByExample(example);
        List<BiddingSupplier> biddingSupplierList = biddingBaseVo.getBiddingSupplierList();
        ArrayList<BiddingSupplier> biddingSupplierListSave = new ArrayList<BiddingSupplier>();
        ArrayList<BiddingSupplier> biddingSupplierListUpdate = new ArrayList<BiddingSupplier>();
        ArrayList<BiddingSupplier> biddingSupplierListDelete = new ArrayList<BiddingSupplier>();
        if (CollectionUtils.isEmpty(biddingSupplierListDataBase)) {
            biddingSupplierListSave.addAll(biddingSupplierList);
        } else if (CollectionUtils.isEmpty(biddingSupplierList)) {
            biddingSupplierListDelete.addAll(biddingSupplierListDataBase);
        } else {
            biddingSupplierListSave.addAll(biddingSupplierList);
            biddingSupplierListDelete.addAll(biddingSupplierListDataBase);
            for (BiddingSupplier biddingSupplier : biddingSupplierList) {
                for (BiddingSupplier supplierDataBase : biddingSupplierListDataBase) {
                    if (!biddingSupplier.getSupCompanySrmCode().equals(supplierDataBase.getSupCompanySrmCode())) continue;
                    if (biddingSupplier.getId() == null) {
                        biddingSupplier.setId(supplierDataBase.getId());
                    }
                    biddingSupplierListUpdate.add(biddingSupplier);
                    biddingSupplierListSave.remove(biddingSupplier);
                    biddingSupplierListDelete.remove(supplierDataBase);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(biddingSupplierListSave)) {
            for (int i2 = 0; CollectionUtils.isNotEmpty(biddingSupplierListSave) && i2 < biddingSupplierListSave.size(); ++i2) {
                this.biddingHeaderService.addBiddingSupplier((BiddingSupplier)biddingSupplierListSave.get(i2), biddingHeader, currentCompany, loginUser);
            }
            this.biddingHeaderService.insertIntoOffer(biddingHeader.getId(), biddingSupplierListSave);
        }
        for (i = 0; CollectionUtils.isNotEmpty(biddingSupplierListUpdate) && i < biddingSupplierListUpdate.size(); ++i) {
            this.biddingSupplierMapper.updateByPrimaryKeySelective((BiddingSupplier)biddingSupplierListUpdate.get(i));
        }
        for (i = 0; CollectionUtils.isNotEmpty(biddingSupplierListDelete) && i < biddingSupplierListDelete.size(); ++i) {
            this.biddingSupplierMapper.deleteByPrimaryKey(((BiddingSupplier)biddingSupplierListDelete.get(i)).getId());
            this.biddingOfferService.deleteBySupCompanyId(biddingHeader.getBiddingNo(), ((BiddingSupplier)biddingSupplierListDelete.get(i)).getSupCompanyId());
            this.biddingMatterStepSupService.deleteBySupCompanyId(biddingHeader.getBiddingNo(), ((BiddingSupplier)biddingSupplierListDelete.get(i)).getSupCompanyId());
        }
    }
}

