/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentExample;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.service.BiddingContentMatterService;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialService;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u62db\u6807\u5185\u5bb9")
@Controller
@RequestMapping(value={"biddingContent"})
public class BiddingContentController {
    @Resource
    protected BiddingContentService biddingContentService;
    @Resource
    protected BiddingContentMatterService biddingContentMatterService;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected MouldService mouldService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6807\u5185\u5bb9")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingContent biddingContent) {
        this.biddingContentService.addObj(biddingContent);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u62db\u6807\u5185\u5bb9")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingContent biddingContent) {
        Assert.isNotBlank(biddingContent.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingContentService.modifyObj(biddingContent);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u62db\u6807\u5185\u5bb9")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingContentService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6807\u5185\u5bb9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingContent", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingContent>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingContentExample example = new BiddingContentExample();
        example.setPageView(new PageView<BiddingContent>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.biddingContentService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u62db\u6807\u5185\u5bb9\u5bfc\u51faexcel")
    @RequestMapping(value={"service/downloadExcelBidding"})
    @ResponseBody
    public ModelAndView downloadExcelBidding(@RequestParam(required=true) String type, HttpServletResponse response) {
        try {
            String name = null;
            if (type.equals("material")) {
                name = "\u7269\u6599\u7c7b\u62db\u6807";
            }
            if (type.equals("mould")) {
                name = "\u6a21\u5177\u7c7b\u62db\u6807";
            }
            if (type.equals("device")) {
                name = "\u5176\u4ed6\u7c7b\u62db\u6807";
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode(name + ".xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndModelKeys(type);
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, null, (String)name, null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @ApiOperation(value="\u62db\u6807\u5185\u5bb9\u7269\u6599excel\u5bfc\u5165", httpMethod="POST")
    @RequestMapping(value={"service/uploadMaterialExcel"})
    @ResponseBody
    public ResponseResult<List<BiddingContentMatter>> uploadMaterialExcel(MultipartHttpServletRequest request, @RequestParam(required=true) String type) throws IOException, Exception {
        List importExcelDataToMap = new ArrayList();
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildFile(fileMap);
        List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndModelKeys(type);
        importExcelDataToMap = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, BiddingContentMatter.class);
        for (int i = 0; CollectionUtils.isNotEmpty(importExcelDataToMap) && i < importExcelDataToMap.size(); ++i) {
            Long dosage = ((BiddingContentMatter)importExcelDataToMap.get(i)).getDosage() == null ? 0L : ((BiddingContentMatter)importExcelDataToMap.get(i)).getDosage();
            BigDecimal unitPrice = ((BiddingContentMatter)importExcelDataToMap.get(i)).getUnitPrice() == null ? BigDecimal.ZERO : ((BiddingContentMatter)importExcelDataToMap.get(i)).getUnitPrice();
            ((BiddingContentMatter)importExcelDataToMap.get(i)).setSetThePrice(unitPrice.multiply(new BigDecimal(dosage)));
            if (!type.equals("material") || !StringUtils.isNotBlank((String)((BiddingContentMatter)importExcelDataToMap.get(i)).getMaterialNo())) continue;
            MaterialExample materialExample = new MaterialExample();
            materialExample.createCriteria().andMaterialCodeEqualTo(((BiddingContentMatter)importExcelDataToMap.get(i)).getMaterialNo());
            List materialList = this.materialService.queryAllObjByExample(materialExample);
            if (materialList.size() > 0) {
                ((BiddingContentMatter)importExcelDataToMap.get(i)).setMaterialName(((Material)materialList.get(0)).getMaterialName());
                ((BiddingContentMatter)importExcelDataToMap.get(i)).setMaterialDesc(((Material)materialList.get(0)).getDescription());
                continue;
            }
            String str = "\u5bfc\u5165\u5931\u8d25\uff01\u7b2c" + (i + 2) + "\u884c\u7684\u7269\u6599\u7f16\u53f7\u3010" + ((BiddingContentMatter)importExcelDataToMap.get(i)).getMaterialNo() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u8bf7\u6838\u5bf9\u540e\u518d\u5bfc\u5165\uff01";
            throw new CommonException("\u7f16\u7801\u4e0d\u5b58\u5728\u4e0d\u80fd\u64cd\u4f5c", "finish_status", str);
        }
        return ResponseResult.success(importExcelDataToMap);
    }

    @ApiOperation(value="\u62db\u6807\u5185\u5bb9\u6a21\u5177excel\u5bfc\u5165", httpMethod="POST")
    @RequestMapping(value={"service/uploadMouldExcel"})
    @ResponseBody
    public ResponseResult<List<BiddingContentModel>> uploadMouldExcel(MultipartHttpServletRequest request, @RequestParam(required=true) String type) throws IOException, Exception {
        List importExcelDataToMap = new ArrayList();
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildFile(fileMap);
        List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndModelKeys(type);
        importExcelDataToMap = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, BiddingContentModel.class);
        for (int i = 0; CollectionUtils.isNotEmpty(importExcelDataToMap) && i < importExcelDataToMap.size(); ++i) {
            if (!type.equals("mould") || !StringUtils.isNotBlank((String)((BiddingContentModel)importExcelDataToMap.get(i)).getModelNo())) continue;
            MouldExample mouldExample = new MouldExample();
            mouldExample.createCriteria().andMouldCodeEqualTo(((BiddingContentModel)importExcelDataToMap.get(i)).getModelNo());
            List mouldList = this.mouldService.queryAllObjByExample(mouldExample);
            if (mouldList.size() > 0) {
                ((BiddingContentModel)importExcelDataToMap.get(i)).setModelDesc(((Mould)mouldList.get(0)).getMouldDesc());
                ((BiddingContentModel)importExcelDataToMap.get(i)).setUseModel(((Mould)mouldList.get(0)).getMouldModel());
                ((BiddingContentModel)importExcelDataToMap.get(i)).setModelSerialNumber(((Mould)mouldList.get(0)).getMouldSerialNumber());
                ((BiddingContentModel)importExcelDataToMap.get(i)).setModelMaterial(((Mould)mouldList.get(0)).getMouldMaterial());
                ((BiddingContentModel)importExcelDataToMap.get(i)).setModelLife(((Mould)mouldList.get(0)).getMouldLifetime().toString());
                ((BiddingContentModel)importExcelDataToMap.get(i)).setPropertyRight(((Mould)mouldList.get(0)).getMouldPropertyRightState());
                ((BiddingContentModel)importExcelDataToMap.get(i)).setModelSinking(((Mould)mouldList.get(0)).getMouldAscription());
                continue;
            }
            String str = "\u5bfc\u5165\u5931\u8d25\uff01\u7b2c" + (i + 2) + "\u884c\u7684\u6a21\u5177\u7f16\u7801\u3010" + ((BiddingContentModel)importExcelDataToMap.get(i)).getModelNo() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u8bf7\u6838\u5bf9\u540e\u518d\u5bfc\u5165\uff01";
            throw new CommonException("\u7f16\u7801\u4e0d\u5b58\u5728\u4e0d\u80fd\u64cd\u4f5c", "finish_status", str);
        }
        return ResponseResult.success(importExcelDataToMap);
    }

    @ApiOperation(value="\u62db\u6807\u5185\u5bb9\u5176\u4ed6excel\u5bfc\u5165", httpMethod="POST")
    @RequestMapping(value={"service/uploadOtherExcel"})
    @ResponseBody
    public ResponseResult<List<BiddingContentOther>> uploadOtherExcel(MultipartHttpServletRequest request, @RequestParam(required=true) String type) {
        List importExcelDataToMap = new ArrayList();
        try {
            Map fileMap = request.getFileMap();
            MultipartFile file = this.vaildFile(fileMap);
            List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndModelKeys(type);
            importExcelDataToMap = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, BiddingContentOther.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success(importExcelDataToMap);
    }

    private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        return file;
    }

    private List<TitleAndModelKey> getTitleAndModelKeys(String type) {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        if (type.equals("material")) {
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u53f7", (String)"materialNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6307\u5b9a\u54c1\u724c", (String)"materialFeatures"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6307\u5b9a\u89c4\u683c", (String)"materialSpec"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6307\u5b9a\u578b\u53f7", (String)"materialModel"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u4f4d", (String)"unit"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62db\u6807\u6570\u91cf", (String)"biddingQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7528\u91cf", (String)"dosage"));
        }
        if (type.equals("mould")) {
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7f16\u7801", (String)"modelNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u63cf\u8ff0", (String)"modelDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f7f\u7528\u673a\u578b", (String)"useModel"));
            TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey((String)"\u6240\u5c5e\u5e74\u4efd", (String)"beloneYear");
            DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey2.setToObjConverter((StrToObjConverter)dateConverter2);
            titleAndModelKey2.setToStrConverter((ObjToStrConverter)dateConverter2);
            titleAndModelKeys.add(titleAndModelKey2);
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u5e8f\u53f7", (String)"modelSerialNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u6750\u6599", (String)"modelMaterial"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u5bff\u547d", (String)"modelLife"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u6743\u72b6\u51b5", (String)"propertyRight"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u6a21\u5f52\u5c5e", (String)"modelSinking"));
        }
        if (type.equals("device")) {
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6807\u7684\u7f16\u7801", (String)"targetNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6807\u7684\u63cf\u8ff0", (String)"taregtDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6807\u7684\u540d\u79f0", (String)"targetName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u4f4d", (String)"unit"));
        }
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u76ee\u6807\u5355\u4ef7(\u4e0d\u542b\u7a0e\u5355\u4ef7)", (String)"unitPrice"));
        return titleAndModelKeys;
    }
}

