/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingOfferHis;
import com.els.base.bidding.entity.BiddingOfferHisExample;
import com.els.base.bidding.service.BiddingOfferHisService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u62a5\u4ef7")
@Controller
@RequestMapping(value={"biddingOfferHis"})
public class BiddingOfferHisController {
    @Resource
    protected BiddingOfferHisService biddingOfferHisService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingOfferHis biddingOfferHis) {
        this.biddingOfferHisService.addObj(biddingOfferHis);
        return ResponseResult.success(biddingOfferHis.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingOfferHis biddingOfferHis) {
        Assert.isNotBlank(biddingOfferHis.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingOfferHisService.modifyObj(biddingOfferHis);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        BiddingOfferHisExample example = new BiddingOfferHisExample();
        example.createCriteria().andIdIn((List)ids);
        this.biddingOfferHisService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingOfferHis", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingOfferHis>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingOfferHisExample example = new BiddingOfferHisExample();
        example.setPageView(new PageView<BiddingOfferHis>(pageNo, pageSize));
        BiddingOfferHisExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.biddingOfferHisService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5728\u7ebf\u7ade\u4ef7\u62a5\u4ef7\u5386\u53f2\u8bb0\u5f55-\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/findBiddingOfferHis"})
    @ResponseBody
    public ResponseResult<List<BiddingOfferHis>> findBiddingOfferHis(String biddingNo, String type, String isBidding, String currentRound, String biddingOfferId) {
        if (StringUtils.isBlank((String)biddingNo)) {
            throw new CommonException("\u5217\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u62db\u6807\u5355\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)currentRound)) {
            throw new CommonException("\u62db\u6807\u5f53\u524d\u8f6e\u6b21\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u62db\u6807\u5f53\u524d\u8f6e\u6b21\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)type)) {
            throw new CommonException("\u9700\u6c42\u7c7b\u578b\u7f16\u7801:material(\u7269\u6599),die(\u6a21\u5177),device(\u8bbe\u5907)\u4e3a\u7a7a\u4e0d\u80fd\u64cd\u4f5c", "finish_status", "\u9700\u6c42\u7c7b\u578b\u7f16\u7801:material(\u7269\u6599),die(\u6a21\u5177),device(\u8bbe\u5907)\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)biddingOfferId)) {
            throw new CommonException("\u62a5\u4ef7\u8868id\u4e3a\u7a7a\u80fd\u64cd\u4f5c", "finish_status", "\u62a5\u4ef7id\u53c2\u6570\u4e3a\u7a7a");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        List<BiddingOfferHis> biddingOffers = this.biddingOfferHisService.findBiddingOfferHis(biddingNo, type, isBidding, currentRound, user, company, biddingOfferId);
        return ResponseResult.success(biddingOffers);
    }
}

