/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.MessageNotify;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.util.HashMap;
import java.util.List;

public class ApproveRefuseCommand
extends AbstractInquiryCommand<String> {
    private String purOrderId;

    public ApproveRefuseCommand(String purOrderId) {
        this.purOrderId = purOrderId;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotBlank(this.purOrderId, "\u8be2\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        PurOrder purOrder = (PurOrder)invoker.getPurOrderService().queryObjById(this.purOrderId);
        Assert.isNotNull(purOrder, "\u8be2\u4ef7\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        InquirySupOrder temp = new InquirySupOrder();
        temp.setAuditStatus(InquiryAuditStatus.AUDIT_REJECT.getCode());
        if (purOrder.getQuoteEndDate() != null && purOrder.getQuoteEndDate().getTime() < System.currentTimeMillis()) {
            temp.setInquiryOrderStatus(InquiryOrderStatus.FROZEN.getCode());
        } else {
            temp.setInquiryOrderStatus(InquiryOrderStatus.PUBLISHED.getCode());
        }
        InquirySupOrderExample supOrderExample = new InquirySupOrderExample();
        supOrderExample.createCriteria().andPurOrderIdEqualTo(this.purOrderId);
        this.invoker.getInquirySupOrderService().modifyByExample(temp, supOrderExample);
        PurOrder tmpPur = new PurOrder();
        tmpPur.setId(this.purOrderId);
        tmpPur.setAuditStatus(InquiryAuditStatus.AUDIT_REJECT.getCode());
        this.invoker.getPurOrderService().modifyObj(tmpPur);
        this.modifPurOrderItemStatus(purOrder);
        this.sendMsg(purOrder.getOrderNo(), purOrder.getPurUserId(), purOrder.getPurCompanyId());
        List supOrderList = invoker.getInquirySupOrderService().queryAllObjByExample(supOrderExample);
        for (InquirySupOrder inquirySupOrder : supOrderList) {
            String supCompanyCode = inquirySupOrder.getSupCompanySrmCode();
            this.sendMsg(purOrder.getOrderNo(), inquirySupOrder.getSupUserId(), supCompanyCode);
        }
        return null;
    }

    private void modifPurOrderItemStatus(PurOrder purOrder) {
        TemplateConf templateConf = (TemplateConf)this.invoker.getTemplateConfService().queryObjById(purOrder.getTemplateId());
        List<IOrderItem> itemList = templateConf.getOrderItemService().queryByPurOrderId(this.purOrderId);
        for (IOrderItem orderItem : itemList) {
            if (!orderItem.getQuotationStatus().equals(InquiryQuoteStatus.AUDITING.getCode())) continue;
            OrderItemM001 tempOrderItem = new OrderItemM001();
            tempOrderItem.setId(orderItem.getId());
            if (Constant.YES_INT.equals(orderItem.getIsReQuote())) {
                tempOrderItem.setQuotationStatus(InquiryQuoteStatus.REQUOTED.getCode());
            } else {
                tempOrderItem.setQuotationStatus(InquiryQuoteStatus.QUOTED.getCode());
            }
            templateConf.getOrderItemService().modifyObj(tempOrderItem);
        }
    }

    private void sendMsg(String orderNo, String userId, String companyCode) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("orderNo", orderNo);
        Message msg = Message.init(data).setCompanyCode(companyCode).setBusinessTypeCode(MessageNotify.INQUIRY_ORDER_APPROVE_REFUSE.getCode()).addReceiverId(userId).setMsgLevel(MessageLevelEnum.HIGH);
        MessageSendUtils.sendMessage((Message)msg);
    }
}

