/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.CreateCommand;
import com.els.base.inquiry.command.pur.DeleteCommand;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.utils.LaddPriceValider;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ModifyCommand
extends AbstractInquiryCommand<String> {
    private PurOrder purOrder;

    public ModifyCommand(PurOrder purOrder) {
        this.purOrder = purOrder;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.valid();
        DeleteCommand deleteCommand = new DeleteCommand(this.purOrder.getId());
        deleteCommand.copyProperties(deleteCommand);
        invoker.invoke(deleteCommand);
        CreateCommand createCommand = new CreateCommand(this.purOrder);
        createCommand.copyProperties(this);
        return invoker.invoke(createCommand);
    }

    private void valid() {
        Assert.isNotBlank(this.purOrder.getId(), "\u8be2\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        PurOrder temp = (PurOrder)this.invoker.getPurOrderService().queryObjById(this.purOrder.getId());
        if (!InquiryOrderStatus.UNPUBLISHED.getCode().equals(temp.getInquiryOrderStatus())) {
            throw new CommonException("\u53ea\u6709\u672a\u53d1\u5e03\u7684\u8be2\u4ef7\u5355\u624d\u80fd\u88ab\u4fee\u6539");
        }
        for (int i = 0; CollectionUtils.isNotEmpty(this.purOrder.getTargetList()) && i < this.purOrder.getTargetList().size(); ++i) {
            ITarget target = this.purOrder.getTargetList().get(i);
            LaddPriceValider.valid(target.getInquiryQuoteLadders());
        }
        if (CollectionUtils.isNotEmpty(this.purOrder.getTargetList())) {
            for (ITarget iTarget : this.purOrder.getTargetList()) {
                if (!StringUtils.isNotBlank((String)iTarget.getMaterialCode()) || this.invoker.getMaterialService().isExists(iTarget.getMaterialCode()).booleanValue()) continue;
                throw new CommonException(String.format("\u4e0d\u5b58\u5728\u7269\u6599\u7f16\u7801[%s]\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01", iTarget.getMaterialCode()));
            }
        }
    }
}

