/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingBond;
import com.els.base.bidding.entity.BiddingBondExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.service.BiddingBondService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4fdd\u8bc1\u91d1")
@Controller
@RequestMapping(value={"biddingBond"})
public class BiddingBondController {
    @Resource
    protected BiddingBondService biddingBondService;
    @Resource
    protected BiddingSupplierService biddingSupplierService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4fdd\u8bc1\u91d1")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingBond biddingBond) {
        this.biddingBondService.addObj(biddingBond);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4fdd\u8bc1\u91d1")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingBond biddingBond) {
        Assert.isNotBlank(biddingBond.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingBondService.modifyObj(biddingBond);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4fdd\u8bc1\u91d1")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingBondService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4fdd\u8bc1\u91d1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingBond", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingBond>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingBondExample example = new BiddingBondExample();
        example.setPageView(new PageView<BiddingBond>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.biddingBondService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546-\u7f16\u8f91\u4fdd\u8bc1\u91d1")
    @RequestMapping(value={"service/editSup"})
    @ResponseBody
    public ResponseResult<String> saveBiddingInfo(@RequestBody BiddingBond biddingBond) {
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        if (StringUtils.isBlank((String)biddingBond.getBiddingNo())) {
            throw new CommonException("\u62db\u6807\u5355\u53f7\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u62db\u6807\u5355\u53f7");
        }
        if (StringUtils.isBlank((String)biddingBond.getAttachmentSup())) {
            throw new CommonException("\u4fdd\u8bc1\u91d1\u9644\u4ef6\u5730\u5740\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u4fdd\u8bc1\u91d1\u9644\u4ef6\u5730\u5740");
        }
        BiddingSupplier biddingSupplier = new BiddingSupplier();
        biddingSupplier.setBankAttachment(biddingBond.getAttachmentSup());
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria criteria = biddingSupplierExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingBond.getBiddingNo());
        criteria.andSupCompanyIdEqualTo(company.getId());
        this.biddingSupplierService.modifyObjSup(biddingSupplier, biddingSupplierExample);
        List supList = this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample);
        HashMap<String, Serializable> msg = new HashMap<String, Serializable>();
        msg.put("biddingBond", biddingBond);
        msg.put("company", company);
        if (CollectionUtils.isNotEmpty(supList)) {
            Message message = Message.init(msg).setCompanyCode(company.getCompanyCode()).setSenderId(user.getId()).addReceiverId(((BiddingSupplier)supList.get(0)).getPurUserId()).setBusinessTypeCode("BIDDING_SUP_NOTICE").setMsgLevel(MessageLevelEnum.HIGH);
            MessageSendUtils.sendMessage((Message)message);
        }
        return ResponseResult.success();
    }
}

