/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.ImportBiddingToSapVo;
import com.els.base.bidding.entity.vo.ReportShow;
import com.els.base.bidding.entity.vo.SaveBidInfoVo;
import com.els.base.bidding.entity.vo.TemporaryCodeReducedRate;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.json.DetailDeSerializer;
import com.els.base.inquiry.utils.json.DetailSerialzer;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.qqt.utils.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u62db\u6295\u6807-\u4f9b\u5e94\u5546\u62a5\u4ef7")
@Controller
@RequestMapping(value={"biddingOffer"})
public class BiddingOfferController {
    @Resource
    protected BiddingOfferService biddingOfferService;
    @Resource
    protected BiddingHeaderService biddingHeaderService;
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;
    @Resource
    protected TplMouldDetailService tplMouldDetailService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingOffer biddingOffer) {
        this.biddingOfferService.addObj(biddingOffer);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingOffer biddingOffer) {
        Assert.isNotBlank(biddingOffer.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingOfferService.modifyObj(biddingOffer);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingOfferService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingOffer", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingOffer>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingOfferExample example = new BiddingOfferExample();
        example.setPageView(new PageView<BiddingOffer>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.biddingOfferService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u8bc4\u6807\u754c\u9762-\u91c7\u8d2d\u65b9")
    @RequestMapping(value={"service/findBidInfo"})
    @ResponseBody
    public ResponseResult<List<BiddingOffer>> findBidInfo(String biddingNo, String type, String isBidding, String currentRound, String biddingType, String bidFirstItem, String bidSecondItemPriceGap, String companyId) {
        if (StringUtils.isBlank((String)biddingNo)) {
            throw new CommonException("\u5217\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u62db\u6807\u5355\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)currentRound)) {
            throw new CommonException("\u62db\u6807\u5f53\u524d\u8f6e\u6b21\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u62db\u6807\u5f53\u524d\u8f6e\u6b21\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)type)) {
            throw new CommonException("\u9700\u6c42\u7c7b\u578b\u7f16\u7801:material(\u7269\u6599),die(\u6a21\u5177),device(\u8bbe\u5907)\u4e3a\u7a7a\u4e0d\u80fd\u64cd\u4f5c", "finish_status", "\u9700\u6c42\u7c7b\u578b\u7f16\u7801:material(\u7269\u6599),die(\u6a21\u5177),device(\u8bbe\u5907)\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)biddingType)) {
            throw new CommonException("\u62db\u6807\u7c7b\u578b\u4e3a\u7a7a\u4e0d\u80fd\u64cd\u4f5c", "finish_status", "\u62db\u6807\u7c7b\u578b\u4e3a\u7a7a");
        }
        if ("2".equals(biddingType) && StringUtils.isBlank((String)bidFirstItem)) {
            throw new CommonException("\u4f18\u5148\u9879\u4e0d\u80fd\u64cd\u4f5c", "finish_status", "\u4f18\u5148\u9879\u4e3a\u7a7a");
        }
        List<BiddingOffer> biddingOffers = this.biddingOfferService.findBidInfo(biddingNo, type, isBidding, currentRound, biddingType, bidFirstItem, bidSecondItemPriceGap, companyId);
        return ResponseResult.success(biddingOffers);
    }

    @ApiOperation(httpMethod="POST", value="\u8bc4\u6807\u754c\u9762-\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/findBidInfoSup"})
    @ResponseBody
    public ResponseResult<List<BiddingOffer>> findBidInfoSup(String biddingNo, String type, String isBidding, String currentRound) {
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        List<BiddingOffer> biddingOffers = this.biddingOfferService.findBidInfoSup(biddingNo, type, isBidding, currentRound, user, company);
        return ResponseResult.success(biddingOffers);
    }

    @ApiOperation(httpMethod="POST", value="\u8bc4\u5ba1\u754c\u9762-\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/findBidInfoSupReview"})
    @ResponseBody
    public ResponseResult<List<BiddingOffer>> findBidInfoSupReview(String biddingNo, String type, String isBidding, String currentRound, String companyId) {
        Assert.isNotBlank(companyId, "\u5220\u9664\u5931\u8d25,\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
        Company company = new Company();
        company.setId(companyId);
        User user = new User();
        List<BiddingOffer> biddingOffers = this.biddingOfferService.findBidInfoSupReview(biddingNo, type, isBidding, currentRound, user, company);
        return ResponseResult.success(biddingOffers);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u62a5\u4ef7\u4fdd\u5b58")
    @RequestMapping(value={"service/editUnitPrice"})
    @ResponseBody
    public ResponseResult<BiddingBaseVo> editUnitPrice(@RequestBody BiddingBaseVo biddingBaseVo) throws InstantiationException, IllegalAccessException {
        if (StringUtils.isBlank((String)biddingBaseVo.getBiddingHeader().getBiddingNo())) {
            throw new CommonException("\u5217\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u62db\u6807\u5355\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)biddingBaseVo.getBiddingHeader().getBiddingCurrentRound())) {
            throw new CommonException("\u62db\u6807\u5f53\u524d\u8f6e\u6b21\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u62db\u6807\u5f53\u524d\u8f6e\u6b21\u53f7\u4e3a\u7a7a");
        }
        if (biddingBaseVo.getBiddingContent() == null) {
            throw new CommonException("\u5217\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u5185\u5bb9\u5217\u8868\u6570\u636e\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)biddingBaseVo.getHandleType())) {
            throw new CommonException("\u7f16\u7801\u4e3a\u7a7a\u4e0d\u80fd\u64cd\u4f5c", "finish_status", "\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)biddingBaseVo.getBiddingHeader().getBiddingType())) {
            throw new CommonException("\u62db\u6807\u7c7b\u578b\u4e3a\u7a7a\u4e0d\u80fd\u64cd\u4f5c", "finish_status", "\u62db\u6807\u7c7b\u578b\u4e3a\u7a7a");
        }
        if ("2".equals(biddingBaseVo.getBiddingHeader().getBiddingType()) && StringUtils.isBlank((String)biddingBaseVo.getBiddingContent().getBidFirstItem())) {
            throw new CommonException("\u8bc4\u6807\u4f18\u9009\u9879\u4e3a\u7a7a\u4e0d\u80fd\u64cd\u4f5c", "finish_status", "\u8bc4\u6807\u4f18\u9009\u9879");
        }
        biddingBaseVo.setCompany(CompanyUtils.currentCompany());
        biddingBaseVo.setUser(SpringSecurityUtils.getLoginUser());
        this.biddingOfferService.saveUnitPrice(biddingBaseVo);
        return ResponseResult.success(biddingBaseVo);
    }

    @ApiOperation(httpMethod="POST", value="\u8ba1\u7b97\u4e0d\u542b\u7a0e\u4ef7\u683c")
    @RequestMapping(value={"service/calculateItemDetailValue"})
    @ResponseBody
    public ResponseResult<List<PropertyValue>> calculateItemDetailValue(@RequestParam(required=true) String costAnalysisId, @RequestBody List<PropertyValue> propertyValueList) throws InstantiationException, IllegalAccessException {
        DetailDeSerializer<? extends IOrderItemDetail> serializer = new DetailDeSerializer<IOrderItemDetail>(((TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById(costAnalysisId)).getOrderItemDetailClass());
        IOrderItemDetail itemDetail = serializer.transform(propertyValueList);
        itemDetail.calculate();
        itemDetail.setTemplateId(costAnalysisId);
        DetailSerialzer<IOrderItemDetail> serialzer = new DetailSerialzer<IOrderItemDetail>();
        return ResponseResult.success(serialzer.getProperyValueClass(itemDetail));
    }

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58(save)\uff0c\u63d0\u4ea4(submit)\u8bc4\u6807\u7ed3\u679c")
    @RequestMapping(value={"service/save"})
    @ResponseBody
    public ResponseResult<String> save(@RequestBody SaveBidInfoVo saveBidInfoVo, String saveOrSubmit) {
        BiddingHeaderExample headerExample = new BiddingHeaderExample();
        headerExample.createCriteria().andBiddingNoEqualTo(saveBidInfoVo.getBiddingOfferList().get(0).getBiddingNo());
        User user = SpringSecurityUtils.getLoginUser();
        this.biddingOfferService.save(saveBidInfoVo, saveOrSubmit, user);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4e2d\u6807\u7684\u4f9b\u5e94\u5546\u548c\u4efd\u989d")
    @RequestMapping(value={"service/findBidSupplier"})
    @ResponseBody
    public ResponseResult<List<TemporaryCodeReducedRate>> findBidSupplier(String biddingNo, String type, String currentRound) {
        List<TemporaryCodeReducedRate> codeReducedRates = this.biddingOfferService.findBidSupplier(biddingNo, type, currentRound);
        return ResponseResult.success(codeReducedRates);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u6bd4\u4ef7\u62a5\u8868(\u6309\u7167\u4f9b\u5e94\u5546\u7ee9\u6548\u7684\u90a3\u79cd\u505a\u6cd5)")
    @RequestMapping(value={"service/queryPriceReport2"})
    @ResponseBody
    public ResponseResult<ReportShow> queryPriceReport2(@RequestParam(required=false) String queryParams) throws JsonParseException, JsonMappingException, IOException {
        BiddingOfferExample example = new BiddingOfferExample();
        example.setOrderByClause(" PROJECT_NO DESC,SUP_COMPANY_SRM_CODE DESC ");
        QueryParamWapper wapper = null;
        if (StringUtils.isNotBlank((String)queryParams)) {
            wapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
        }
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        List<BiddingOffer> reportList = this.biddingOfferService.queryAllObjByExample(example);
        ReportShow monthlyReport = this.biddingOfferService.queryPriceReport2(reportList);
        return ResponseResult.success(monthlyReport);
    }

    @ApiOperation(httpMethod="POST", value="\u5c06\u4e2d\u6807\u884c\u5bfc\u5165sap\u7cfb\u7edf")
    @RequestMapping(value={"service/ImportBiddingToSap"})
    @ResponseBody
    public ResponseResult<String> ImportBiddingToSap(@RequestBody ImportBiddingToSapVo vo) {
        Assert.isNotNull(vo, "sap\u7684\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingOfferService.ImportBiddingToSap(vo);
        return ResponseResult.success();
    }
}

