/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.entity.MaterialCategoryExample;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialPropKeyGroup;
import com.els.base.material.entity.MaterialPropKeyGroupExample;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.material.service.MaterialPropKeyGroupService;
import com.els.base.material.service.MaterialService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7269\u6599\u5206\u7c7b")
@Controller
@RequestMapping(value={"materialCategory"})
public class MaterialCategoryController {
    @Resource
    protected MaterialService materialService;
    @Resource
    protected MaterialCategoryService materialCategoryService;
    @Resource
    protected MaterialPropKeyGroupService materialPropKeyGroupService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@ApiParam(value="\u7269\u6599\u5206\u7c7b\u4fe1\u606f") @RequestBody MaterialCategory materialCategory) {
        materialCategory.setId(null);
        materialCategory.setCompanyId(CompanyUtils.currentCompanyId());
        materialCategory.setProjectId(ProjectUtils.getProjectId());
        this.materialCategoryService.addObj(materialCategory);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@ApiParam(value="\u7269\u6599\u5206\u7c7b\u4fe1\u606f") @RequestBody MaterialCategory materialCategory) {
        materialCategory.setCompanyId(CompanyUtils.currentCompanyId());
        materialCategory.setProjectId(ProjectUtils.getProjectId());
        if (StringUtils.isBlank((String)materialCategory.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u7f16\u8f91\u5931\u8d25", "id_is_blank");
        }
        this.materialCategoryService.modifyObj(materialCategory);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@ApiParam(value="\u7269\u6599\u5206\u7c7bID") @RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25", "id_is_blank");
        }
        MaterialExample example = new MaterialExample();
        MaterialExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        criteria.andCategoryIdEqualTo(id);
        List list = this.materialService.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new CommonException("\u7269\u6599\u5728\u5b58\u5728\u7269\u6599\u5206\u7c7b\u7684\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01", "existing_ref_ass", "\u7269\u6599", "\u7269\u6599\u5206\u7c7b");
        }
        MaterialPropKeyGroupExample materialPropKeyGroupExample = new MaterialPropKeyGroupExample();
        MaterialPropKeyGroupExample.Criteria materialPropKeyGroupExampleCriteria = materialPropKeyGroupExample.createCriteria();
        materialPropKeyGroupExampleCriteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        materialPropKeyGroupExampleCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        materialPropKeyGroupExampleCriteria.andMaterialCategoryIdEqualTo(id);
        List materialPropKeyGroupList = this.materialPropKeyGroupService.queryAllObjByExample(materialPropKeyGroupExample);
        if (CollectionUtils.isNotEmpty(materialPropKeyGroupList)) {
            throw new CommonException("\u7269\u6599\u5728\u5b58\u5728\u7269\u6599\u5206\u7c7b\u7684\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01", "existing_ref_ass", "\u7269\u6599", "\u7269\u6599\u5206\u7c7b");
        }
        this.materialCategoryService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialCategory>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialCategory") @RequestBody(required=false) List<QueryParam> params) {
        PageView pageData;
        List materialCategoryList;
        MaterialCategoryExample example = new MaterialCategoryExample();
        example.setPageView(new PageView<MaterialCategory>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        MaterialCategoryExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (CollectionUtils.isNotEmpty(params)) {
            CriteriaUtils.addCriterion(criteria, params);
        }
        if (CollectionUtils.isNotEmpty(materialCategoryList = (pageData = this.materialCategoryService.queryObjByPage(example)).getQueryResult())) {
            for (MaterialCategory materialCategory : materialCategoryList) {
                MaterialPropKeyGroupExample materialPropKeyGroupExample = new MaterialPropKeyGroupExample();
                MaterialPropKeyGroupExample.Criteria materialPropKeyGroupExampleCriteria = materialPropKeyGroupExample.createCriteria();
                materialPropKeyGroupExampleCriteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
                materialPropKeyGroupExampleCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
                materialPropKeyGroupExampleCriteria.andMaterialCategoryIdEqualTo(materialCategory.getId());
                List<MaterialPropKeyGroup> materialPropKeyGroupList = this.materialPropKeyGroupService.queryAllObjByExample(materialPropKeyGroupExample);
                materialCategory.setMaterialPropKeyGroupList(materialPropKeyGroupList);
            }
        }
        return ResponseResult.success(pageData);
    }
}

