/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.bidding.dao.BiddingHeaderMapper;
import com.els.base.bidding.entity.BiddingBond;
import com.els.base.bidding.entity.BiddingBondExample;
import com.els.base.bidding.entity.BiddingContactInfo;
import com.els.base.bidding.entity.BiddingContactInfoExample;
import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentExample;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentMatterExample;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentModelExample;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingContentOtherExample;
import com.els.base.bidding.entity.BiddingFile;
import com.els.base.bidding.entity.BiddingFileExample;
import com.els.base.bidding.entity.BiddingFileSupplier;
import com.els.base.bidding.entity.BiddingFileSupplierExample;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingMatterStep;
import com.els.base.bidding.entity.BiddingMatterStepExample;
import com.els.base.bidding.entity.BiddingMatterStepSup;
import com.els.base.bidding.entity.BiddingMatterStepSupExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.BiddingOnline;
import com.els.base.bidding.entity.BiddingOnlineExample;
import com.els.base.bidding.entity.BiddingPlan;
import com.els.base.bidding.entity.BiddingPlanExample;
import com.els.base.bidding.entity.BiddingPower;
import com.els.base.bidding.entity.BiddingPowerExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.BiddingSupplierHis;
import com.els.base.bidding.entity.BiddingSupplierHisExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.BiddingOfferRankingVO;
import com.els.base.bidding.entity.vo.ManagementPage;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingBondService;
import com.els.base.bidding.service.BiddingContactInfoService;
import com.els.base.bidding.service.BiddingContentMatterService;
import com.els.base.bidding.service.BiddingContentModelService;
import com.els.base.bidding.service.BiddingContentOtherService;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.bidding.service.BiddingFileService;
import com.els.base.bidding.service.BiddingFileSupplierService;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingOnlineService;
import com.els.base.bidding.service.BiddingPlanService;
import com.els.base.bidding.service.BiddingPowerService;
import com.els.base.bidding.service.BiddingQuestionService;
import com.els.base.bidding.service.BiddingSupplierHisService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.BaseService;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.IMouldDetailService;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.entity.MouldDetail;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingHeaderService")
public class BiddingHeaderServiceImpl
implements BiddingHeaderService,
ITaskListener {
    @Resource
    protected BiddingHeaderMapper biddingHeaderMapper;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected BiddingPowerService biddingPowerService;
    @Resource
    protected BiddingPlanService biddingPlanService;
    @Resource
    protected BiddingContactInfoService biddingContactInfoService;
    @Resource
    protected BiddingContentService biddingContentService;
    @Resource
    protected BiddingQuestionService biddingQuestionService;
    @Resource
    protected BiddingContentMatterService biddingContentMatterService;
    @Resource
    protected BiddingContentModelService biddingContentModelService;
    @Resource
    protected BiddingContentOtherService biddingContentOtherService;
    @Resource
    protected BiddingSupplierService biddingSupplierService;
    @Resource
    protected BiddingSupplierHisService biddingSupplierHisService;
    @Resource
    protected BiddingBondService biddingBondService;
    @Resource
    protected BiddingMatterStepService biddingMatterStepService;
    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;
    @Resource
    protected BiddingFileService biddingFileService;
    @Resource
    protected BiddingFileSupplierService biddingFileSupplierService;
    @Resource
    protected WorkFlowService workFlowService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected BiddingOfferService biddingOfferService;
    @Resource
    protected TemplateConfService templateConfService;
    @Resource
    protected TplMouldDetailService tplMouldDetailService;
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;
    @Resource
    protected BiddingOnlineService biddingOnlineService;
    @Resource
    protected CompanyUserRefService companyUserRefService;

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void addObj(BiddingHeader t) {
        String biddingNo = this.generateCodeService.getNextCode("BIDDING_NO");
        t.setBiddingNo(biddingNo);
        t.setCreateTime(new Date());
        this.biddingHeaderMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingHeaderMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void modifyObj(BiddingHeader t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingHeaderMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void customModifyObj(BiddingHeader t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingHeaderMapper.customUpdateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"biddingHeader"}, keyGenerator="redisKeyGenerator")
    public BiddingHeader queryObjById(String id) {
        return this.biddingHeaderMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<BiddingHeader> queryAllObjByExample(BiddingHeaderExample example) {
        return this.biddingHeaderMapper.selectByExample(example);
    }

    @Override
    public PageView<BiddingHeader> queryObjByPage(BiddingHeaderExample example) {
        PageView<BiddingHeader> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingHeaderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"biddingHeader,biddingPower,biddingPlan,biddingContactInfo,biddingBond,biddingContent,biddingContentItem,biddingSupplier"}, allEntries=true)
    public void saveBiddingInfo(BiddingBaseVo biddingBaseVo) {
        BiddingContent biddingContent;
        BiddingPower biddingPower;
        String biddingNo;
        Company purCompany = biddingBaseVo.getCompany();
        User purUser = biddingBaseVo.getUser();
        BiddingHeader biddingHeader = biddingBaseVo.getBiddingHeader();
        String string = biddingNo = biddingHeader.getBiddingNo() == null ? "" : biddingHeader.getBiddingNo();
        if (biddingHeader != null) {
            biddingHeader.setPurCompanyId(purCompany.getId());
            biddingHeader.setPurCompanyCode(purCompany.getCompanyCode());
            biddingHeader.setPurCompanyName(purCompany.getCompanyName());
            biddingHeader.setBiddingStatus("0");
            biddingHeader.setBiddingPreAuditstatus("0");
            biddingHeader.setBiddingAuditstatus("0");
            if (biddingHeader.getId() == null) {
                biddingHeader.setPurUserId(purUser.getId());
                biddingHeader.setPurUserName(StringUtils.isNotBlank((String)purUser.getNickName()) ? purUser.getNickName() : purUser.getLoginName());
                this.addObj(biddingHeader);
            } else {
                biddingHeader.setPurUserId(null);
                biddingHeader.setPurUserName(null);
                biddingHeader.setLastUpdateTime(new Date());
                biddingHeader.setLastUpdateUser(biddingBaseVo.getUser().getUsername());
                this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
            }
        }
        if ((biddingPower = biddingHeader.getBiddingPower()) != null) {
            if (biddingPower.getId() == null) {
                this.addBiddingPower(biddingHeader, purCompany, purUser);
            } else {
                biddingPower.setLastUpdateTime(new Date());
                biddingPower.setLastUpdateUser(biddingBaseVo.getUser().getUsername());
                this.biddingPowerService.modifyObj(biddingPower);
            }
        }
        List<BiddingPlan> biddingPlanList = biddingBaseVo.getBiddingPlanList();
        this.biddingPlanService.deleteByBiddingNo(biddingNo);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingPlanList) && i < biddingPlanList.size(); ++i) {
            this.addBiddingPlan(biddingPlanList, biddingHeader, purCompany, purUser);
        }
        List<BiddingContactInfo> biddingContactInfoList = biddingBaseVo.getBiddingContactInfoList();
        this.biddingContactInfoService.deleteByBiddingNo(biddingNo);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContactInfoList) && i < biddingContactInfoList.size(); ++i) {
            this.addBiddingContactInfo(biddingContactInfoList.get(i), biddingHeader, purCompany, purUser);
        }
        BiddingBond biddingBond = biddingBaseVo.getBiddingBond();
        if (biddingBond != null) {
            if (biddingBond.getId() == null) {
                this.addBiddingBond(biddingBaseVo.getBiddingBond(), biddingHeader, purCompany, purUser);
            } else {
                biddingBond.setLastUpdateTime(new Date());
                biddingBond.setLastUpdateUser(biddingBaseVo.getUser().getUsername());
                this.biddingBondService.modifyObj(biddingBond);
            }
        }
        if ((biddingContent = biddingBaseVo.getBiddingContent()) != null) {
            this.biddingContentService.deleteByBiddingNo(biddingNo);
            this.addBiddingContent(biddingContent, biddingHeader, purCompany, purUser);
        }
        List<BiddingSupplier> biddingSupplierList = biddingBaseVo.getBiddingSupplierList();
        this.biddingSupplierService.deleteByBiddingNo(biddingNo);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
            this.addBiddingSupplier(biddingSupplierList.get(i), biddingHeader, purCompany, purUser);
        }
        List<BiddingFile> biddingFiles = biddingBaseVo.getBiddingFiles();
        this.biddingFileService.deleteByBiddingNo(biddingNo);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingFiles) && i < biddingFiles.size(); ++i) {
            this.addBiddingFile(biddingFiles.get(i), biddingHeader, purCompany, purUser);
        }
    }

    private void addBiddingFile(BiddingFile biddingFile, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        if (biddingFile != null) {
            biddingFile.setPurCompanyId(purCompany.getId());
            biddingFile.setPurCompanyName(purCompany.getCompanyName());
            biddingFile.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingFile.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingFile.setPurUserId(purUser.getId());
            biddingFile.setPurUserName(purUser.getUsername());
            biddingFile.setBiddingHeaderId(biddingHeader.getId());
            biddingFile.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingFileService.addObj(biddingFile);
        }
    }

    private void addBiddingBond(BiddingBond biddingBond, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        if (biddingBond != null) {
            biddingBond.setPurCompanyId(purCompany.getId());
            biddingBond.setPurCompanyName(purCompany.getCompanyName());
            biddingBond.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingBond.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingBond.setPurUserId(purUser.getId());
            biddingBond.setPurUserName(purUser.getUsername());
            biddingBond.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingBondService.addObj(biddingBond);
        }
    }

    @Override
    public void addBiddingSupplier(BiddingSupplier biddingSupplier, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        if (biddingSupplier != null) {
            biddingSupplier.setPurCompanyId(purCompany.getId());
            biddingSupplier.setPurCompanyName(purCompany.getCompanyName());
            biddingSupplier.setPurCompanyCode(purCompany.getCompanyCode());
            biddingSupplier.setPurUserId(purUser.getId());
            biddingSupplier.setPurUserName(purUser.getUsername());
            biddingSupplier.setBiddingHeaderId(biddingHeader.getId());
            biddingSupplier.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingSupplierService.addObj(biddingSupplier);
        }
    }

    private void addBiddingContent(BiddingContent biddingContent, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        if (biddingContent != null) {
            int j;
            biddingContent.setPurCompanyId(purCompany.getId());
            biddingContent.setPurCompanyName(purCompany.getCompanyName());
            biddingContent.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingContent.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingContent.setPurUserId(purUser.getId());
            biddingContent.setPurUserName(purUser.getUsername());
            biddingContent.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingContentService.addObj(biddingContent);
            List<BiddingContentMatter> biddingContentMatterList = biddingContent.getBiddingContentMatterList();
            List<BiddingContentModel> biddingContentModelList = biddingContent.getBiddingContentModelList();
            List<BiddingContentOther> biddingContentOtherList = biddingContent.getBiddingContentOtherList();
            for (j = 0; CollectionUtils.isNotEmpty(biddingContentMatterList) && j < biddingContentMatterList.size(); ++j) {
                BiddingContentMatter biddingContentMatter = biddingContentMatterList.get(j);
                biddingContentMatter.setPurCompanyId(purCompany.getId());
                biddingContentMatter.setPurCompanyName(purCompany.getCompanyName());
                biddingContentMatter.setPurCompanySapCode(purCompany.getCompanySapCode());
                biddingContentMatter.setPurCompanySrmCode(purCompany.getCompanyCode());
                biddingContentMatter.setPurUserId(purUser.getId());
                biddingContentMatter.setPurUserName(purUser.getUsername());
                biddingContentMatter.setBiddingNo(biddingHeader.getBiddingNo());
                biddingContentMatter.setBiddingContentId(biddingContent.getId());
                this.biddingContentMatterService.addObj(biddingContentMatter);
                List<BiddingMatterStep> biddingMatterStepList = biddingContentMatter.getBiddingMatterStepList();
                this.biddingMatterStepService.deleteObjByMatterId(biddingContentMatter.getId());
                for (int i = 0; CollectionUtils.isNotEmpty(biddingMatterStepList) && i < biddingMatterStepList.size(); ++i) {
                    BiddingMatterStep biddingMatterStep = biddingMatterStepList.get(i);
                    biddingMatterStep.setPurCompanyId(purCompany.getId());
                    biddingMatterStep.setPurCompanyName(purCompany.getCompanyName());
                    biddingMatterStep.setPurCompanySapCode(purCompany.getCompanySapCode());
                    biddingMatterStep.setPurCompanySrmCode(purCompany.getCompanyCode());
                    biddingMatterStep.setPurUserId(purUser.getId());
                    biddingMatterStep.setPurUserName(purUser.getUsername());
                    biddingMatterStep.setBiddingNo(biddingHeader.getBiddingNo());
                    biddingMatterStep.setBiddingHeaderId(biddingHeader.getId());
                    biddingMatterStep.setMatterId(biddingContentMatter.getId());
                    this.biddingMatterStepService.addObj(biddingMatterStep);
                }
            }
            for (j = 0; CollectionUtils.isNotEmpty(biddingContentModelList) && j < biddingContentModelList.size(); ++j) {
                BiddingContentModel biddingContentModel = biddingContentModelList.get(j);
                biddingContentModel.setPurCompanyId(purCompany.getId());
                biddingContentModel.setPurCompanyName(purCompany.getCompanyName());
                biddingContentModel.setPurCompanySapCode(purCompany.getCompanySapCode());
                biddingContentModel.setPurCompanySrmCode(purCompany.getCompanyCode());
                biddingContentModel.setPurUserId(purUser.getId());
                biddingContentModel.setPurUserName(purUser.getUsername());
                biddingContentModel.setBiddingNo(biddingHeader.getBiddingNo());
                biddingContentModel.setBiddingContentId(biddingContent.getId());
                this.biddingContentModelService.addObj(biddingContentModel);
            }
            for (j = 0; CollectionUtils.isNotEmpty(biddingContentOtherList) && j < biddingContentOtherList.size(); ++j) {
                BiddingContentOther biddingContentOther = biddingContentOtherList.get(j);
                biddingContentOther.setPurCompanyId(purCompany.getId());
                biddingContentOther.setPurCompanyName(purCompany.getCompanyName());
                biddingContentOther.setPurCompanySapCode(purCompany.getCompanySapCode());
                biddingContentOther.setPurCompanySrmCode(purCompany.getCompanyCode());
                biddingContentOther.setPurUserId(purUser.getId());
                biddingContentOther.setPurUserName(purUser.getUsername());
                biddingContentOther.setBiddingNo(biddingHeader.getBiddingNo());
                biddingContentOther.setBiddingContentId(biddingContent.getId());
                this.biddingContentOtherService.addObj(biddingContentOther);
            }
        }
    }

    private void addBiddingContactInfo(BiddingContactInfo biddingContactInfo, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        if (biddingContactInfo != null) {
            biddingContactInfo.setPurCompanyId(purCompany.getId());
            biddingContactInfo.setPurCompanyName(purCompany.getCompanyName());
            biddingContactInfo.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingContactInfo.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingContactInfo.setPurUserId(purUser.getId());
            biddingContactInfo.setPurUserName(purUser.getUsername());
            biddingContactInfo.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingContactInfoService.addObj(biddingContactInfo);
        }
    }

    private void addBiddingPlan(List<BiddingPlan> biddingPlanList, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        for (int i = 0; CollectionUtils.isNotEmpty(biddingPlanList) && i < biddingPlanList.size(); ++i) {
            BiddingPlan biddingPlan = biddingPlanList.get(i);
            biddingPlan.setPurCompanyId(purCompany.getId());
            biddingPlan.setPurCompanyName(purCompany.getCompanyName());
            biddingPlan.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingPlan.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingPlan.setPurUserId(purUser.getId());
            biddingPlan.setPurUserName(purUser.getUsername());
            biddingPlan.setBiddingId(biddingHeader.getId());
            biddingPlan.setBiddingNo(biddingHeader.getBiddingNo());
            biddingPlan.setBiddingRoundsNumber("1");
            biddingPlan.setBiddingTotalRound("1");
            BiddingHeader header = new BiddingHeader();
            header.setId(biddingHeader.getId());
            header.setBiddingCurrentRound(biddingPlan.getBiddingRoundsNumber());
            header.setBiddingTotalRound(biddingPlan.getBiddingTotalRound());
            header.setBiddingBegindate(biddingPlan.getBiddingBeginDate());
            header.setBiddingEnddate(biddingPlan.getBiddingEndDate());
            header.setBiddingDeadline(biddingPlan.getBiddingDeadline());
            header.setBiddingOpenDate(biddingPlan.getBiddingOpenDate());
            this.biddingHeaderMapper.updateByPrimaryKeySelective(header);
            this.biddingPlanService.addObj(biddingPlan);
        }
    }

    private void addBiddingPower(BiddingHeader biddingHeader, Company purCompany, User purUser) {
        BiddingPower biddingPower = biddingHeader.getBiddingPower();
        biddingPower.setPurCompanyId(purCompany.getId());
        biddingPower.setPurCompanyCode(purCompany.getCompanyCode());
        biddingPower.setPurUserId(purUser.getId());
        biddingPower.setPurUserName(purUser.getUsername());
        biddingPower.setBiddingHeaderId(biddingHeader.getId());
        biddingPower.setBiddingNo(biddingHeader.getBiddingNo());
        this.biddingPowerService.addObj(biddingPower);
    }

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public List<ManagementPage> transform(List<BiddingHeader> queryResult, User user, List<String> roleCodeList) {
        ArrayList<ManagementPage> managementPages = new ArrayList<ManagementPage>();
        for (int i = 0; CollectionUtils.isNotEmpty(queryResult) && i < queryResult.size(); ++i) {
            ManagementPage managementPage = new ManagementPage();
            managementPage.setBiddingNo(queryResult.get(i).getBiddingNo());
            managementPage.setBiddingAuditstatus(queryResult.get(i).getBiddingAuditstatus());
            managementPage.setBiddingPreAuditstatus(queryResult.get(i).getBiddingPreAuditstatus());
            managementPage.setBiddingName(queryResult.get(i).getBiddingName());
            managementPage.setBiddingType(queryResult.get(i).getBiddingType());
            managementPage.setBiddingStatus(queryResult.get(i).getBiddingStatus());
            managementPage.setBiddingRoundsNumber(queryResult.get(i).getBiddingCurrentRound());
            managementPage.setBiddingTotalRound(queryResult.get(i).getBiddingTotalRound());
            managementPage.setPurUserName(queryResult.get(i).getPurUserName());
            managementPage.setPublishDate(queryResult.get(i).getPublishDate());
            managementPage.setBiddingDeadline(queryResult.get(i).getBiddingDeadline());
            managementPage.setBiddingBegindate(queryResult.get(i).getBiddingBegindate());
            managementPage.setBiddingEnddate(queryResult.get(i).getBiddingEnddate());
            managementPage.setBiddingOpenDate(queryResult.get(i).getBiddingOpenDate());
            managementPage.setApproveFlowId(queryResult.get(i).getApproveFlowId());
            managementPage.setApproveFlowId2(queryResult.get(i).getApproveFlowId2());
            int count = this.biddingQuestionService.countPurQuestionInfo(queryResult.get(i).getBiddingNo());
            managementPage.setQuestionCount(count);
            if (!(roleCodeList.contains("systemManager") || roleCodeList.contains("manager") || roleCodeList.contains("supplier") || queryResult.get(i).getPurUserId().equals(user.getId()))) {
                managementPage.setCurrentUserCreate("0");
            } else {
                managementPage.setCurrentUserCreate("1");
            }
            BiddingContactInfoExample ContactInfoExample = new BiddingContactInfoExample();
            ContactInfoExample.createCriteria().andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            List biddingContactInfoList = this.biddingContactInfoService.queryAllObjByExample(ContactInfoExample);
            if (biddingContactInfoList.size() == 0) {
                managementPage.setInfoIsAllInsert("0");
            }
            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria createCriteria = supplierExample.createCriteria();
            createCriteria.andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            List biddingSupplierPartNo = this.biddingSupplierService.queryAllObjByExample(supplierExample);
            managementPage.setPartNo(String.valueOf(biddingSupplierPartNo.size()));
            createCriteria.andSupParticipateEqualTo("1");
            List biddingSupplierBidNo = this.biddingSupplierService.queryAllObjByExample(supplierExample);
            managementPage.setBidNo(String.valueOf(biddingSupplierBidNo.size()));
            BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria criteria = biddingSupplierExample.createCriteria();
            criteria.andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            criteria.andSupBiddingEqualTo("1");
            List<Object> sumList = new ArrayList();
            sumList = this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample);
            int sum = sumList.size();
            if (sum >= biddingSupplierBidNo.size() && sum > 0) {
                managementPage.setIsAllBid("1");
            } else {
                managementPage.setIsAllBid("0");
            }
            ArrayList<String> supBiddingStatusList = new ArrayList<String>();
            for (int j = 0; CollectionUtils.isNotEmpty(biddingSupplierPartNo) && j < biddingSupplierPartNo.size(); ++j) {
                if (((BiddingSupplier)biddingSupplierPartNo.get(j)).getSupBiddingStatus() == null) continue;
                supBiddingStatusList.add(((BiddingSupplier)biddingSupplierPartNo.get(j)).getSupBiddingStatus());
            }
            Date biddingDeadlineDate = queryResult.get(i).getBiddingDeadline();
            if (biddingDeadlineDate == null) {
                Calendar c = Calendar.getInstance();
                c.add(5, 1);
                biddingDeadlineDate = c.getTime();
            }
            int timeCompareBiddingDeadline = this.compareTwoTimes(new Date(), biddingDeadlineDate);
            if (queryResult.get(i).getBiddingStatus() != null && !queryResult.get(i).getBiddingStatus().equals(TenderStatusEumn.ISCANCEL.getValue()) && !queryResult.get(i).getBiddingStatus().equals(TenderStatusEumn.NOTPUBLISH.getValue()) && CollectionUtils.isNotEmpty(supBiddingStatusList)) {
                if (Collections.frequency(supBiddingStatusList, TenderStatusEumn.REFUSEBID.getValue()) == supBiddingStatusList.size()) {
                    managementPage.setBiddingStatus(TenderStatusEumn.ALLREFUSEBID.getValue());
                } else {
                    Date bidSubmitDate;
                    Date biddingOpenDate;
                    Date biddingEnddate;
                    Date biddingBegindate = queryResult.get(i).getBiddingBegindate();
                    if (biddingBegindate == null) {
                        Calendar c = Calendar.getInstance();
                        c.add(5, 1);
                        biddingBegindate = c.getTime();
                    }
                    int timeCompareBiddingBegindate = this.compareTwoTimes(new Date(), biddingBegindate);
                    if ((timeCompareBiddingDeadline == 1 || timeCompareBiddingDeadline == 0) && timeCompareBiddingBegindate == -1) {
                        if (Collections.frequency(supBiddingStatusList, TenderStatusEumn.WAITBID.getValue()) == supBiddingStatusList.size()) {
                            managementPage.setBiddingStatus(TenderStatusEumn.ALLREFUSEBID.getValue());
                        } else if (Collections.frequency(supBiddingStatusList, TenderStatusEumn.ISBID.getValue()) == supBiddingStatusList.size()) {
                            managementPage.setBiddingStatus(TenderStatusEumn.ALLBID.getValue());
                        } else {
                            managementPage.setBiddingStatus(TenderStatusEumn.PARTBID.getValue());
                        }
                    }
                    if ((biddingEnddate = queryResult.get(i).getBiddingEnddate()) == null) {
                        Calendar c = Calendar.getInstance();
                        c.add(5, 1);
                        biddingEnddate = c.getTime();
                    }
                    int timeCompareBiddingEnddate = this.compareTwoTimes(new Date(), biddingEnddate);
                    if ((timeCompareBiddingBegindate == 1 || timeCompareBiddingBegindate == 0) && timeCompareBiddingEnddate == -1) {
                        if (Collections.frequency(supBiddingStatusList, TenderStatusEumn.WAITBID.getValue()) == supBiddingStatusList.size()) {
                            managementPage.setBiddingStatus(TenderStatusEumn.ALLREFUSEBID.getValue());
                        } else if (TenderStatusEumn.BIDOVER.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.ISSCALING.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.ISFINISH.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.INBID.getValue().equals(queryResult.get(i).getBiddingStatus())) {
                            managementPage.setBiddingStatus(queryResult.get(i).getBiddingStatus());
                        } else {
                            managementPage.setBiddingStatus(TenderStatusEumn.BIDDING.getValue());
                        }
                    }
                    if ((biddingOpenDate = queryResult.get(i).getBiddingOpenDate()) == null) {
                        Calendar c = Calendar.getInstance();
                        c.add(5, 1);
                        biddingOpenDate = c.getTime();
                    }
                    int timeCompareBiddingOpenDate = this.compareTwoTimes(new Date(), biddingOpenDate);
                    if ((timeCompareBiddingEnddate == 1 || timeCompareBiddingEnddate == 0) && timeCompareBiddingOpenDate == -1) {
                        if (Collections.frequency(supBiddingStatusList, TenderStatusEumn.WAITBID.getValue()) == supBiddingStatusList.size()) {
                            managementPage.setBiddingStatus(TenderStatusEumn.ALLREFUSEBID.getValue());
                        } else if (TenderStatusEumn.BIDOVER.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.ISSCALING.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.ISFINISH.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.INBID.getValue().equals(queryResult.get(i).getBiddingStatus())) {
                            managementPage.setBiddingStatus(queryResult.get(i).getBiddingStatus());
                        } else {
                            managementPage.setBiddingStatus(TenderStatusEumn.BIDDINGEND.getValue());
                        }
                    }
                    if ((bidSubmitDate = queryResult.get(i).getBidSubmitDate()) == null) {
                        Calendar c = Calendar.getInstance();
                        c.add(5, 1);
                        bidSubmitDate = c.getTime();
                    }
                    int timeCompareBidSubmitDate = this.compareTwoTimes(new Date(), bidSubmitDate);
                    if ((timeCompareBiddingOpenDate == 1 || timeCompareBiddingOpenDate == 0) && timeCompareBidSubmitDate == -1) {
                        if (Collections.frequency(supBiddingStatusList, TenderStatusEumn.WAITBID.getValue()) == supBiddingStatusList.size()) {
                            managementPage.setBiddingStatus(TenderStatusEumn.ALLREFUSEBID.getValue());
                        } else if (TenderStatusEumn.BIDOVER.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.ISSCALING.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.ISFINISH.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.INBID.getValue().equals(queryResult.get(i).getBiddingStatus())) {
                            managementPage.setBiddingStatus(queryResult.get(i).getBiddingStatus());
                        } else {
                            managementPage.setBiddingStatus(TenderStatusEumn.INBID.getValue());
                        }
                    }
                }
            } else if (TenderStatusEumn.NOTPUBLISH.getValue().equals(queryResult.get(i).getBiddingStatus()) && ("1".equals(queryResult.get(i).getBiddingPreAuditstatus()) || "2".equals(queryResult.get(i).getBiddingPreAuditstatus()) || "3".equals(queryResult.get(i).getBiddingPreAuditstatus())) && timeCompareBiddingDeadline == 1) {
                managementPage.setBiddingStatus(TenderStatusEumn.OVERTIME.getValue());
            }
            managementPages.add(managementPage);
        }
        return managementPages;
    }

    private int compareTwoTimes(Date date, Date biddingDeadline) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = sdf.format(date);
        String format2 = sdf.format(biddingDeadline);
        int compareTo = 0;
        try {
            Date date_01 = sdf.parse(format);
            Date date_02 = sdf.parse(format2);
            compareTo = date_01.compareTo(date_02);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return compareTo;
    }

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public List<ManagementPage> transformSup(List<BiddingHeader> queryResult, User user, List<String> roleCodeList, Company company) {
        ArrayList<ManagementPage> managementPages = new ArrayList<ManagementPage>();
        for (int i = 0; CollectionUtils.isNotEmpty(queryResult) && i < queryResult.size(); ++i) {
            List biddingSupplierPartNo;
            List biddingSupplierStatus;
            ManagementPage managementPage = new ManagementPage();
            managementPage.setBiddingNo(queryResult.get(i).getBiddingNo());
            managementPage.setBiddingAuditstatus(queryResult.get(i).getBiddingAuditstatus());
            managementPage.setBiddingPreAuditstatus(queryResult.get(i).getBiddingPreAuditstatus());
            managementPage.setBiddingName(queryResult.get(i).getBiddingName());
            managementPage.setBiddingType(queryResult.get(i).getBiddingType());
            managementPage.setBiddingRoundsNumber(queryResult.get(i).getBiddingCurrentRound());
            managementPage.setBiddingTotalRound(queryResult.get(i).getBiddingTotalRound());
            managementPage.setPurUserName(queryResult.get(i).getPurUserName());
            managementPage.setBiddingBegindate(queryResult.get(i).getBiddingBegindate());
            managementPage.setBiddingEnddate(queryResult.get(i).getBiddingEnddate());
            managementPage.setBiddingDeadline(queryResult.get(i).getBiddingDeadline());
            managementPage.setPublishDate(queryResult.get(i).getPublishDate());
            managementPage.setBiddingOpenDate(queryResult.get(i).getBiddingOpenDate());
            managementPage.setApproveFlowId(queryResult.get(i).getApproveFlowId());
            managementPage.setApproveFlowId2(queryResult.get(i).getApproveFlowId2());
            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria createCriteria = supplierExample.createCriteria();
            createCriteria.andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            createCriteria.andSupCompanyIdEqualTo(company.getId());
            int count = this.biddingQuestionService.countSupplierQuestionInfo(queryResult.get(i).getBiddingNo(), company);
            managementPage.setQuestionCount(count);
            BiddingBondExample biddingBondExample = new BiddingBondExample();
            biddingBondExample.createCriteria().andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            List biddingBondList = this.biddingBondService.queryAllObjByExample(biddingBondExample);
            if (CollectionUtils.isNotEmpty(biddingBondList)) {
                managementPage.setCollectMoney(((BiddingBond)biddingBondList.get(0)).getCollectMoney());
            }
            if (CollectionUtils.isNotEmpty(biddingSupplierStatus = this.biddingSupplierService.queryAllObjByExample(supplierExample))) {
                managementPage.setIsPayMoney(((BiddingSupplier)biddingSupplierStatus.get(0)).getIsPayMoney());
                Date curDate = new Date();
                Date biddingDeadline_Date = queryResult.get(i).getBiddingDeadline();
                if (biddingDeadline_Date == null) {
                    Calendar c = Calendar.getInstance();
                    c.add(5, 1);
                    biddingDeadline_Date = c.getTime();
                }
                int biddingDeadline = this.compareTwoTimes(curDate, biddingDeadline_Date);
                Date biddingBegindate_Date = queryResult.get(i).getBiddingBegindate();
                if (biddingBegindate_Date == null) {
                    Calendar c = Calendar.getInstance();
                    c.add(5, 1);
                    biddingBegindate_Date = c.getTime();
                }
                int biddingBegindate = this.compareTwoTimes(curDate, biddingBegindate_Date);
                Date biddingEnddate_Date = queryResult.get(i).getBiddingEnddate();
                if (biddingEnddate_Date == null) {
                    Calendar c = Calendar.getInstance();
                    c.add(5, 1);
                    biddingEnddate_Date = c.getTime();
                }
                int biddingEnddate = this.compareTwoTimes(curDate, biddingEnddate_Date);
                Date biddingOpenDate_Date = queryResult.get(i).getBiddingOpenDate();
                if (biddingOpenDate_Date == null) {
                    Calendar c = Calendar.getInstance();
                    c.add(5, 1);
                    biddingOpenDate_Date = c.getTime();
                }
                int biddingOpenDate = this.compareTwoTimes(curDate, biddingOpenDate_Date);
                Date submitDate = queryResult.get(i).getBidSubmitDate();
                if (submitDate == null) {
                    Calendar c = Calendar.getInstance();
                    c.add(5, 1);
                    submitDate = c.getTime();
                }
                int bidSubmitDate = this.compareTwoTimes(curDate, submitDate);
                if (TenderStatusEumn.ISCANCEL.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                    managementPage.setBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
                } else {
                    managementPage.setBiddingStatus(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus());
                    if ((biddingDeadline == 1 || biddingDeadline == 0) && biddingBegindate == -1) {
                        if (TenderStatusEumn.WAITBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());
                        }
                    } else if ((biddingBegindate == 1 || biddingBegindate == 0) && biddingEnddate == -1) {
                        if (TenderStatusEumn.WAITBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());
                        } else if (TenderStatusEumn.ISBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.BIDDING.getValue());
                        } else if (TenderStatusEumn.REFUSEBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());
                        }
                    } else if ((biddingEnddate == 1 || biddingEnddate == 0) && biddingOpenDate == -1) {
                        if (TenderStatusEumn.WAITBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());
                        } else if (TenderStatusEumn.ISBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.BIDDINGEND.getValue());
                        } else if (TenderStatusEumn.REFUSEBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());
                        }
                    } else if ((biddingOpenDate == 1 || biddingOpenDate == 0) && bidSubmitDate == -1) {
                        if (TenderStatusEumn.WAITBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());
                        } else if (TenderStatusEumn.ISBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.INBID.getValue());
                        } else if (TenderStatusEumn.REFUSEBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());
                        }
                    } else if ((biddingDeadline == 1 || biddingDeadline == 0) && TenderStatusEumn.WAITBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                        managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(biddingSupplierPartNo = this.biddingSupplierService.queryAllObjByExample(supplierExample))) {
                managementPage.setPartNo(String.valueOf(biddingSupplierPartNo.size()));
            }
            createCriteria.andSupParticipateEqualTo("11");
            List biddingSupplierBidNo = this.biddingSupplierService.queryAllObjByExample(supplierExample);
            if (CollectionUtils.isNotEmpty(biddingSupplierBidNo)) {
                managementPage.setBidNo(String.valueOf(biddingSupplierBidNo.size()));
            }
            createCriteria.andSupBiddingEqualTo("2");
            List biddingSupplierBiddingNumber = this.biddingSupplierService.queryAllObjByExample(supplierExample);
            if (CollectionUtils.isNotEmpty(biddingSupplierBiddingNumber)) {
                managementPage.setBiddingNumber(String.valueOf(biddingSupplierBiddingNumber.size()));
            }
            BiddingContactInfoExample biddingContactInfoExample = new BiddingContactInfoExample();
            biddingContactInfoExample.createCriteria().andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            List biddingContactInfoList = this.biddingContactInfoService.queryAllObjByExample(biddingContactInfoExample);
            if (biddingContactInfoList.size() <= 0) continue;
            managementPages.add(managementPage);
        }
        return managementPages;
    }

    private void setBiddingItemInfo(BiddingContent biddingContent, BiddingBaseVo baseVo) {
        BiddingContentMatterExample matterExample = new BiddingContentMatterExample();
        matterExample.createCriteria().andBiddingContentIdEqualTo(biddingContent.getId());
        matterExample.setOrderByClause(" MATERIAL_DESC DESC ");
        List<BiddingContentMatter> biddingContentMatterList = this.biddingContentMatterService.queryAllObjByExample(matterExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentMatterList) && i < biddingContentMatterList.size(); ++i) {
            BiddingContentMatter biddingContentMatter = biddingContentMatterList.get(i);
            BiddingMatterStepExample example = new BiddingMatterStepExample();
            example.createCriteria().andMatterIdEqualTo(biddingContentMatter.getId());
            List<BiddingMatterStep> queryAllObjByExample = this.biddingMatterStepService.queryAllObjByExample(example);
            biddingContentMatter.setBiddingMatterStepList(queryAllObjByExample);
        }
        biddingContent.setBiddingContentMatterList(biddingContentMatterList);
        BiddingContentModelExample modelExample = new BiddingContentModelExample();
        modelExample.createCriteria().andBiddingContentIdEqualTo(biddingContent.getId());
        modelExample.setOrderByClause(" MODEL_DESC DESC ");
        List<BiddingContentModel> biddingContentModelList = this.biddingContentModelService.queryAllObjByExample(modelExample);
        biddingContent.setBiddingContentModelList(biddingContentModelList);
        BiddingContentOtherExample otherExample = new BiddingContentOtherExample();
        otherExample.createCriteria().andBiddingContentIdEqualTo(biddingContent.getId());
        otherExample.setOrderByClause(" TAREGT_DESC DESC ");
        List<BiddingContentOther> biddingContentOtherList = this.biddingContentOtherService.queryAllObjByExample(otherExample);
        biddingContent.setBiddingContentOtherList(biddingContentOtherList);
        if (!(!CollectionUtils.isNotEmpty(baseVo.getRoleList()) || baseVo.getRoleList().contains("systemManager") || baseVo.getRoleList().contains("manager") || baseVo.getRoleList().contains("supplier") || biddingContent.getPurUserId().equals(baseVo.getUser().getId()))) {
            BiddingPowerExample biddingPowerExample = new BiddingPowerExample();
            biddingPowerExample.createCriteria().andBiddingNoEqualTo(biddingContent.getBiddingNo());
            List biddingPowerList = this.biddingPowerService.queryAllObjByExample(biddingPowerExample);
            if (CollectionUtils.isNotEmpty(biddingPowerList) && ((BiddingPower)biddingPowerList.get(0)).getBiddingTendererPower().equals("0")) {
                for (BiddingContentMatter matter : biddingContent.getBiddingContentMatterList()) {
                    matter.setIsHidePrice("1");
                }
                for (BiddingContentModel model : biddingContent.getBiddingContentModelList()) {
                    model.setIsHidePrice("1");
                }
                for (BiddingContentOther other : biddingContent.getBiddingContentOtherList()) {
                    other.setIsHidePrice("1");
                }
            }
        }
    }

    private void setBiddingItemInfoSup(BiddingContent biddingContent, String biddingCurrentRound, BiddingBaseVo baseVo) {
        String biddingSendBidder;
        List<BiddingHeader> biddingHeaders;
        BiddingHeaderExample headerExample;
        BaseService service;
        BiddingOfferExample matterExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria matterCriteria = matterExample.createCriteria();
        matterCriteria.andBiddingNoEqualTo(biddingContent.getBiddingNo());
        matterCriteria.andSupCompanyIdEqualTo(baseVo.getCompany().getId());
        matterCriteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);
        matterCriteria.andRequirementTypeCodeEqualTo("material");
        List<BiddingOffer> biddingOfferMatterList = this.biddingOfferService.queryAllObjByExample(matterExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingOfferMatterList) && i < biddingOfferMatterList.size(); ++i) {
            BiddingOffer biddingOfferMatter = biddingOfferMatterList.get(i);
            biddingOfferMatter.setLastOfferUnitPrice(biddingOfferMatter.getOfferUnitPrice());
            BiddingMatterStepSupExample example = new BiddingMatterStepSupExample();
            BiddingMatterStepSupExample.Criteria criteria = example.createCriteria();
            criteria.andBiddingNoEqualTo(biddingContent.getBiddingNo());
            criteria.andMatterIdEqualTo(biddingOfferMatter.getMatterId());
            criteria.andSupCompanyIdEqualTo(baseVo.getCompany().getId());
            criteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);
            example.setOrderByClause("QUANTITY_START ASC");
            List<BiddingMatterStepSup> queryAllObjByExample = this.biddingMatterStepSupService.queryAllObjByExample(example);
            biddingOfferMatter.setBiddingMatterStepSupList(queryAllObjByExample);
            if (StringUtils.isNotBlank((String)biddingOfferMatter.getCostAnalysisId())) {
                service = ((TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId())).getOrderItemDetailService();
                biddingOfferMatter.setOrderItemDetail(service.queryObjByOrderItemId(biddingOfferMatter.getId()));
            }
            headerExample = new BiddingHeaderExample();
            headerExample.createCriteria().andBiddingNoEqualTo(biddingContent.getBiddingNo());
            biddingHeaders = this.biddingHeaderMapper.selectByExample(headerExample);
            biddingSendBidder = biddingHeaders.get(0).getBiddingSendBidder();
            if ("0".equals(biddingSendBidder)) {
                biddingOfferMatter.setUnitPrice(BigDecimal.valueOf(-1L));
                biddingOfferMatter.setAmount(BigDecimal.valueOf(-1L));
                continue;
            }
            if (!"1".equals(biddingSendBidder) || !"0".equals(biddingOfferMatter.getIsBidding())) continue;
            biddingOfferMatter.setUnitPrice(BigDecimal.valueOf(-1L));
            biddingOfferMatter.setAmount(BigDecimal.valueOf(-1L));
        }
        biddingContent.setBiddingOfferMatterList(biddingOfferMatterList);
        if (CollectionUtils.isNotEmpty(biddingOfferMatterList)) {
            BiddingOffer offerMatter = new BiddingOffer();
            offerMatter.setAllBidding(biddingOfferMatterList.get(0).getAllBidding());
            offerMatter.setIsPayMoney(baseVo.getIsPayMoney());
            biddingContent.setBiddingOfferMatter(offerMatter);
        }
        BiddingOfferExample modelExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria modelCriteria = modelExample.createCriteria();
        modelCriteria.andBiddingNoEqualTo(biddingContent.getBiddingNo());
        modelCriteria.andSupCompanyIdEqualTo(baseVo.getCompany().getId());
        modelCriteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);
        modelCriteria.andRequirementTypeCodeEqualTo("die");
        List<BiddingOffer> biddingOfferModelList = this.biddingOfferService.queryAllObjByExample(modelExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingOfferModelList) && i < biddingOfferModelList.size(); ++i) {
            BiddingOffer biddingOfferMatter = biddingOfferModelList.get(i);
            biddingOfferMatter.setLastOfferUnitPrice(biddingOfferMatter.getOfferUnitPrice());
            if (StringUtils.isNotBlank((String)biddingOfferMatter.getCostAnalysisId())) {
                service = ((TplMouldDetail)this.tplMouldDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId())).getMouldDetailService();
                biddingOfferMatter.setMouldDetail(service.queryByMouldId(biddingOfferMatter.getId()));
            }
            headerExample = new BiddingHeaderExample();
            headerExample.createCriteria().andBiddingNoEqualTo(biddingContent.getBiddingNo());
            biddingHeaders = this.biddingHeaderMapper.selectByExample(headerExample);
            biddingSendBidder = biddingHeaders.get(0).getBiddingSendBidder();
            if ("0".equals(biddingSendBidder)) {
                biddingOfferMatter.setUnitPrice(BigDecimal.valueOf(-1L));
                biddingOfferMatter.setAmount(BigDecimal.valueOf(-1L));
                continue;
            }
            if (!"1".equals(biddingSendBidder) || !"0".equals(biddingOfferMatter.getIsBidding())) continue;
            biddingOfferMatter.setUnitPrice(BigDecimal.valueOf(-1L));
            biddingOfferMatter.setAmount(BigDecimal.valueOf(-1L));
        }
        biddingContent.setBiddingOfferModelList(biddingOfferModelList);
        if (CollectionUtils.isNotEmpty(biddingOfferModelList)) {
            BiddingOffer offerModel = new BiddingOffer();
            offerModel.setAllBidding(biddingOfferModelList.get(0).getAllBidding());
            offerModel.setIsPayMoney(baseVo.getIsPayMoney());
            biddingContent.setBiddingOfferMode(offerModel);
        }
        BiddingOfferExample otheExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria otheCriteria = otheExample.createCriteria();
        otheCriteria.andBiddingNoEqualTo(biddingContent.getBiddingNo());
        otheCriteria.andSupCompanyIdEqualTo(baseVo.getCompany().getId());
        otheCriteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);
        otheCriteria.andRequirementTypeCodeEqualTo("device");
        List<BiddingOffer> biddingOfferOtheList = this.biddingOfferService.queryAllObjByExample(otheExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingOfferOtheList) && i < biddingOfferOtheList.size(); ++i) {
            BiddingOffer biddingOfferMatter = biddingOfferOtheList.get(i);
            biddingOfferMatter.setLastOfferUnitPrice(biddingOfferMatter.getOfferUnitPrice());
        }
        biddingContent.setBiddingOfferOtherList(biddingOfferOtheList);
        if (CollectionUtils.isNotEmpty(biddingOfferOtheList)) {
            BiddingOffer offerOther = new BiddingOffer();
            offerOther.setAllBidding(biddingOfferOtheList.get(0).getAllBidding());
            offerOther.setIsPayMoney(baseVo.getIsPayMoney());
            biddingContent.setBiddingOfferOther(offerOther);
            BiddingHeaderExample headerExample2 = new BiddingHeaderExample();
            headerExample2.createCriteria().andBiddingNoEqualTo(biddingContent.getBiddingNo());
            List<BiddingHeader> biddingHeaders2 = this.biddingHeaderMapper.selectByExample(headerExample2);
            String biddingSendBidder2 = biddingHeaders2.get(0).getBiddingSendBidder();
            if ("0".equals(biddingSendBidder2)) {
                offerOther.setUnitPrice(BigDecimal.valueOf(-1L));
                offerOther.setAmount(BigDecimal.valueOf(-1L));
            } else if ("1".equals(biddingSendBidder2) && "0".equals(offerOther.getIsBidding())) {
                offerOther.setUnitPrice(BigDecimal.valueOf(-1L));
                offerOther.setAmount(BigDecimal.valueOf(-1L));
            }
        }
    }

    @Override
    public BiddingBaseVo queryDocument(String biddingNo, Company company, User user, List<String> roleCodeList) {
        BiddingBaseVo baseVo = new BiddingBaseVo();
        baseVo.setRoleList(roleCodeList);
        String biddingType = "";
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); ++i) {
            BiddingHeader biddingHeader = biddingHeaderList.get(i);
            baseVo.setBiddingHeader(biddingHeader);
            BiddingPowerExample biddingPowerExample = new BiddingPowerExample();
            biddingPowerExample.createCriteria().andBiddingHeaderIdEqualTo(biddingHeader.getId());
            List biddingPowerList = this.biddingPowerService.queryAllObjByExample(biddingPowerExample);
            biddingHeader.setBiddingPower(CollectionUtils.isEmpty(biddingPowerList) ? null : (BiddingPower)biddingPowerList.get(0));
            biddingType = biddingHeader.getBiddingType();
        }
        BiddingPlanExample biddingPlanExample = new BiddingPlanExample();
        biddingPlanExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        biddingPlanExample.setOrderByClause(" BIDDING_ROUNDS_NUMBER ASC ");
        List<BiddingPlan> biddingPlanList = this.biddingPlanService.queryAllObjByExample(biddingPlanExample);
        baseVo.setBiddingPlanList(CollectionUtils.isEmpty(biddingPlanList) ? null : biddingPlanList);
        BiddingContactInfoExample biddingContactInfoExample = new BiddingContactInfoExample();
        biddingContactInfoExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContactInfo> biddingContactInfoList = this.biddingContactInfoService.queryAllObjByExample(biddingContactInfoExample);
        baseVo.setBiddingContactInfoList(CollectionUtils.isEmpty(biddingContactInfoList) ? null : biddingContactInfoList);
        BiddingBondExample biddingBondExample = new BiddingBondExample();
        biddingBondExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingBondList = this.biddingBondService.queryAllObjByExample(biddingBondExample);
        baseVo.setBiddingBond(CollectionUtils.isEmpty(biddingBondList) ? null : (BiddingBond)biddingBondList.get(0));
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContentList = this.biddingContentService.queryAllObjByExample(biddingContentExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentList) && i < biddingContentList.size(); ++i) {
            BiddingContent biddingContent = (BiddingContent)biddingContentList.get(i);
            baseVo.setBiddingContent(biddingContent);
            baseVo.setCompany(company);
            baseVo.setUser(user);
            this.setBiddingItemInfo(biddingContent, baseVo);
        }
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        biddingSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample);
        for (BiddingSupplier biddingSupplier : biddingSupplierList) {
            Date curDate = new Date();
            int biddingDeadline = this.compareTwoTimes(curDate, biddingHeaderList.get(0).getBiddingDeadline());
            if (TenderStatusEumn.ISCANCEL.getValue().equals(biddingSupplier.getSupBiddingStatus())) {
                biddingSupplier.setSupParticipate("7");
            } else if ((biddingDeadline == 1 || biddingDeadline == 0) && TenderStatusEumn.WAITBID.getValue().equals(biddingSupplier.getSupBiddingStatus())) {
                biddingSupplier.setSupParticipate("2");
            }
            if ("2".equals(biddingHeaderList.get(0).getBiddingType())) {
                BiddingOfferExample example = new BiddingOfferExample();
                BiddingOfferExample.Criteria criteria = example.createCriteria();
                criteria.andBiddingNoEqualTo(biddingNo);
                criteria.andSupCompanyIdEqualTo(biddingSupplier.getSupCompanyId());
                criteria.andBiddingRoundsNumberEqualTo(biddingHeaderList.get(0).getBiddingCurrentRound());
                criteria.andIsBiddingEqualTo("1");
                int count = this.biddingOfferService.countByExample(example);
                if (count > 0) {
                    biddingSupplier.setIsBidding("1");
                } else {
                    biddingSupplier.setIsBidding("0");
                }
            }
            BiddingSupplierHisExample biddingSupplierHisExample = new BiddingSupplierHisExample();
            BiddingSupplierHisExample.Criteria criteriaHis = biddingSupplierHisExample.createCriteria();
            criteriaHis.andBiddingNoEqualTo(biddingNo);
            criteriaHis.andSupCompanyIdEqualTo(biddingSupplier.getSupCompanyId());
            criteriaHis.andBiddingRoundsNumberEqualTo(biddingHeaderList.get(0).getBiddingCurrentRound());
            List<BiddingSupplierHis> biddingSupplierHisList = this.biddingSupplierHisService.queryAllObjByExample(biddingSupplierHisExample);
            biddingSupplier.setBiddingSupplierHisList(biddingSupplierHisList);
        }
        baseVo.setBiddingSupplierList(CollectionUtils.isEmpty(biddingSupplierList) ? null : biddingSupplierList);
        ArrayList<String> supplierIdList = new ArrayList<String>();
        ArrayList<String> supParticipateList = new ArrayList<String>();
        for (BiddingSupplier sup : biddingSupplierList) {
            if ("1".equals(sup.getSupBidding())) {
                supplierIdList.add(sup.getSupCompanyId());
            }
            if (!"1".equals(sup.getSupParticipate())) continue;
            supParticipateList.add(sup.getSupCompanyId());
        }
        BiddingFileExample biddingFileExample = new BiddingFileExample();
        biddingFileExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingFile> biddingFileList = this.biddingFileService.queryAllObjByExample(biddingFileExample);
        baseVo.setBiddingFiles(CollectionUtils.isEmpty(biddingFileList) ? null : biddingFileList);
        BiddingFileSupplierExample fileSupplierExample = new BiddingFileSupplierExample();
        fileSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingFileSupplier = this.biddingFileSupplierService.queryAllObjByExample(fileSupplierExample);
        ArrayList<BiddingFileSupplier> fileSupplierList = new ArrayList<BiddingFileSupplier>();
        for (BiddingFileSupplier fileSupplier : biddingFileSupplier) {
            if ("2".equals(biddingType)) {
                if (!supParticipateList.contains(fileSupplier.getSupCompanyId())) continue;
                fileSupplierList.add(fileSupplier);
                continue;
            }
            if (!supplierIdList.contains(fileSupplier.getSupCompanyId())) continue;
            fileSupplierList.add(fileSupplier);
        }
        baseVo.setBiddingFileSupplier(CollectionUtils.isEmpty(fileSupplierList) ? null : fileSupplierList);
        BiddingOnlineExample onlineExample = new BiddingOnlineExample();
        onlineExample.setOrderByClause("UNTAXED_UNIT_PRICE ASC");
        onlineExample.createCriteria().andBiddingNoEqualTo(biddingNo).andPurCompanyIdEqualTo(company.getId());
        List<BiddingOnline> biddingOnlineList = this.biddingOnlineService.queryAllObjByExample(onlineExample);
        baseVo.setBiddingOnlineList(CollectionUtils.isEmpty(biddingOnlineList) ? null : biddingOnlineList);
        onlineExample.clear();
        onlineExample.setOrderByClause("untaxedUnitPrice ASC,offerTime ASC");
        onlineExample.createCriteria().andBiddingNoEqualTo(biddingNo).andPurCompanyIdEqualTo(company.getId()).andQuotationStateNotEqualTo("0");
        List<BiddingOnline> list = this.biddingOnlineService.queryAllObj(onlineExample);
        BiddingOfferRankingVO offerRankingVo = new BiddingOfferRankingVO();
        offerRankingVo.setOnlineList(CollectionUtils.isEmpty(list) ? null : list);
        baseVo.setOfferRankingVO(offerRankingVo);
        return baseVo;
    }

    @Override
    public BiddingBaseVo queryDocumentRefresh(String biddingNo, Company company, User user, List<String> roleCodeList) {
        BiddingBaseVo baseVo = new BiddingBaseVo();
        baseVo.setRoleList(roleCodeList);
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContentList = this.biddingContentService.queryAllObjByExample(biddingContentExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentList) && i < biddingContentList.size(); ++i) {
            BiddingContent biddingContent = (BiddingContent)biddingContentList.get(i);
            baseVo.setBiddingContent(biddingContent);
            baseVo.setCompany(company);
            baseVo.setUser(user);
            this.setBiddingItemInfo(biddingContent, baseVo);
        }
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        biddingSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample);
        for (BiddingSupplier biddingSupplier : biddingSupplierList) {
            Date curDate = new Date();
            int biddingDeadline = this.compareTwoTimes(curDate, biddingHeaderList.get(0).getBiddingDeadline());
            if (TenderStatusEumn.ISCANCEL.getValue().equals(biddingSupplier.getSupBiddingStatus())) {
                biddingSupplier.setSupParticipate("7");
            } else if ((biddingDeadline == 1 || biddingDeadline == 0) && TenderStatusEumn.WAITBID.getValue().equals(biddingSupplier.getSupBiddingStatus())) {
                biddingSupplier.setSupParticipate("2");
            }
            if ("2".equals(biddingHeaderList.get(0).getBiddingType())) {
                BiddingOfferExample example = new BiddingOfferExample();
                BiddingOfferExample.Criteria criteria = example.createCriteria();
                criteria.andBiddingNoEqualTo(biddingNo);
                criteria.andSupCompanyIdEqualTo(biddingSupplier.getSupCompanyId());
                criteria.andBiddingRoundsNumberEqualTo(biddingHeaderList.get(0).getBiddingCurrentRound());
                criteria.andIsBiddingEqualTo("1");
                int count = this.biddingOfferService.countByExample(example);
                if (count > 0) {
                    biddingSupplier.setIsBidding("1");
                } else {
                    biddingSupplier.setIsBidding("0");
                }
            }
            BiddingSupplierHisExample biddingSupplierHisExample = new BiddingSupplierHisExample();
            BiddingSupplierHisExample.Criteria criteriaHis = biddingSupplierHisExample.createCriteria();
            criteriaHis.andBiddingNoEqualTo(biddingNo);
            criteriaHis.andSupCompanyIdEqualTo(biddingSupplier.getSupCompanyId());
            criteriaHis.andBiddingRoundsNumberEqualTo(biddingHeaderList.get(0).getBiddingCurrentRound());
            List<BiddingSupplierHis> biddingSupplierHisList = this.biddingSupplierHisService.queryAllObjByExample(biddingSupplierHisExample);
            biddingSupplier.setBiddingSupplierHisList(biddingSupplierHisList);
        }
        baseVo.setBiddingSupplierList(CollectionUtils.isEmpty(biddingSupplierList) ? null : biddingSupplierList);
        return baseVo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public BiddingBaseVo queryDocumentSup(String biddingNo, String biddingCurrentRound, Company company, User user, List<String> roleCodeList) {
        BiddingBaseVo baseVo = new BiddingBaseVo();
        baseVo.setRoleList(roleCodeList);
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); ++i) {
            BiddingHeader biddingHeader = biddingHeaderList.get(i);
            baseVo.setBiddingHeader(biddingHeader);
            BiddingPowerExample biddingPowerExample = new BiddingPowerExample();
            biddingPowerExample.createCriteria().andBiddingHeaderIdEqualTo(biddingHeader.getId());
            List biddingPowerList = this.biddingPowerService.queryAllObjByExample(biddingPowerExample);
            biddingHeader.setBiddingPower(CollectionUtils.isEmpty(biddingPowerList) ? null : (BiddingPower)biddingPowerList.get(0));
        }
        BiddingPlanExample biddingPlanExample = new BiddingPlanExample();
        biddingPlanExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        biddingPlanExample.setOrderByClause(" BIDDING_ROUNDS_NUMBER ASC ");
        List<BiddingPlan> biddingPlanList = this.biddingPlanService.queryAllObjByExample(biddingPlanExample);
        baseVo.setBiddingPlanList(CollectionUtils.isEmpty(biddingPlanList) ? null : biddingPlanList);
        BiddingContactInfoExample biddingContactInfoExample = new BiddingContactInfoExample();
        biddingContactInfoExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContactInfo> biddingContactInfoList = this.biddingContactInfoService.queryAllObjByExample(biddingContactInfoExample);
        baseVo.setBiddingContactInfoList(CollectionUtils.isEmpty(biddingContactInfoList) ? null : biddingContactInfoList);
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria criteria = biddingSupplierExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo);
        criteria.andSupCompanyIdEqualTo(company.getId());
        List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample);
        baseVo.setBiddingSupplier(CollectionUtils.isEmpty(biddingSupplierList) ? null : (BiddingSupplier)biddingSupplierList.get(0));
        BiddingBondExample biddingBondExample = new BiddingBondExample();
        biddingBondExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingBondList = this.biddingBondService.queryAllObjByExample(biddingBondExample);
        BiddingBond bond = null;
        if (CollectionUtils.isEmpty(biddingBondList)) {
            bond = null;
        } else {
            bond = (BiddingBond)biddingBondList.get(0);
            bond.setAttachmentSup(CollectionUtils.isEmpty(biddingSupplierList) ? null : ((BiddingSupplier)biddingSupplierList.get(0)).getBankAttachment());
        }
        baseVo.setBiddingBond(bond);
        baseVo.setIsPayMoney(CollectionUtils.isEmpty(biddingSupplierList) ? null : ((BiddingSupplier)biddingSupplierList.get(0)).getIsPayMoney());
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContentList = this.biddingContentService.queryAllObjByExample(biddingContentExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentList) && i < biddingContentList.size(); ++i) {
            BiddingContent biddingContent = (BiddingContent)biddingContentList.get(i);
            baseVo.setBiddingContent(biddingContent);
            baseVo.setCompany(company);
            baseVo.setUser(user);
            this.setBiddingItemInfoSup(biddingContent, biddingCurrentRound, baseVo);
        }
        BiddingFileExample biddingFileExample = new BiddingFileExample();
        biddingFileExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingFile> biddingFileList = this.biddingFileService.queryAllObjByExample(biddingFileExample);
        baseVo.setBiddingFiles(CollectionUtils.isEmpty(biddingFileList) ? null : biddingFileList);
        BiddingFileSupplierExample fileSupplierExample = new BiddingFileSupplierExample();
        fileSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupCompanyIdEqualTo(company.getId());
        List<BiddingFileSupplier> biddingFileSupplier = this.biddingFileSupplierService.queryAllObjByExample(fileSupplierExample);
        baseVo.setBiddingFileSupplier(CollectionUtils.isEmpty(biddingFileSupplier) ? null : biddingFileSupplier);
        BiddingOnlineExample onlineExample = new BiddingOnlineExample();
        onlineExample.setOrderByClause("OFFER_TIME DESC");
        onlineExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupCompanyIdEqualTo(company.getId());
        List<BiddingOnline> onlineList = this.biddingOnlineService.queryAllObjByExample(onlineExample);
        if (CollectionUtils.isNotEmpty(biddingHeaderList) && !"2".equals(biddingHeaderList.get(0).getBiddingAuditstatus())) {
            onlineList.forEach(online -> {
                if ("2".equals(online.getQuotationState())) {
                    online.setQuotationState("1");
                }
            });
        }
        baseVo.setBiddingOnlineList(CollectionUtils.isEmpty(onlineList) ? null : onlineList);
        onlineExample.clear();
        onlineExample.setOrderByClause("untaxedUnitPrice ASC,offerTime ASC");
        onlineExample.createCriteria().andBiddingNoEqualTo(biddingNo).andQuotationStateNotEqualTo("0");
        List<BiddingOnline> list = this.biddingOnlineService.queryAllObj(onlineExample);
        BiddingOfferRankingVO offerRankingVO = new BiddingOfferRankingVO();
        if (!CollectionUtils.isNotEmpty(list)) {
            offerRankingVO.setOnlineList(null);
            offerRankingVO.setRanking("");
            offerRankingVO.setLowestPrice(BigDecimal.ZERO);
        } else {
            int temp = 0;
            int index = 1;
            HashSet<BigDecimal> set = new HashSet<BigDecimal>();
            for (int i = 0; i < list.size(); ++i) {
                if (set.add(new BigDecimal(list.get(i).getUntaxedUnitPrice()))) {
                    if (company.getCompanyCode().equals(list.get(i).getSupCompanySrmCode())) {
                        offerRankingVO.setRanking(String.valueOf(index));
                        offerRankingVO.setLowestPrice(new BigDecimal(list.get(i).getUntaxedUnitPrice()));
                        break;
                    }
                    temp = index++;
                    continue;
                }
                if (!company.getCompanyCode().equals(list.get(i).getSupCompanySrmCode())) continue;
                offerRankingVO.setRanking(String.valueOf(temp));
                offerRankingVO.setLowestPrice(new BigDecimal(list.get(i).getUntaxedUnitPrice()));
                break;
            }
        }
        baseVo.setOfferRankingVO(offerRankingVO);
        return baseVo;
    }

    @Override
    public BiddingBaseVo queryDocumentSupRefresh(String biddingNo, String biddingCurrentRound, Company company, User user, List<String> roleCodeList) {
        BiddingBaseVo baseVo = new BiddingBaseVo();
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria criteria = biddingSupplierExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo);
        criteria.andSupCompanyIdEqualTo(company.getId());
        List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample);
        baseVo.setBiddingSupplier(CollectionUtils.isEmpty(biddingSupplierList) ? null : (BiddingSupplier)biddingSupplierList.get(0));
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContentList = this.biddingContentService.queryAllObjByExample(biddingContentExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentList) && i < biddingContentList.size(); ++i) {
            BiddingContent biddingContent = (BiddingContent)biddingContentList.get(i);
            baseVo.setBiddingContent(biddingContent);
            baseVo.setCompany(company);
            baseVo.setUser(user);
            this.setBiddingItemInfoSup(biddingContent, biddingCurrentRound, baseVo);
        }
        return baseVo;
    }

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    @Transactional
    public void toVoidDocument(String biddingNo) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); ++i) {
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(biddingHeaderList.get(i).getId());
            biddingHeader.setBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
            this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            supplierExample.createCriteria().andBiddingNoEqualTo(biddingHeaderList.get(i).getBiddingNo());
            List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample(supplierExample);
            for (BiddingSupplier supplier : biddingSupplierList) {
                BiddingSupplier biddingSupplier = new BiddingSupplier();
                biddingSupplier.setId(supplier.getId());
                biddingSupplier.setSupBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
                this.biddingSupplierService.modifyObj(biddingSupplier);
            }
            if ("1".equals(biddingHeaderList.get(i).getBiddingPreAuditstatus())) {
                this.workFlowService.stopProcess("ztbfbqsp", biddingHeaderList.get(i).getBiddingNo());
            }
            if (!"1".equals(biddingHeaderList.get(i).getBiddingAuditstatus())) continue;
            this.workFlowService.stopProcess("ztbdbsp", biddingHeaderList.get(i).getBiddingNo());
        }
    }

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    @Transactional
    public void deleteDocumentByBiddingNo(String biddingNo) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        BiddingHeader biddingHeader = biddingHeaderList.get(0);
        String biddingHeaderId = biddingHeader.getId();
        this.biddingPowerService.deleteByBiddingNo(biddingNo);
        this.biddingHeaderMapper.deleteByPrimaryKey(biddingHeaderId);
        this.biddingPlanService.deleteByBiddingNo(biddingNo);
        this.biddingContactInfoService.deleteByBiddingNo(biddingNo);
        this.biddingBondService.deleteByBiddingNo(biddingNo);
        this.biddingContentService.deleteByBiddingNo(biddingNo);
        this.biddingSupplierService.deleteByBiddingNo(biddingNo);
        this.biddingFileService.deleteByBiddingNo(biddingNo);
        this.biddingMatterStepService.deleteByBiddingNo(biddingNo);
        this.biddingMatterStepSupService.deleteByBiddingNo(biddingNo);
        this.biddingOfferService.deleteByBiddingNo(biddingNo);
    }

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void sendToApprove(List<String> bidingNoList) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoIn((List)bidingNoList);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingHeaderList.get(0).getBiddingNo());
        List biddingContentList = this.biddingContentService.queryAllObjByExample(biddingContentExample);
        if (CollectionUtils.isEmpty(biddingContentList)) {
            throw new CommonException("\u62db\u6807\u5355\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u6574\uff0c\u4e0d\u53ef\u5ba1\u6279\uff01", "not_all_complete", "\u62db\u6807\u5355");
        }
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); ++i) {
            ProcessStartVO vo = ProcessStartVO.newInstance("ztbfbqsp", biddingHeaderList.get(i).getBiddingNo(), biddingHeaderList.get(i).getId(), "addBidding?biddingNo=" + biddingHeaderList.get(i).getBiddingNo() + "&detailType=view");
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (startProcess == null) continue;
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(biddingHeaderList.get(i).getId());
            biddingHeader.setBiddingPreAuditstatus("1");
            biddingHeader.setApproveFlowId(startProcess.getProcessInstanceId());
            this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public void listen(TaskOperateEvent event) {
        Assert.isNotBlank(event.getBusinessId(), "\u53d1\u5e03\u524d\u5ba1\u6279\u5355\u636eID\u4e3a\u7a7a");
        BiddingHeader headerPrimarykey = this.biddingHeaderMapper.selectByPrimaryKey(event.getBusinessId());
        Date biddingDeadlineDate = headerPrimarykey.getBiddingDeadline();
        if (biddingDeadlineDate == null) {
            Calendar c = Calendar.getInstance();
            c.add(5, 1);
            biddingDeadlineDate = c.getTime();
        }
        int timeCompareBiddingDeadline = this.compareTwoTimes(new Date(), biddingDeadlineDate);
        boolean flag = false;
        if (TenderStatusEumn.ISCANCEL.getValue().equals(headerPrimarykey.getBiddingStatus())) {
            flag = true;
        } else if (TenderStatusEumn.NOTPUBLISH.getValue().equals(headerPrimarykey.getBiddingStatus()) && ("1".equals(headerPrimarykey.getBiddingPreAuditstatus()) || "2".equals(headerPrimarykey.getBiddingPreAuditstatus()) || "3".equals(headerPrimarykey.getBiddingPreAuditstatus())) && timeCompareBiddingDeadline == 1) {
            flag = true;
            System.out.println("\u8be5\u62db\u6807\u5355\u5df2\u7ec8\u6b62\u4e0d\u80fd\u5ba1\u6279\uff01");
        }
        BiddingHeader biddingHeader = new BiddingHeader();
        biddingHeader.setId(event.getBusinessId());
        if (event.isFinished() && event.isPass()) {
            biddingHeader.setBiddingPreAuditstatus("2");
            if (flag) throw new CommonException("\u8be5\u62db\u6807\u5355\u5df2\u7ec8\u6b62\u4e0d\u80fd\u5ba1\u6279\uff01");
            biddingHeader.setBiddingStatus(TenderStatusEumn.WAITBID.getValue());
            biddingHeader.setPublishDate(new Date());
            if (!"2".equals(headerPrimarykey.getBiddingType())) {
                try {
                    this.insertIntoOffer(event.getBusinessId(), new ArrayList<BiddingSupplier>());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.insertIntoOffer(event.getBusinessId(), new ArrayList<BiddingSupplier>());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        } else if (event.isFinished() && !event.isPass()) {
            biddingHeader.setBiddingPreAuditstatus("3");
            if (!flag) {
                biddingHeader.setBiddingStatus(TenderStatusEumn.NOTPUBLISH.getValue());
            }
        } else {
            biddingHeader.setBiddingPreAuditstatus("1");
        }
        this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
    }

    private void sendInformationToSupplier(BiddingHeader biddingHeader, BiddingSupplier supplier) {
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("biddingNo", biddingHeader.getBiddingNo());
        List<String> userIdList = this.companyUserRefService.queryUserOfCompany(supplier.getSupCompanyId());
        if (CollectionUtils.isNotEmpty(userIdList) && StringUtils.isNotBlank((String)userIdList.get(0))) {
            Message message = Message.init(msg).setCompanyCode(supplier.getPurCompanyCode()).setSenderId(supplier.getPurUserId()).setBusinessTypeCode("BIDDING_PUR_SEND_INFORMATION").addReceiverId(userIdList.get(0)).setMsgLevel(MessageLevelEnum.HIGH);
            MessageSendUtils.sendMessage((Message)message);
        }
    }

    @Override
    public void insertIntoOffer(String businessId, List<BiddingSupplier> biddingSupplierListSave) throws InstantiationException, IllegalAccessException {
        BiddingHeader biddingHeader = this.biddingHeaderMapper.selectByPrimaryKey(businessId);
        String biddingNo = biddingHeader.getBiddingNo();
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContentList = this.biddingContentService.queryAllObjByExample(biddingContentExample);
        String contentId = ((BiddingContent)biddingContentList.get(0)).getId();
        BiddingPlanExample biddingPlanExample = new BiddingPlanExample();
        biddingPlanExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        biddingPlanExample.setOrderByClause(" BIDDING_ROUNDS_NUMBER DESC ");
        List<BiddingPlan> biddingPlanList = this.biddingPlanService.queryAllObjByExample(biddingPlanExample);
        Integer effectiveNumber = ((BiddingPlan)biddingPlanList.get(0)).getEffectiveNumber();
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        biddingSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        ArrayList<BiddingSupplier> biddingSupplierList = new ArrayList<BiddingSupplier>();
        if (CollectionUtils.isNotEmpty(biddingSupplierListSave)) {
            biddingSupplierList.addAll(biddingSupplierListSave);
        } else {
            List queryAllObjByExample = this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample);
            biddingSupplierList.addAll(queryAllObjByExample);
        }
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
            this.saveMaterialInfo(biddingHeader, (BiddingSupplier)biddingSupplierList.get(i), biddingPlanList, contentId, effectiveNumber);
            this.saveModelInfo(biddingHeader, (BiddingSupplier)biddingSupplierList.get(i), biddingPlanList, contentId, effectiveNumber);
            this.saveOtherInfo(biddingHeader, (BiddingSupplier)biddingSupplierList.get(i), biddingPlanList, contentId, effectiveNumber);
            BiddingSupplier biddingSupplier = new BiddingSupplier();
            biddingSupplier.setId(((BiddingSupplier)biddingSupplierList.get(i)).getId());
            biddingSupplier.setSupBiddingStatus(TenderStatusEumn.WAITBID.getValue());
            this.biddingSupplierService.modifyObj(biddingSupplier);
            this.sendInformationToSupplier(biddingHeader, (BiddingSupplier)biddingSupplierList.get(i));
        }
    }

    private void saveOtherInfo(BiddingHeader biddingHeader, BiddingSupplier biddingSupplier, List<BiddingPlan> biddingPlanList, String contentId, Integer effectiveNumber) {
        BiddingContentOtherExample otherExample = new BiddingContentOtherExample();
        otherExample.createCriteria().andBiddingContentIdEqualTo(contentId);
        List biddingContentOtherList = this.biddingContentOtherService.queryAllObjByExample(otherExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingContentOtherList) && j < biddingContentOtherList.size(); ++j) {
            BiddingContentOther biddingContentOther = (BiddingContentOther)biddingContentOtherList.get(j);
            BiddingOffer biddingOffer = new BiddingOffer();
            this.setBaseBiddingOffer(biddingHeader, biddingSupplier, biddingPlanList, biddingOffer);
            biddingOffer.setRequirementTypeCode("device");
            biddingOffer.setRequirementTypeName("\u5176\u4ed6");
            biddingOffer.setProjectNo(biddingContentOther.getTargetNo());
            biddingOffer.setProjectName(biddingContentOther.getTargetName());
            biddingOffer.setProjectDesc(biddingContentOther.getTaregtDesc());
            biddingOffer.setUnitPrice(biddingContentOther.getUnitPrice());
            biddingOffer.setUnit(biddingContentOther.getUnit());
            biddingOffer.setCurrency(biddingContentOther.getCurrency());
            biddingOffer.setAllBidding(biddingContentOther.getAllBidding());
            biddingOffer.setEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setRestEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setPictureAttachment(biddingContentOther.getPictureAttachment());
            biddingOffer.setDesignPicAttachment(biddingContentOther.getDesignPicAttachment());
            biddingOffer.setOtherId(biddingContentOther.getId());
            biddingOffer.setOfferLowerLimit(biddingContentOther.getOfferLowerLimit());
            biddingOffer.setOfferUpperLimit(biddingContentOther.getOfferUpperLimit());
            biddingOffer.setHistoryPurchaseQty(biddingContentOther.getHistoryPurchaseQty());
            biddingOffer.setHistoryPurchaseCycle(biddingContentOther.getHistoryPurchaseCycle());
            this.biddingOfferService.addObj(biddingOffer);
        }
    }

    private void saveModelInfo(BiddingHeader biddingHeader, BiddingSupplier biddingSupplier, List<BiddingPlan> biddingPlanList, String contentId, Integer effectiveNumber) {
        BiddingContentModelExample modelExample = new BiddingContentModelExample();
        modelExample.createCriteria().andBiddingContentIdEqualTo(contentId);
        List biddingContentModelList = this.biddingContentModelService.queryAllObjByExample(modelExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingContentModelList) && j < biddingContentModelList.size(); ++j) {
            BiddingOffer biddingOffer = new BiddingOffer();
            this.setBaseBiddingOffer(biddingHeader, biddingSupplier, biddingPlanList, biddingOffer);
            BiddingContentModel biddingContentModel = (BiddingContentModel)biddingContentModelList.get(j);
            biddingOffer.setRequirementTypeCode("die");
            biddingOffer.setRequirementTypeName("\u6a21\u5177");
            biddingOffer.setProjectNo(biddingContentModel.getModelNo());
            biddingOffer.setProjectName(biddingContentModel.getModelName());
            biddingOffer.setProjectDesc(biddingContentModel.getModelDesc());
            biddingOffer.setUseModel(biddingContentModel.getUseModel());
            biddingOffer.setBeloneYear(biddingContentModel.getBeloneYear());
            biddingOffer.setModelSerialNumber(biddingContentModel.getModelSerialNumber());
            biddingOffer.setModelMaterial(biddingContentModel.getModelMaterial());
            biddingOffer.setPropertyRight(biddingContentModel.getPropertyRight());
            biddingOffer.setModelSinking(biddingContentModel.getModelSinking());
            biddingOffer.setModelLife(biddingContentModel.getModelLife());
            biddingOffer.setCurrency(biddingContentModel.getCurrency());
            biddingOffer.setUnitPrice(biddingContentModel.getUnitPrice());
            biddingOffer.setDeliveryDate(biddingContentModel.getDeliveryDate());
            biddingOffer.setAllBidding(biddingContentModel.getAllBidding());
            biddingOffer.setEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setRestEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setPictureAttachment(biddingContentModel.getPictureAttachment());
            biddingOffer.setDesignPicAttachment(biddingContentModel.getDesignPicAttachment());
            biddingOffer.setModelId(biddingContentModel.getId());
            biddingOffer.setCostAnalysisId(biddingContentModel.getCostAnalysisId());
            biddingOffer.setOfferLowerLimit(biddingContentModel.getOfferLowerLimit());
            biddingOffer.setOfferUpperLimit(biddingContentModel.getOfferUpperLimit());
            biddingOffer.setHistoryPurchaseQty(biddingContentModel.getHistoryPurchaseQty());
            biddingOffer.setHistoryPurchaseCycle(biddingContentModel.getHistoryPurchaseCycle());
            this.biddingOfferService.addObj(biddingOffer);
            if (!StringUtils.isNotBlank((String)biddingContentModel.getCostAnalysisId())) continue;
            TplMouldDetail tplMould = (TplMouldDetail)this.tplMouldDetailService.queryObjById(biddingContentModel.getCostAnalysisId());
            IMouldDetailService service = tplMould.getMouldDetailService();
            MouldDetail mouldDetail = new MouldDetail();
            mouldDetail.setMouldId(biddingOffer.getId());
            mouldDetail.setTemplateId(biddingContentModel.getCostAnalysisId());
            mouldDetail.setSupCompanyId(biddingSupplier.getSupCompanyId());
            mouldDetail.setSupCompanyName(biddingSupplier.getSupCompanyName());
            mouldDetail.setSupCompanySapCode(biddingSupplier.getSupCompanySapCode());
            mouldDetail.setSupCompanySrmCode(biddingSupplier.getSupCompanySrmCode());
            mouldDetail.setPurOrderId(biddingHeader.getBiddingNo());
            mouldDetail.setSupOrderId(biddingHeader.getBiddingNo());
            mouldDetail.setCreateTime(new Date());
            mouldDetail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(mouldDetail));
            service.addObj(mouldDetail);
        }
    }

    private void saveMaterialInfo(BiddingHeader biddingHeader, BiddingSupplier biddingSupplier, List<BiddingPlan> biddingPlanList, String contentId, Integer effectiveNumber) throws InstantiationException, IllegalAccessException {
        BiddingContentMatterExample matterExample = new BiddingContentMatterExample();
        matterExample.createCriteria().andBiddingContentIdEqualTo(contentId);
        List biddingContentMatterList = this.biddingContentMatterService.queryAllObjByExample(matterExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingContentMatterList) && j < biddingContentMatterList.size(); ++j) {
            BiddingContentMatter biddingContentMatter = (BiddingContentMatter)biddingContentMatterList.get(j);
            BiddingOffer biddingOffer = new BiddingOffer();
            this.setBaseBiddingOffer(biddingHeader, biddingSupplier, biddingPlanList, biddingOffer);
            biddingOffer.setRequirementTypeCode("material");
            biddingOffer.setRequirementTypeName("\u7269\u6599");
            biddingOffer.setModelNo(biddingContentMatter.getMaterialNo());
            biddingOffer.setProjectNo(biddingContentMatter.getMaterialNo());
            biddingOffer.setProjectName(biddingContentMatter.getMaterialName());
            biddingOffer.setProjectDesc(biddingContentMatter.getMaterialDesc());
            biddingOffer.setBiddingQuantity(biddingContentMatter.getBiddingQuantity());
            biddingOffer.setCurrency(biddingContentMatter.getCurrency());
            biddingOffer.setUnitPrice(biddingContentMatter.getUnitPrice());
            biddingOffer.setMaterialFeatures(biddingContentMatter.getMaterialFeatures());
            biddingOffer.setMaterialSpec(biddingContentMatter.getMaterialSpec());
            biddingOffer.setMaterialModel(biddingContentMatter.getMaterialModel());
            biddingOffer.setUnit(biddingContentMatter.getUnit());
            biddingOffer.setAllBidding(biddingContentMatter.getAllBidding());
            biddingOffer.setEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setRestEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setQuotationMethod(biddingContentMatter.getQuotationMethod());
            biddingOffer.setIsStep(biddingContentMatter.getIsStep());
            biddingOffer.setQuantity(biddingContentMatter.getDosage());
            biddingOffer.setAmount(biddingContentMatter.getSetThePrice());
            biddingOffer.setPictureAttachment(biddingContentMatter.getPictureAttachment());
            biddingOffer.setDesignPicAttachment(biddingContentMatter.getDesignPicAttachment());
            biddingOffer.setMatterId(biddingContentMatter.getId());
            biddingOffer.setTempMaterialNo(biddingContentMatter.getTempMaterialNo());
            biddingOffer.setCostAnalysisId(biddingContentMatter.getCostAnalysisId());
            biddingOffer.setOfferLowerLimit(biddingContentMatter.getOfferLowerLimit());
            biddingOffer.setOfferUpperLimit(biddingContentMatter.getOfferUpperLimit());
            biddingOffer.setHistoryPurchaseQty(biddingContentMatter.getHistoryPurchaseQty());
            biddingOffer.setHistoryPurchaseCycle(biddingContentMatter.getHistoryPurchaseCycle());
            this.biddingOfferService.addObj(biddingOffer);
            if (StringUtils.isNotBlank((String)biddingContentMatter.getQuotationMethod()) && biddingContentMatter.getQuotationMethod().equals("2")) {
                this.saveStepSupInfo(biddingContentMatter, biddingHeader, biddingSupplier, biddingPlanList, biddingOffer.getId());
            }
            if (!StringUtils.isNotBlank((String)biddingContentMatter.getCostAnalysisId())) continue;
            TplOrderItemDetail tpl = (TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById(biddingContentMatter.getCostAnalysisId());
            IOrderItemDetailService service = tpl.getOrderItemDetailService();
            IOrderItemDetail detail = tpl.getOrderItemDetailClass().newInstance();
            detail.setOrderItemId(biddingOffer.getId());
            detail.setTemplateId(biddingContentMatter.getCostAnalysisId());
            detail.setMaterialCode(biddingContentMatter.getMaterialNo());
            detail.setMaterialDesc(biddingContentMatter.getMaterialDesc());
            detail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(detail));
            service.addObj(detail);
        }
    }

    private void saveStepSupInfo(BiddingContentMatter biddingContentMatter, BiddingHeader biddingHeader, BiddingSupplier biddingSupplier, List<BiddingPlan> biddingPlanList, String biddingOfferId) {
        BiddingMatterStepExample example = new BiddingMatterStepExample();
        example.createCriteria().andMatterIdEqualTo(biddingContentMatter.getId());
        List biddingMatterStepList = this.biddingMatterStepService.queryAllObjByExample(example);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingMatterStepList) && i < biddingMatterStepList.size(); ++i) {
            BiddingMatterStep biddingMatterStep = (BiddingMatterStep)biddingMatterStepList.get(i);
            BiddingMatterStepSup biddingMatterStepSup = new BiddingMatterStepSup();
            biddingMatterStepSup.setBiddingOfferId(biddingOfferId);
            biddingMatterStepSup.setPurCompanyId(biddingHeader.getPurCompanyId());
            biddingMatterStepSup.setPurCompanySrmCode(biddingHeader.getPurCompanyCode());
            biddingMatterStepSup.setPurCompanyName(biddingHeader.getPurCompanyName());
            biddingMatterStepSup.setPurUserId(biddingHeader.getPurUserId());
            biddingMatterStepSup.setPurUserName(biddingHeader.getPurUserName());
            biddingMatterStepSup.setSupCompanyId(biddingSupplier.getSupCompanyId());
            biddingMatterStepSup.setSupCompanyName(biddingSupplier.getSupCompanyName());
            biddingMatterStepSup.setSupCompanySrmCode(biddingSupplier.getSupCompanySrmCode());
            biddingMatterStepSup.setSupCompanySapCode(biddingSupplier.getSupCompanySapCode());
            biddingMatterStepSup.setSupUserId(biddingSupplier.getSupUserId());
            biddingMatterStepSup.setSupUserName(biddingSupplier.getSupUserName());
            biddingMatterStepSup.setCreateTime(new Date());
            biddingMatterStepSup.setBiddingNo(biddingHeader.getBiddingNo());
            biddingMatterStepSup.setBiddingRoundsNumber(biddingPlanList.get(0).getBiddingRoundsNumber());
            biddingMatterStepSup.setBiddingTotalRound(biddingPlanList.get(0).getBiddingTotalRound());
            biddingMatterStepSup.setMaterialNo(biddingMatterStep.getMaterialNo());
            biddingMatterStepSup.setMaterialName(biddingMatterStep.getMaterialName());
            biddingMatterStepSup.setMaterialDesc(biddingMatterStep.getMaterialDesc());
            biddingMatterStepSup.setBiddingHeaderId(biddingHeader.getId());
            biddingMatterStepSup.setMatterId(biddingContentMatter.getId());
            biddingMatterStepSup.setQuantityStart(biddingMatterStep.getQuantityStart());
            biddingMatterStepSup.setQuantityEnd(biddingMatterStep.getQuantityEnd());
            this.biddingMatterStepSupService.addObj(biddingMatterStepSup);
        }
    }

    private void setBaseBiddingOffer(BiddingHeader biddingHeader, BiddingSupplier biddingSupplier, List<BiddingPlan> biddingPlanList, BiddingOffer biddingOffer) {
        biddingOffer.setPurCompanyId(biddingHeader.getPurCompanyId());
        biddingOffer.setPurCompanySrmCode(biddingHeader.getPurCompanyCode());
        biddingOffer.setPurCompanyName(biddingHeader.getPurCompanyName());
        biddingOffer.setPurUserId(biddingHeader.getPurUserId());
        biddingOffer.setPurUserName(biddingHeader.getPurUserName());
        biddingOffer.setSupCompanyId(biddingSupplier.getSupCompanyId());
        biddingOffer.setSupCompanyName(biddingSupplier.getSupCompanyName());
        biddingOffer.setSupCompanySrmCode(biddingSupplier.getSupCompanySrmCode());
        biddingOffer.setSupCompanySapCode(biddingSupplier.getSupCompanySapCode());
        biddingOffer.setSupUserId(biddingSupplier.getSupUserId());
        biddingOffer.setSupUserName(biddingSupplier.getSupUserName());
        biddingOffer.setCreateTime(new Date());
        biddingOffer.setBiddingNo(biddingHeader.getBiddingNo());
        biddingOffer.setBiddingRoundsNumber(biddingPlanList.get(0).getBiddingRoundsNumber());
        biddingOffer.setBiddingTotalRound(biddingPlanList.get(0).getBiddingTotalRound());
        biddingOffer.setMaterialStstus(biddingSupplier.getPartnerRoleCode());
        biddingOffer.setSupplierTemporaryCode(biddingSupplier.getSupplierTemporaryCode());
        Company company = (Company)this.companyService.queryObjById(biddingSupplier.getSupCompanyId());
        biddingOffer.setMaterialDevel(company.getGrade());
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void finisnBidding(String biddingNo) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); ++i) {
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(biddingHeaderList.get(i).getId());
            biddingHeader.setBiddingStatus(TenderStatusEumn.ISFINISH.getValue());
            this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
        }
        BiddingSupplierExample supplierExample = new BiddingSupplierExample();
        supplierExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupBiddingStatusEqualTo(TenderStatusEumn.ISSCALING.getValue());
        List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample(supplierExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
            BiddingSupplier biddingSupplier = new BiddingSupplier();
            biddingSupplier.setId(((BiddingSupplier)biddingSupplierList.get(i)).getId());
            biddingSupplier.setSupBiddingStatus(TenderStatusEumn.ISFINISH.getValue());
            this.biddingSupplierService.modifyObj(biddingSupplier);
        }
        BiddingHeaderExample headerExample = new BiddingHeaderExample();
        headerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> headerList = this.queryAllObjByExample(headerExample);
        List materialList = null;
        List biddingOnlineList = null;
        if (!"2".equals(headerList.get(0).getBiddingType())) {
            BiddingOfferExample offerExample = new BiddingOfferExample();
            offerExample.createCriteria().andBiddingNoEqualTo(biddingNo).andIsBiddingEqualTo("1");
            materialList = this.biddingOfferService.queryAllObjByExample(offerExample);
            if (CollectionUtils.isEmpty(materialList)) {
                return;
            }
        } else {
            BiddingOnlineExample onlineExample = new BiddingOnlineExample();
            onlineExample.createCriteria().andBiddingNoEqualTo(biddingNo).andQuotationStateEqualTo("2");
            biddingOnlineList = this.biddingOnlineService.queryAllObjByExample(onlineExample);
            if (CollectionUtils.isEmpty(biddingOnlineList)) {
                return;
            }
        }
    }

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void editStatus(BiddingHeader biddingHeader, BiddingHeaderExample example) {
        this.biddingHeaderMapper.updateByExampleSelective(biddingHeader, example);
    }

    @Override
    public List<ManagementPage> screenDataByBiddingStatus(List<ManagementPage> list, List<String> biddingStatusList) {
        if (CollectionUtils.isNotEmpty(biddingStatusList)) {
            ArrayList<ManagementPage> finalList = new ArrayList<ManagementPage>();
            for (int i = 0; CollectionUtils.isNotEmpty(list) && i < list.size(); ++i) {
                if (!biddingStatusList.contains(list.get(i).getBiddingStatus())) continue;
                finalList.add(list.get(i));
            }
            return finalList;
        }
        return list;
    }
}

