/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.bidding.dao.BiddingOfferHisMapper;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingMatterStepSup;
import com.els.base.bidding.entity.BiddingMatterStepSupExample;
import com.els.base.bidding.entity.BiddingOfferHis;
import com.els.base.bidding.entity.BiddingOfferHisExample;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferHisService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingOfferHisService")
public class BiddingOfferHisServiceImpl
implements BiddingOfferHisService {
    @Resource
    protected BiddingOfferHisMapper biddingOfferHisMapper;
    @Resource
    protected BiddingHeaderService biddingHeaderService;
    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;

    @Override
    @CacheEvict(value={"biddingOfferHis"}, allEntries=true)
    public void addObj(BiddingOfferHis t) {
        this.biddingOfferHisMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingOfferHis"}, allEntries=true)
    public void addAll(List<BiddingOfferHis> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingOfferHisMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"biddingOfferHis"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingOfferHisMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"biddingOfferHis"}, allEntries=true)
    public void deleteByExample(BiddingOfferHisExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.biddingOfferHisMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"biddingOfferHis"}, allEntries=true)
    public void modifyObj(BiddingOfferHis t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.biddingOfferHisMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"biddingOfferHis"}, keyGenerator="redisKeyGenerator")
    public BiddingOfferHis queryObjById(String id) {
        return this.biddingOfferHisMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"biddingOfferHis"}, keyGenerator="redisKeyGenerator")
    public List<BiddingOfferHis> queryAllObjByExample(BiddingOfferHisExample example) {
        return this.biddingOfferHisMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"biddingOfferHis"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingOfferHis> queryObjByPage(BiddingOfferHisExample example) {
        PageView<BiddingOfferHis> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingOfferHisMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<BiddingOfferHis> findBiddingOfferHis(String biddingNo, String type, String isBidding, String currentRound, User user, Company company, String biddingOfferId) {
        BiddingOfferHisExample offerExample = new BiddingOfferHisExample();
        offerExample.setOrderByClause(" OFFER_TIME DESC,OFFER_PRICE_UPDATE_TIME DESC,SUP_COMPANY_SRM_CODE DESC,PROJECT_DESC DESC,MATERIAL_DEVEL ASC ");
        BiddingOfferHisExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type).andBiddingRoundsNumberEqualTo(currentRound).andSupCompanyIdEqualTo(company.getId()).andTBaseBiddingOfferIdEqualTo(biddingOfferId);
        List<BiddingOfferHis> biddingOfferHisList = this.biddingOfferHisMapper.selectByExample(offerExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferHisList) && j < biddingOfferHisList.size(); ++j) {
            BiddingOfferHis biddingOfferHis = biddingOfferHisList.get(j);
            if (type.equals(type)) {
                BiddingMatterStepSupExample example = new BiddingMatterStepSupExample();
                example.createCriteria().andBiddingOfferIdEqualTo(biddingOfferHis.getId()).andBiddingRoundsNumberEqualTo(currentRound).andSupCompanyIdEqualTo(company.getId());
                List<BiddingMatterStepSup> biddingMatterStepSups = this.biddingMatterStepSupService.queryAllObjByExample(example);
                biddingOfferHis.setBiddingMatterStepSupList(biddingMatterStepSups);
                BigDecimal offerUnitPrice = biddingOfferHis.getOfferUnitPrice() == null ? BigDecimal.ZERO : new BigDecimal(biddingOfferHis.getOfferUnitPrice());
                BigDecimal quantity = biddingOfferHis.getQuantity() == null ? BigDecimal.ZERO : new BigDecimal(biddingOfferHis.getQuantity());
                biddingOfferHis.setOfferSetPrice(offerUnitPrice.multiply(quantity).toString());
            }
            BiddingHeaderExample headerExample = new BiddingHeaderExample();
            headerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
            List biddingHeaders = this.biddingHeaderService.queryAllObjByExample(headerExample);
            String biddingSendBidder = ((BiddingHeader)biddingHeaders.get(0)).getBiddingSendBidder();
            if ("0".equals(biddingSendBidder)) {
                biddingOfferHis.setUnitPrice(BigDecimal.valueOf(-1L));
                biddingOfferHis.setAmount(BigDecimal.valueOf(-1L));
                continue;
            }
            if (!"1".equals(biddingSendBidder) || !"0".equals(biddingOfferHis.getIsBidding())) continue;
            biddingOfferHis.setUnitPrice(BigDecimal.valueOf(-1L));
            biddingOfferHis.setAmount(BigDecimal.valueOf(-1L));
        }
        return biddingOfferHisList;
    }
}

