/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.bidding.dao.BiddingOfferMapper;
import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentMatterExample;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentModelExample;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingContentOtherExample;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingMatterStepSup;
import com.els.base.bidding.entity.BiddingMatterStepSupExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.BiddingOfferHis;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.BiddingSupplierHis;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.ImportBiddingToSapVo;
import com.els.base.bidding.entity.vo.ReportShow;
import com.els.base.bidding.entity.vo.SaveBidInfoVo;
import com.els.base.bidding.entity.vo.TemporaryCodeReducedRate;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingContentMatterService;
import com.els.base.bidding.service.BiddingContentModelService;
import com.els.base.bidding.service.BiddingContentOtherService;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferHisService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingSupplierHisService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.bidding.service.SyncBiddingService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.BaseService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.IMouldDetailService;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.entity.InformationRecord;
import com.els.base.inquiry.entity.SystemPrice;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.service.InformationRecordService;
import com.els.base.inquiry.service.SystemPriceService;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.entity.SupplierMaterialExample;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.utils.SpringContextHolder;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingOfferService")
public class BiddingOfferServiceImpl
implements BiddingOfferService {
    @Resource
    protected BiddingOfferMapper biddingOfferMapper;
    @Resource
    protected BiddingContentMatterService biddingContentMatterService;
    @Resource
    protected BiddingContentModelService biddingContentModelService;
    @Resource
    protected BiddingContentOtherService biddingContentOtherService;
    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected BiddingContentService biddingContentService;
    @Resource
    protected BiddingHeaderService biddingHeaderService;
    @Resource
    protected BiddingSupplierService biddingSupplierService;
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;
    @Resource
    protected TplMouldDetailService tplMouldDetailService;
    @Resource
    protected BiddingOfferHisService biddingOfferHisService;
    @Resource
    private SystemPriceService systemPriceService;
    @Resource
    private InformationRecordService informationRecordService;
    @Resource
    protected BiddingSupplierHisService biddingSupplierHisService;

    @Override
    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    public void addObj(BiddingOffer t) {
        this.biddingOfferMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingOfferMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    public void modifyObj(BiddingOffer t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingOfferMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    public void updateByExampleSelective(BiddingOffer biddingOffer, BiddingOfferExample example) {
        this.biddingOfferMapper.updateByExampleSelective(biddingOffer, example);
    }

    @Override
    @Cacheable(value={"biddingOffer"}, keyGenerator="redisKeyGenerator")
    public BiddingOffer queryObjById(String id) {
        return this.biddingOfferMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"biddingOffer"}, keyGenerator="redisKeyGenerator")
    public List<BiddingOffer> queryAllObjByExample(BiddingOfferExample example) {
        return this.biddingOfferMapper.selectByExample(example);
    }

    @Override
    public int countByExample(BiddingOfferExample example) {
        return this.biddingOfferMapper.countByExample(example);
    }

    @Override
    @Cacheable(value={"biddingOffer"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingOffer> queryObjByPage(BiddingOfferExample example) {
        PageView<BiddingOffer> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingOfferMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    @Transactional
    public void saveUnitPrice(BiddingBaseVo biddingBaseVo) throws InstantiationException, IllegalAccessException {
        BiddingContent biddingContent;
        Company supCompany = biddingBaseVo.getCompany();
        User supUser = biddingBaseVo.getUser();
        String biddingType = biddingBaseVo.getBiddingHeader().getBiddingType();
        String biddingCurrentRound = biddingBaseVo.getBiddingHeader().getBiddingCurrentRound();
        String biddingNo = biddingBaseVo.getBiddingHeader().getBiddingNo();
        String handleType = biddingBaseVo.getHandleType();
        Date currentDate = new Date();
        BiddingSupplier biddingSupplier = biddingBaseVo.getBiddingSupplier();
        if (biddingSupplier != null) {
            BiddingSupplier suppliers = new BiddingSupplier();
            suppliers.setLastUpdateTime(currentDate);
            suppliers.setLastUpdateUser(supUser.getNickName());
            suppliers.setRateValue(biddingSupplier.getRateValue());
            suppliers.setLastUpdateUser(supUser.getNickName());
            suppliers.setRateValue(biddingSupplier.getRateValue());
            suppliers.setCurrency(biddingSupplier.getCurrency());
            suppliers.setRemark(biddingSupplier.getRemark());
            BiddingSupplierExample example = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria biddingCriteria = example.createCriteria();
            biddingCriteria.andBiddingNoEqualTo(biddingBaseVo.getBiddingHeader().getBiddingNo());
            biddingCriteria.andSupCompanyIdEqualTo(supCompany.getId());
            this.biddingSupplierService.modifyObjSup(suppliers, example);
        }
        if ((biddingContent = biddingBaseVo.getBiddingContent()) != null) {
            this.updateBiddingOfferPrice(biddingContent, supCompany, supUser, handleType, biddingType, currentDate, biddingCurrentRound, biddingNo, biddingSupplier);
        }
    }

    private boolean isUpdateOfferPrice(BiddingOffer biddingOffer) {
        biddingOffer.getEffectiveNumber();
        biddingOffer.getRestEffectiveNumber();
        return Integer.valueOf(biddingOffer.getRestEffectiveNumber() == null ? "0" : biddingOffer.getRestEffectiveNumber()) > 0;
    }

    private void updatebiddingOfferRestEffectiveNumber(BiddingOffer BiddingOffer2, String requirementTypeCode, Company supCompany, User supUser, Date currentDate) {
        BiddingOfferExample example = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = example.createCriteria();
        criteria.andBiddingNoEqualTo(BiddingOffer2.getBiddingNo());
        criteria.andSupCompanyIdEqualTo(supCompany.getId());
        criteria.andBiddingRoundsNumberEqualTo(BiddingOffer2.getBiddingRoundsNumber());
        criteria.andRequirementTypeCodeEqualTo(requirementTypeCode);
        List<BiddingOffer> biddingOfferMatterList = this.biddingOfferMapper.selectByExample(example);
        for (BiddingOffer biddingOffer : biddingOfferMatterList) {
            biddingOffer.setOfferTime((biddingOffer.getOfferTime() == null ? 0 : biddingOffer.getOfferTime()) + 1);
            biddingOffer.setRestEffectiveNumber(String.valueOf(Integer.valueOf(biddingOffer.getRestEffectiveNumber()) - 1));
            biddingOffer.setOfferPriceUpdateUser(supUser.getNickName());
            BiddingOffer offer = new BiddingOffer();
            offer.setId(biddingOffer.getId());
            offer.setRestEffectiveNumber(biddingOffer.getRestEffectiveNumber());
            offer.setOfferPriceUpdateUser(supUser.getNickName());
            offer.setOfferTime(biddingOffer.getOfferTime());
            this.biddingOfferMapper.updateByPrimaryKeySelective(offer);
            BiddingOfferHis biddingOfferHis = new BiddingOfferHis();
            BeanUtils.copyProperties((Object)biddingOffer, (Object)biddingOfferHis);
            biddingOfferHis.settBaseBiddingOfferId(biddingOffer.getId());
            biddingOfferHis.setId(null);
            this.biddingOfferHisService.addObj(biddingOfferHis);
        }
    }

    private void updateBiddingOfferPrice(BiddingContent biddingContent, Company supCompany, User supUser, String handleType, String biddingType, Date currentDate, String biddingCurrentRound, String biddingNo, BiddingSupplier biddingSupplierParm) throws InstantiationException, IllegalAccessException {
        if (biddingContent != null) {
            BiddingOffer biddingOffer;
            if ("send".equals(handleType)) {
                BiddingSupplier biddingSupplier = new BiddingSupplier();
                biddingSupplier.setLastUpdateTime(currentDate);
                biddingSupplier.setLastUpdateUser(supUser.getNickName());
                biddingSupplier.setSupBidding("1");
                BiddingSupplierExample example = new BiddingSupplierExample();
                BiddingSupplierExample.Criteria biddingCriteria = example.createCriteria();
                biddingCriteria.andBiddingNoEqualTo(biddingNo);
                biddingCriteria.andSupCompanyIdEqualTo(supCompany.getId());
                this.biddingSupplierService.modifyObjSup(biddingSupplier, example);
            }
            if (CollectionUtils.isNotEmpty(biddingContent.getBiddingOfferMatterList())) {
                List<BiddingOffer> biddingOfferMatterList = biddingContent.getBiddingOfferMatterList();
                biddingOffer = new BiddingOffer();
                biddingOffer.setEffectiveNumber(biddingOfferMatterList.get(0).getEffectiveNumber());
                biddingOffer.setRestEffectiveNumber(biddingOfferMatterList.get(0).getRestEffectiveNumber());
                boolean flag = this.isUpdateOfferPrice(biddingOffer);
                this.updateBiddingOfferMatter(biddingOfferMatterList, supCompany, supUser, handleType, biddingType, currentDate);
                if ("send".equals(handleType)) {
                    if (flag) {
                        this.updatebiddingOfferRestEffectiveNumber(biddingOfferMatterList.get(0), "material", supCompany, supUser, currentDate);
                    } else {
                        throw new CommonException("\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4fdd\u5b58\u5931\u8d25", "finish_status", "\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u4ef7\uff01");
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(biddingContent.getBiddingOfferModelList())) {
                List<BiddingOffer> biddingOfferModelList = biddingContent.getBiddingOfferModelList();
                biddingOffer = new BiddingOffer();
                biddingOffer.setEffectiveNumber(biddingOfferModelList.get(0).getEffectiveNumber());
                biddingOffer.setRestEffectiveNumber(biddingOfferModelList.get(0).getRestEffectiveNumber());
                boolean flag = this.isUpdateOfferPrice(biddingOffer);
                this.updateBiddingOffer(biddingOfferModelList, supCompany, supUser, "die", handleType, biddingType, currentDate);
                if ("send".equals(handleType)) {
                    if (flag) {
                        this.updatebiddingOfferRestEffectiveNumber(biddingOfferModelList.get(0), "die", supCompany, supUser, currentDate);
                    } else {
                        throw new CommonException("\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4fdd\u5b58\u5931\u8d25", "finish_status", "\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u4ef7\uff01");
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(biddingContent.getBiddingOfferOtherList())) {
                List<BiddingOffer> biddingOfferOtherList = biddingContent.getBiddingOfferOtherList();
                biddingOffer = new BiddingOffer();
                biddingOffer.setEffectiveNumber(biddingOfferOtherList.get(0).getEffectiveNumber());
                biddingOffer.setRestEffectiveNumber(biddingOfferOtherList.get(0).getRestEffectiveNumber());
                boolean flag = this.isUpdateOfferPrice(biddingOffer);
                this.updateBiddingOffer(biddingOfferOtherList, supCompany, supUser, "device", handleType, biddingType, currentDate);
                if ("send".equals(handleType)) {
                    if (flag) {
                        this.updatebiddingOfferRestEffectiveNumber(biddingOfferOtherList.get(0), "device", supCompany, supUser, currentDate);
                    } else {
                        throw new CommonException("\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4fdd\u5b58\u5931\u8d25", "finish_status", "\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u4ef7\uff01");
                    }
                }
            }
            if ("2".equals(biddingType) && "send".equals(handleType)) {
                this.updateCurrentOnlineRanking(biddingCurrentRound, biddingNo, supCompany, supUser, currentDate, biddingContent.getBidFirstItem(), biddingSupplierParm);
            }
        }
    }

    private void updateBiddingOfferMatter(List<BiddingOffer> BiddingOfferList, Company supCompany, User supUser, String handleType, String biddingType, Date currentDate) throws InstantiationException, IllegalAccessException {
        for (BiddingOffer biddingOfferMatter : BiddingOfferList) {
            BiddingOffer offer = new BiddingOffer();
            offer.setId(biddingOfferMatter.getId());
            offer.setPromiseReducedRate(biddingOfferMatter.getPromiseReducedRate());
            if ("save".equals(handleType)) {
                offer.setTempOfferUnitPrice(biddingOfferMatter.getTempOfferUnitPrice());
                offer.setTempOfferSetPrice(biddingOfferMatter.getTempOfferSetPrice());
                offer.setOfferType(0);
            } else if ("send".equals(handleType)) {
                offer.setTempOfferUnitPrice(biddingOfferMatter.getTempOfferUnitPrice());
                offer.setTempOfferSetPrice(biddingOfferMatter.getTempOfferSetPrice());
                offer.setOfferUnitPrice(biddingOfferMatter.getOfferUnitPrice());
                offer.setOfferSetPrice(biddingOfferMatter.getOfferSetPrice());
                offer.setOfferType(1);
            }
            offer.setFactBarnd(biddingOfferMatter.getFactBarnd());
            offer.setFactSpec(biddingOfferMatter.getFactSpec());
            offer.setFactModel(biddingOfferMatter.getFactModel());
            offer.setOfferPriceUpdateUser(supUser.getNickName());
            offer.setOfferPriceUpdateTime(currentDate);
            offer.setLastUpdateUser(supUser.getNickName());
            offer.setLastUpdateTime(currentDate);
            offer.setCurrentRate(biddingOfferMatter.getCurrentRate());
            offer.setCurrency(biddingOfferMatter.getCurrency());
            this.biddingOfferMapper.updateByPrimaryKeySelective(offer);
            List<BiddingMatterStepSup> biddingMatterStepSupList = biddingOfferMatter.getBiddingMatterStepSupList();
            if (CollectionUtils.isNotEmpty(biddingMatterStepSupList)) {
                for (BiddingMatterStepSup biddingMatterStepSup : biddingMatterStepSupList) {
                    BiddingMatterStepSup mstepsup = new BiddingMatterStepSup();
                    mstepsup.setId(biddingMatterStepSup.getId());
                    mstepsup.setOfferUnitPrice(biddingMatterStepSup.getOfferUnitPrice());
                    mstepsup.setOfferSetPrice(biddingMatterStepSup.getOfferSetPrice());
                    mstepsup.setLastUpdateUser(supUser.getNickName());
                    mstepsup.setLastUpdateTime(currentDate);
                    this.biddingMatterStepSupService.modifyObj(mstepsup);
                }
            }
            if ("send".equals(handleType) && !"2".equals(biddingType)) {
                this.updateCurrentRanking(biddingOfferMatter, "material");
            }
            if (!StringUtils.isNotBlank((String)biddingOfferMatter.getCostAnalysisId())) continue;
            this.updateMaterialAcostAnalysis(biddingOfferMatter);
        }
    }

    private void updateMaterialAcostAnalysis(BiddingOffer biddingOfferMatter) throws InstantiationException, IllegalAccessException {
        TplOrderItemDetail tpl = (TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId());
        IOrderItemDetailService service = tpl.getOrderItemDetailService();
        ArrayList<String> orderItemIdList = new ArrayList<String>();
        orderItemIdList.add(biddingOfferMatter.getId());
        service.deleteByOrderItemIds(orderItemIdList);
        ArrayList<IOrderItemDetail> detailList = new ArrayList<IOrderItemDetail>();
        IOrderItemDetail detail = biddingOfferMatter.getOrderItemDetail();
        detail.setOrderItemId(biddingOfferMatter.getId());
        detail.setTemplateId(biddingOfferMatter.getCostAnalysisId());
        detail.setMaterialCode(biddingOfferMatter.getProjectNo() == null ? "" : biddingOfferMatter.getProjectNo());
        detail.setMaterialDesc(biddingOfferMatter.getProjectDesc() == null ? "" : biddingOfferMatter.getProjectDesc());
        detailList.add(detail);
        service.addAll(detailList);
    }

    private void updateMouldAcostAnalysis(BiddingOffer biddingOfferMatter) {
        IMouldDetailService service = ((TplMouldDetail)this.tplMouldDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId())).getMouldDetailService();
        ArrayList<String> orderItemIdList = new ArrayList<String>();
        orderItemIdList.add(biddingOfferMatter.getId());
        service.deleteByMouldIdList(orderItemIdList);
        ArrayList<IMouldDetail> mouldDetailList = new ArrayList<IMouldDetail>();
        IMouldDetail mouldDetail = biddingOfferMatter.getMouldDetail();
        mouldDetail.setMouldId(biddingOfferMatter.getId());
        mouldDetail.setTemplateId(biddingOfferMatter.getCostAnalysisId());
        mouldDetail.setSupCompanyId(biddingOfferMatter.getSupCompanyId());
        mouldDetail.setSupCompanyName(biddingOfferMatter.getSupCompanyName());
        mouldDetail.setSupCompanySapCode(biddingOfferMatter.getSupCompanySapCode() == null ? "" : biddingOfferMatter.getSupCompanySapCode());
        mouldDetail.setSupCompanySrmCode(biddingOfferMatter.getSupCompanySrmCode() == null ? "" : biddingOfferMatter.getSupCompanySrmCode());
        mouldDetail.setPurOrderId(biddingOfferMatter.getBiddingNo());
        mouldDetail.setSupOrderId(biddingOfferMatter.getBiddingNo());
        mouldDetail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(mouldDetail));
        mouldDetailList.add(mouldDetail);
        service.addAll(mouldDetailList);
    }

    private void updateCurrentRanking(BiddingOffer BiddingOffer2, String requirementTypeCode) {
        BiddingOfferExample matterExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria matterCriteria = matterExample.createCriteria();
        matterCriteria.andBiddingNoEqualTo(BiddingOffer2.getBiddingNo());
        switch (requirementTypeCode) {
            case "material": {
                matterCriteria.andMatterIdEqualTo(BiddingOffer2.getMatterId());
                break;
            }
            case "die": {
                matterCriteria.andModelIdEqualTo(BiddingOffer2.getModelId());
                break;
            }
            case "device": {
                matterCriteria.andOtherIdEqualTo(BiddingOffer2.getOtherId());
            }
        }
        matterCriteria.andBiddingRoundsNumberEqualTo(BiddingOffer2.getBiddingRoundsNumber());
        matterCriteria.andRequirementTypeCodeEqualTo(requirementTypeCode);
        matterCriteria.andOfferUnitPriceGreaterThan("0");
        List<BiddingOffer> biddingOfferMatterList = this.biddingOfferMapper.selectByExample(matterExample);
        Collections.sort(biddingOfferMatterList, new Comparator<BiddingOffer>(){

            @Override
            public int compare(BiddingOffer o1, BiddingOffer o2) {
                return new BigDecimal(o1.getOfferUnitPrice() == null ? "0" : o1.getOfferUnitPrice()).compareTo(new BigDecimal(o2.getOfferUnitPrice() == null ? "0" : o2.getOfferUnitPrice()));
            }
        });
        int index = 1;
        int tamp = 0;
        HashSet<String> set = new HashSet<String>();
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferMatterList) && j < biddingOfferMatterList.size(); ++j) {
            BiddingOffer offerSort = new BiddingOffer();
            offerSort.setId(biddingOfferMatterList.get(j).getId());
            if (set.add(biddingOfferMatterList.get(j).getOfferUnitPrice())) {
                offerSort.setCurrentRanking(String.valueOf(index));
                tamp = index++;
            } else {
                offerSort.setCurrentRanking(String.valueOf(tamp));
            }
            this.biddingOfferMapper.updateByPrimaryKeySelective(offerSort);
        }
    }

    private void updateCurrentOnlineRanking(String biddingCurrentRound, String biddingNo, Company supCompany, User supUser, Date currentDate, final String bidFirstItem, BiddingSupplier biddingSupplierParm) {
        BiddingOfferExample example = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = example.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo);
        criteria.andSupCompanyIdEqualTo(supCompany.getId());
        criteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);
        List<BiddingOffer> biddingOfferMatterList = this.biddingOfferMapper.selectByExample(example);
        Double materialUntaxTotal = 0.0;
        Double materialTaxTotal = 0.0;
        Double materialGoalUntaxTotal = 0.0;
        Double dieUntaxTotal = 0.0;
        Double dieTaxTotal = 0.0;
        Double dieGoalUntaxTotal = 0.0;
        Double materialGoalUntaxTotalHis = 0.0;
        Double dieGoalUntaxTotalHis = 0.0;
        int offerTime = 0;
        int offerType = 0;
        for (BiddingOffer f : biddingOfferMatterList) {
            Double offerUnitPrice = 0.0;
            if (StringUtils.isNotBlank((String)f.getOfferUnitPrice())) {
                offerUnitPrice = Double.parseDouble(f.getOfferUnitPrice()) == 0.0 ? 0.0 : Double.parseDouble(f.getOfferUnitPrice());
            }
            Double unitPrice = 0.0;
            if (f.getUnitPrice() != null) {
                unitPrice = Double.parseDouble(f.getUnitPrice().toString()) == 0.0 ? 0.0 : Double.parseDouble(f.getUnitPrice().toString());
            }
            Long biddingQuantity = 1L;
            if (f.getBiddingQuantity() != null) {
                biddingQuantity = Long.valueOf(f.getBiddingQuantity()) == 0L ? 1L : Long.valueOf(f.getBiddingQuantity());
            }
            Double historyPurchaseQty = 0.0;
            if (StringUtils.isNotBlank((String)f.getHistoryPurchaseQty())) {
                historyPurchaseQty = Double.parseDouble(f.getHistoryPurchaseQty()) == 0.0 ? 0.0 : Double.parseDouble(f.getHistoryPurchaseQty());
            }
            Double currentRate = 0.0;
            String currentRateStr = "";
            if (StringUtils.isNotBlank((String)f.getCurrentRate())) {
                currentRateStr = f.getCurrentRate().replace("%", "");
                currentRate = Double.parseDouble(currentRateStr) == 0.0 ? 0.0 : Double.parseDouble(currentRateStr) / 100.0;
            }
            if ("material".equals(f.getRequirementTypeCode())) {
                materialUntaxTotal = materialUntaxTotal + offerUnitPrice * (double)biddingQuantity.longValue();
                materialTaxTotal = materialTaxTotal + offerUnitPrice * (double)biddingQuantity.longValue() * (1.0 + currentRate);
                materialGoalUntaxTotal = materialGoalUntaxTotal + unitPrice * (double)biddingQuantity.longValue();
                materialGoalUntaxTotalHis = materialGoalUntaxTotalHis + offerUnitPrice * historyPurchaseQty;
            } else if ("die".equals(f.getRequirementTypeCode())) {
                dieUntaxTotal = dieUntaxTotal + offerUnitPrice * (double)biddingQuantity.longValue();
                dieTaxTotal = dieTaxTotal + offerUnitPrice * (double)biddingQuantity.longValue() * (1.0 + currentRate);
                dieGoalUntaxTotal = dieGoalUntaxTotal + unitPrice * (double)biddingQuantity.longValue();
                dieGoalUntaxTotalHis = dieGoalUntaxTotalHis + offerUnitPrice * historyPurchaseQty;
            }
            offerTime = f.getOfferTime();
            offerType = f.getOfferType();
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        BiddingSupplier biddingSupplier = new BiddingSupplier();
        biddingSupplier.setMaterialUntaxTotal(nf.format(materialUntaxTotal));
        biddingSupplier.setMaterialTaxTotal(nf.format(materialTaxTotal));
        biddingSupplier.setMaterialGoalUntaxTotal(nf.format(materialGoalUntaxTotal));
        biddingSupplier.setDieUntaxTotal(nf.format(dieUntaxTotal));
        biddingSupplier.setDieTaxTotal(nf.format(dieTaxTotal));
        biddingSupplier.setDieGoalUntaxTotal(nf.format(dieGoalUntaxTotal));
        biddingSupplier.setMaterialGoalUntaxTotalHis(nf.format(materialGoalUntaxTotalHis));
        biddingSupplier.setDieGoalUntaxTotalHis(nf.format(dieGoalUntaxTotalHis));
        biddingSupplier.setOfferPriceUpdateTime(currentDate);
        biddingSupplier.setOfferTime(offerTime);
        biddingSupplier.setOfferType(offerType);
        if (biddingSupplierParm != null) {
            biddingSupplier.setLastUpdateTime(currentDate);
            biddingSupplier.setLastUpdateUser(supUser.getNickName());
            biddingSupplier.setRateValue(biddingSupplier.getRateValue());
            biddingSupplier.setLastUpdateUser(supUser.getNickName());
            biddingSupplier.setRateValue(biddingSupplier.getRateValue());
            biddingSupplier.setCurrency(biddingSupplier.getCurrency());
            biddingSupplier.setRemark(biddingSupplier.getRemark());
        }
        BiddingSupplierExample supExample = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria biddingCriteria = supExample.createCriteria();
        biddingCriteria.andBiddingNoEqualTo(biddingNo);
        biddingCriteria.andSupCompanyIdEqualTo(supCompany.getId());
        this.biddingSupplierService.modifyObjSup(biddingSupplier, supExample);
        BiddingSupplierExample exampleAll = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria biddingCriteriAll = exampleAll.createCriteria();
        biddingCriteriAll.andBiddingNoEqualTo(biddingNo);
        biddingCriteriAll.andSupBiddingEqualTo("1");
        List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample(exampleAll);
        Collections.sort(biddingSupplierList, new Comparator<BiddingSupplier>(){

            @Override
            public int compare(BiddingSupplier o1, BiddingSupplier o2) {
                if ("0".equals(bidFirstItem)) {
                    if (StringUtils.isBlank((String)o1.getMaterialUntaxTotal())) {
                        return 1;
                    }
                    if (StringUtils.isBlank((String)o2.getMaterialUntaxTotal())) {
                        return -1;
                    }
                    if (o1.getLastUpdateTime() == null) {
                        return 1;
                    }
                    if (o2.getLastUpdateTime() == null) {
                        return -1;
                    }
                    if (o1.getMaterialUntaxTotal().equals(o2.getMaterialUntaxTotal())) {
                        return o1.getOfferPriceUpdateTime().compareTo(o2.getOfferPriceUpdateTime());
                    }
                    return new BigDecimal(o1.getMaterialUntaxTotal()).compareTo(new BigDecimal(o2.getMaterialUntaxTotal()));
                }
                if (StringUtils.isBlank((String)o1.getDieUntaxTotal())) {
                    return 1;
                }
                if (StringUtils.isBlank((String)o2.getDieUntaxTotal())) {
                    return -1;
                }
                if (o1.getLastUpdateTime() == null) {
                    return 1;
                }
                if (o2.getLastUpdateTime() == null) {
                    return -1;
                }
                if (o1.getDieUntaxTotal().equals(o2.getDieUntaxTotal())) {
                    return o1.getOfferPriceUpdateTime().compareTo(o2.getOfferPriceUpdateTime());
                }
                return new BigDecimal(o1.getDieUntaxTotal()).compareTo(new BigDecimal(o2.getDieUntaxTotal()));
            }
        });
        int index = 1;
        for (int j = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && j < biddingSupplierList.size(); ++j) {
            BiddingSupplier supplier = new BiddingSupplier();
            supplier.setId(((BiddingSupplier)biddingSupplierList.get(j)).getId());
            supplier.setSupRank(String.valueOf(index));
            if ("0".equals(bidFirstItem)) {
                supplier.setSupScore(((BiddingSupplier)biddingSupplierList.get(j)).getMaterialUntaxTotal());
            } else {
                supplier.setSupScore(((BiddingSupplier)biddingSupplierList.get(j)).getDieUntaxTotal());
            }
            ++index;
            this.biddingSupplierService.modifyObj(supplier);
        }
        List biddingSupplierListNew = this.biddingSupplierService.queryAllObjByExample(supExample);
        for (BiddingSupplier supplier : biddingSupplierListNew) {
            BiddingSupplierHis newHis = new BiddingSupplierHis();
            BeanUtils.copyProperties((Object)supplier, (Object)newHis);
            newHis.settBaseBiddingSupplierId(supplier.getId());
            newHis.setBiddingRoundsNumber(biddingCurrentRound);
            newHis.setId(null);
            this.biddingSupplierHisService.addObj(newHis);
        }
    }

    public static void main(String[] args) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        Date today = new Date();
        System.out.println("\u4eca\u5929\u662f:" + f.format((Object)today));
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        c.add(5, 1);
        Date tomorrow = c.getTime();
        Calendar c2 = Calendar.getInstance();
        c2.setTime(today);
        c2.add(5, 2);
        Date tomorrow2 = c2.getTime();
        BiddingSupplier biddingSupplier1 = new BiddingSupplier();
        biddingSupplier1.setId("L53078");
        biddingSupplier1.setMaterialUntaxTotal("470000");
        biddingSupplier1.setMaterialGoalUntaxTotal("500000");
        biddingSupplier1.setDieUntaxTotal("75000");
        biddingSupplier1.setDieGoalUntaxTotal("77000");
        biddingSupplier1.setRateValue("0.10");
        biddingSupplier1.setLastUpdateTime(tomorrow2);
        BiddingSupplier biddingSupplier2 = new BiddingSupplier();
        biddingSupplier2.setId("L53079");
        biddingSupplier2.setMaterialUntaxTotal("460000");
        biddingSupplier2.setMaterialGoalUntaxTotal("500000");
        biddingSupplier2.setDieUntaxTotal("74900");
        biddingSupplier2.setDieGoalUntaxTotal("77000");
        biddingSupplier2.setRateValue("0.10");
        biddingSupplier2.setLastUpdateTime(tomorrow);
        BiddingSupplier biddingSupplier3 = new BiddingSupplier();
        biddingSupplier3.setId("L53080");
        biddingSupplier3.setMaterialUntaxTotal("510000");
        biddingSupplier3.setMaterialGoalUntaxTotal("500000");
        biddingSupplier3.setDieUntaxTotal("78700");
        biddingSupplier3.setDieGoalUntaxTotal("77000");
        biddingSupplier2.setRateValue("0.10");
        biddingSupplier3.setLastUpdateTime(new Date());
        List<Object> list = new ArrayList<BiddingSupplier>();
        list.add(biddingSupplier1);
        list.add(biddingSupplier2);
        list.add(biddingSupplier3);
        list = list.stream().filter(b -> Double.parseDouble(b.getMaterialUntaxTotal()) <= Double.parseDouble(b.getMaterialGoalUntaxTotal())).filter(b -> Double.parseDouble(b.getDieUntaxTotal()) >= Double.parseDouble(b.getDieGoalUntaxTotal()) - Double.parseDouble(b.getDieGoalUntaxTotal()) * Double.parseDouble(b.getRateValue())).filter(b -> Double.parseDouble(b.getDieUntaxTotal()) <= Double.parseDouble(b.getDieGoalUntaxTotal()) + Double.parseDouble(b.getDieGoalUntaxTotal()) * Double.parseDouble(b.getRateValue())).collect(Collectors.toList());
        list.forEach(e -> System.out.println("Id:" + e.getId() + "\u4ef7\u683c\uff1a" + e.getMaterialUntaxTotal() + ", Name: " + e.getLastUpdateTime()));
    }

    private void updateBiddingOffer(List<BiddingOffer> BiddingOfferList, Company supCompany, User supUser, String requirementTypeCode, String handleType, String biddingType, Date currentDate) {
        for (BiddingOffer biddingOffer : BiddingOfferList) {
            BiddingOffer offer = new BiddingOffer();
            offer.setId(biddingOffer.getId());
            if ("save".equals(handleType)) {
                offer.setTempOfferUnitPrice(biddingOffer.getTempOfferUnitPrice());
                offer.setTempOfferSetPrice(biddingOffer.getTempOfferSetPrice());
                offer.setOfferType(0);
            } else if ("send".equals(handleType)) {
                offer.setOfferUnitPrice(biddingOffer.getOfferUnitPrice());
                offer.setOfferSetPrice(biddingOffer.getOfferSetPrice());
                offer.setTempOfferUnitPrice(biddingOffer.getTempOfferUnitPrice());
                offer.setTempOfferSetPrice(biddingOffer.getTempOfferSetPrice());
                offer.setOfferType(1);
                offer.setOfferPriceUpdateTime(currentDate);
                offer.setOfferPriceUpdateUser(supUser.getNickName());
            }
            offer.setLastUpdateUser(supUser.getNickName());
            offer.setLastUpdateTime(currentDate);
            offer.setCurrentRate(biddingOffer.getCurrentRate());
            offer.setCurrency(biddingOffer.getCurrency());
            this.biddingOfferMapper.updateByPrimaryKeySelective(offer);
            if ("send".equals(handleType) && !"2".equals(biddingType)) {
                this.updateCurrentRanking(biddingOffer, requirementTypeCode);
            }
            if (!"die".equals(requirementTypeCode) || !StringUtils.isNotBlank((String)biddingOffer.getCostAnalysisId())) continue;
            this.updateMouldAcostAnalysis(biddingOffer);
        }
    }

    @Override
    public List<BiddingOffer> findBidInfo(String biddingNo, String type, String isBidding, String currentRound, String biddingType, final String bidFirstItem, String bidSecondItemPriceGap, String companyId) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.setOrderByClause(" OFFER_TIME DESC,OFFER_PRICE_UPDATE_TIME DESC,SUP_COMPANY_SRM_CODE DESC,PROJECT_DESC DESC,MATERIAL_DEVEL ASC ");
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type).andBiddingRoundsNumberEqualTo(currentRound);
        if (StringUtils.isNotBlank((String)isBidding)) {
            criteria.andIsBiddingEqualTo(isBidding);
        }
        if (StringUtils.isNotBlank((String)companyId)) {
            criteria.andSupCompanyIdEqualTo(companyId);
        }
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        if ("2".equals(biddingType)) {
            BiddingSupplierExample exampleAll = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria biddingCriteriAll = exampleAll.createCriteria();
            biddingCriteriAll.andBiddingNoEqualTo(biddingNo);
            biddingCriteriAll.andSupBiddingEqualTo("1");
            List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample(exampleAll);
            Double secondItemPriceGap = StringUtils.isBlank((String)bidSecondItemPriceGap) ? 0.0 : Double.parseDouble(bidSecondItemPriceGap) / 100.0;
            List<Object> newSupplierList = new ArrayList();
            newSupplierList = "0".equals(bidFirstItem) ? (StringUtils.isBlank((String)bidSecondItemPriceGap) ? biddingSupplierList.stream().filter(b -> Double.parseDouble(b.getMaterialUntaxTotal()) <= Double.parseDouble(b.getMaterialGoalUntaxTotal())).collect(Collectors.toList()) : biddingSupplierList.stream().filter(b -> Double.parseDouble(b.getMaterialUntaxTotal()) <= Double.parseDouble(b.getMaterialGoalUntaxTotal())).filter(b -> Double.parseDouble(b.getDieUntaxTotal()) <= Double.parseDouble(b.getDieGoalUntaxTotal()) + Double.parseDouble(b.getDieGoalUntaxTotal()) * secondItemPriceGap).collect(Collectors.toList())) : (StringUtils.isBlank((String)bidSecondItemPriceGap) ? biddingSupplierList.stream().filter(b -> Double.parseDouble(b.getDieUntaxTotal()) <= Double.parseDouble(b.getDieGoalUntaxTotal())).collect(Collectors.toList()) : biddingSupplierList.stream().filter(b -> Double.parseDouble(b.getDieUntaxTotal()) <= Double.parseDouble(b.getDieGoalUntaxTotal())).filter(b -> Double.parseDouble(b.getMaterialUntaxTotal()) <= Double.parseDouble(b.getMaterialGoalUntaxTotal()) + Double.parseDouble(b.getMaterialGoalUntaxTotal()) * secondItemPriceGap).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(newSupplierList)) {
                Collections.sort(newSupplierList, new Comparator<BiddingSupplier>(){

                    @Override
                    public int compare(BiddingSupplier o1, BiddingSupplier o2) {
                        if ("0".equals(bidFirstItem)) {
                            if (StringUtils.isBlank((String)o1.getMaterialUntaxTotal())) {
                                return 1;
                            }
                            if (StringUtils.isBlank((String)o2.getMaterialUntaxTotal())) {
                                return -1;
                            }
                            if (o1.getLastUpdateTime() == null) {
                                return 1;
                            }
                            if (o2.getLastUpdateTime() == null) {
                                return -1;
                            }
                            if (o1.getMaterialUntaxTotal().equals(o2.getMaterialUntaxTotal())) {
                                return o1.getOfferPriceUpdateTime().compareTo(o2.getOfferPriceUpdateTime());
                            }
                            return new BigDecimal(o1.getMaterialUntaxTotal()).compareTo(new BigDecimal(o2.getMaterialUntaxTotal()));
                        }
                        if (StringUtils.isBlank((String)o1.getDieUntaxTotal())) {
                            return 1;
                        }
                        if (StringUtils.isBlank((String)o2.getDieUntaxTotal())) {
                            return -1;
                        }
                        if (o1.getLastUpdateTime() == null) {
                            return 1;
                        }
                        if (o2.getLastUpdateTime() == null) {
                            return -1;
                        }
                        if (o1.getDieUntaxTotal().equals(o2.getDieUntaxTotal())) {
                            return o1.getOfferPriceUpdateTime().compareTo(o2.getOfferPriceUpdateTime());
                        }
                        return new BigDecimal(o1.getDieUntaxTotal()).compareTo(new BigDecimal(o2.getDieUntaxTotal()));
                    }
                });
                for (BiddingOffer offer : biddingOfferList) {
                    if (!offer.getSupCompanyId().equals(((BiddingSupplier)newSupplierList.get(0)).getSupCompanyId())) continue;
                    offer.setIsGroomMaterial("1");
                }
            }
        } else {
            List<String> stringsCodeList = this.getStringsCode(biddingNo, type);
            for (int i = 0; CollectionUtils.isNotEmpty(stringsCodeList) && i < stringsCodeList.size(); ++i) {
                ArrayList<BiddingOffer> sameProjectNoList = new ArrayList<BiddingOffer>();
                block12: for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); ++j) {
                    BiddingOffer biddingOffer = biddingOfferList.get(j);
                    if (type.equals("material")) {
                        Object example = new BiddingMatterStepSupExample();
                        ((BiddingMatterStepSupExample)example).createCriteria().andBiddingOfferIdEqualTo(biddingOffer.getId()).andBiddingRoundsNumberEqualTo(currentRound);
                        ((BiddingMatterStepSupExample)example).setOrderByClause(" QUANTITY_START ASC");
                        List<BiddingMatterStepSup> biddingMatterStepSups = this.biddingMatterStepSupService.queryAllObjByExample(example);
                        biddingOffer.setBiddingMatterStepSupList(biddingMatterStepSups);
                        BigDecimal offerUnitPrice = biddingOffer.getOfferUnitPrice() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getOfferUnitPrice());
                        BigDecimal biddingQuantity = biddingOffer.getBiddingQuantity() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getBiddingQuantity());
                        biddingOffer.setSupplierQuotedPrice(offerUnitPrice.multiply(biddingQuantity));
                    }
                    switch (type) {
                        case "material": {
                            if (!stringsCodeList.get(i).equals(biddingOffer.getMatterId())) continue block12;
                            sameProjectNoList.add(biddingOffer);
                            continue block12;
                        }
                        case "die": {
                            if (!stringsCodeList.get(i).equals(biddingOffer.getModelId())) continue block12;
                            sameProjectNoList.add(biddingOffer);
                            continue block12;
                        }
                        case "device": {
                            if (!stringsCodeList.get(i).equals(biddingOffer.getOtherId())) continue block12;
                            sameProjectNoList.add(biddingOffer);
                        }
                    }
                }
                ArrayList<String> maxDevelList = new ArrayList<String>();
                ArrayList<BiddingOffer> maxDevelOffers = new ArrayList<BiddingOffer>();
                for (BiddingOffer biddingOffer : sameProjectNoList) {
                    if (StringUtils.isNotBlank((String)((BiddingOffer)sameProjectNoList.get(0)).getMaterialDevel()) && !((BiddingOffer)sameProjectNoList.get(0)).getMaterialDevel().equals(biddingOffer.getMaterialDevel())) continue;
                    maxDevelList.add(biddingOffer.getId());
                    maxDevelOffers.add(biddingOffer);
                }
                if (CollectionUtils.isNotEmpty(maxDevelList) && maxDevelList.size() == 1) {
                    for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); ++j) {
                        BiddingOffer biddingOffer = biddingOfferList.get(j);
                        if (!biddingOffer.getId().equals(maxDevelList.get(0))) continue;
                        biddingOffer.setIsGroomMaterial("1");
                        break;
                    }
                }
                if (!CollectionUtils.isEmpty(maxDevelList) && maxDevelList.size() <= 1) continue;
                ArrayList<BiddingOffer> reducedRateOffers = new ArrayList<BiddingOffer>();
                if (CollectionUtils.isEmpty(maxDevelList)) {
                    reducedRateOffers.addAll(sameProjectNoList);
                } else {
                    reducedRateOffers.addAll(maxDevelOffers);
                }
                ArrayList<Company> reducedRateList = new ArrayList<Company>();
                for (BiddingOffer offer : reducedRateOffers) {
                    Iterator<BiddingOffer> company = (Company)this.companyService.queryObjById(offer.getSupCompanyId());
                    reducedRateList.add((Company)((Object)company));
                }
                Collections.sort(reducedRateList, new Comparator<Company>(){

                    @Override
                    public int compare(Company o1, Company o2) {
                        return new BigDecimal(o2.getReducedRate() == null ? "0" : o2.getReducedRate()).compareTo(new BigDecimal(o1.getReducedRate() == null ? "0" : o1.getReducedRate()));
                    }
                });
                ArrayList<String> maxIdList = new ArrayList<String>();
                ArrayList<BiddingOffer> maxReducedRateOffers = new ArrayList<BiddingOffer>();
                for (Company company : reducedRateList) {
                    if (!StringUtils.isNotBlank((String)((Company)reducedRateList.get(0)).getReducedRate()) || !((Company)reducedRateList.get(0)).getReducedRate().equals(company.getReducedRate())) continue;
                    maxIdList.add(company.getId());
                }
                if (CollectionUtils.isNotEmpty(maxIdList)) {
                    for (BiddingOffer offer : biddingOfferList) {
                        if (maxIdList.size() == 1 && maxIdList.contains(offer.getSupCompanyId())) {
                            offer.setIsGroomMaterial("1");
                            maxReducedRateOffers.add(offer);
                        }
                        if (maxIdList.size() <= 1 || !maxIdList.contains(offer.getSupCompanyId())) continue;
                        maxReducedRateOffers.add(offer);
                    }
                }
                if (!CollectionUtils.isEmpty(maxIdList) && maxIdList.size() <= 1) continue;
                ArrayList<BiddingOffer> priceOffers = new ArrayList<BiddingOffer>();
                if (CollectionUtils.isEmpty(maxIdList)) {
                    priceOffers.addAll(sameProjectNoList);
                } else {
                    priceOffers.addAll(maxReducedRateOffers);
                }
                Collections.sort(priceOffers, new Comparator<BiddingOffer>(){

                    @Override
                    public int compare(BiddingOffer o1, BiddingOffer o2) {
                        if (StringUtils.isBlank((String)o1.getOfferUnitPrice())) {
                            return 1;
                        }
                        if (StringUtils.isBlank((String)o2.getOfferUnitPrice())) {
                            return -1;
                        }
                        return new BigDecimal(o1.getOfferUnitPrice()).compareTo(new BigDecimal(o2.getOfferUnitPrice()));
                    }
                });
                ArrayList<String> biddingPriceOffers = new ArrayList<String>();
                for (BiddingOffer offer : sameProjectNoList) {
                    if (StringUtils.isBlank((String)offer.getOfferUnitPrice()) || ((BiddingOffer)priceOffers.get(0)).getOfferUnitPrice().compareTo(offer.getOfferUnitPrice()) != 0) continue;
                    biddingPriceOffers.add(offer.getId());
                }
                if (!CollectionUtils.isNotEmpty(biddingPriceOffers)) continue;
                for (BiddingOffer offer : biddingOfferList) {
                    if (!biddingPriceOffers.contains(offer.getId())) continue;
                    offer.setIsGroomMaterial("1");
                }
            }
        }
        for (BiddingOffer offer : biddingOfferList) {
            BaseService service;
            if (!StringUtils.isNotBlank((String)offer.getCostAnalysisId())) continue;
            if (type.equals("material")) {
                service = ((TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById(offer.getCostAnalysisId())).getOrderItemDetailService();
                offer.setOrderItemDetail(service.queryObjByOrderItemId(offer.getId()));
                continue;
            }
            if (!type.equals("die")) continue;
            service = ((TplMouldDetail)this.tplMouldDetailService.queryObjById(offer.getCostAnalysisId())).getMouldDetailService();
            offer.setMouldDetail(service.queryByMouldId(offer.getId()));
        }
        return biddingOfferList;
    }

    @Override
    public List<BiddingOffer> findBidInfoSup(String biddingNo, String type, String isBidding, String currentRound, User user, Company company) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.setOrderByClause(" SUP_COMPANY_SRM_CODE DESC,PROJECT_DESC DESC,MATERIAL_DEVEL ASC ");
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type).andBiddingRoundsNumberEqualTo(currentRound).andSupCompanyIdEqualTo(company.getId());
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); ++j) {
            BiddingOffer biddingOffer = biddingOfferList.get(j);
            if (type.equals(type)) {
                BiddingMatterStepSupExample example = new BiddingMatterStepSupExample();
                example.createCriteria().andBiddingOfferIdEqualTo(biddingOffer.getId()).andBiddingRoundsNumberEqualTo(currentRound).andSupCompanyIdEqualTo(company.getId());
                List<BiddingMatterStepSup> biddingMatterStepSups = this.biddingMatterStepSupService.queryAllObjByExample(example);
                biddingOffer.setBiddingMatterStepSupList(biddingMatterStepSups);
                BigDecimal offerUnitPrice = biddingOffer.getOfferUnitPrice() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getOfferUnitPrice());
                BigDecimal quantity = biddingOffer.getQuantity() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getQuantity());
                biddingOffer.setOfferSetPrice(offerUnitPrice.multiply(quantity).toString());
            }
            BiddingHeaderExample headerExample = new BiddingHeaderExample();
            headerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
            List biddingHeaders = this.biddingHeaderService.queryAllObjByExample(headerExample);
            String biddingSendBidder = ((BiddingHeader)biddingHeaders.get(0)).getBiddingSendBidder();
            if ("0".equals(biddingSendBidder)) {
                biddingOffer.setUnitPrice(BigDecimal.valueOf(-1L));
                biddingOffer.setAmount(BigDecimal.valueOf(-1L));
                continue;
            }
            if (!"1".equals(biddingSendBidder) || !"0".equals(biddingOffer.getIsBidding())) continue;
            biddingOffer.setUnitPrice(BigDecimal.valueOf(-1L));
            biddingOffer.setAmount(BigDecimal.valueOf(-1L));
        }
        return biddingOfferList;
    }

    @Override
    public List<BiddingOffer> findBidInfoSupReview(String biddingNo, String type, String isBidding, String currentRound, User user, Company company) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.setOrderByClause(" SUP_COMPANY_SRM_CODE DESC,PROJECT_DESC DESC,MATERIAL_DEVEL ASC ");
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type).andBiddingRoundsNumberEqualTo(currentRound).andSupCompanyIdEqualTo(company.getId());
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); ++j) {
            BiddingOffer biddingOffer = biddingOfferList.get(j);
            if (!type.equals(type)) continue;
            BiddingMatterStepSupExample example = new BiddingMatterStepSupExample();
            example.createCriteria().andBiddingOfferIdEqualTo(biddingOffer.getId()).andBiddingRoundsNumberEqualTo(currentRound).andSupCompanyIdEqualTo(company.getId());
            List<BiddingMatterStepSup> biddingMatterStepSups = this.biddingMatterStepSupService.queryAllObjByExample(example);
            biddingOffer.setBiddingMatterStepSupList(biddingMatterStepSups);
            BigDecimal offerUnitPrice = biddingOffer.getOfferUnitPrice() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getOfferUnitPrice());
            BigDecimal quantity = biddingOffer.getQuantity() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getQuantity());
            biddingOffer.setOfferSetPrice(offerUnitPrice.multiply(quantity).toString());
        }
        return biddingOfferList;
    }

    private List<String> getStringsCode(String biddingNo, String type) {
        ArrayList<String> stringsCode = new ArrayList<String>();
        switch (type) {
            case "material": {
                BiddingContentMatterExample contentMatterExample = new BiddingContentMatterExample();
                contentMatterExample.createCriteria().andBiddingNoEqualTo(biddingNo);
                List biddingContentMatters = this.biddingContentMatterService.queryAllObjByExample(contentMatterExample);
                for (int j = 0; CollectionUtils.isNotEmpty(biddingContentMatters) && j < biddingContentMatters.size(); ++j) {
                    stringsCode.add(((BiddingContentMatter)biddingContentMatters.get(j)).getId());
                }
                break;
            }
            case "die": {
                BiddingContentModelExample contentModelExample = new BiddingContentModelExample();
                contentModelExample.createCriteria().andBiddingNoEqualTo(biddingNo);
                List biddingContentModels = this.biddingContentModelService.queryAllObjByExample(contentModelExample);
                for (int j = 0; CollectionUtils.isNotEmpty(biddingContentModels) && j < biddingContentModels.size(); ++j) {
                    stringsCode.add(((BiddingContentModel)biddingContentModels.get(j)).getId());
                }
                break;
            }
            case "device": {
                BiddingContentOtherExample contentOtherExample = new BiddingContentOtherExample();
                contentOtherExample.createCriteria().andBiddingNoEqualTo(biddingNo);
                List biddingContentOthers = this.biddingContentOtherService.queryAllObjByExample(contentOtherExample);
                for (int j = 0; CollectionUtils.isNotEmpty(biddingContentOthers) && j < biddingContentOthers.size(); ++j) {
                    stringsCode.add(((BiddingContentOther)biddingContentOthers.get(j)).getId());
                }
                break;
            }
        }
        return stringsCode;
    }

    @Override
    public void save(SaveBidInfoVo saveBidInfoVo, String saveOrSubmit, User user) {
        boolean boo;
        List<BiddingOffer> biddingOfferList = saveBidInfoVo.getBiddingOfferList();
        List<TemporaryCodeReducedRate> codeReducedRates = saveBidInfoVo.getCodeReducedRates();
        if (CollectionUtils.isEmpty(biddingOfferList)) {
            throw new CommonException("\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u53ef\u64cd\u4f5c", "isNull", "\u6570\u636e");
        }
        for (int j = 0; j < biddingOfferList.size(); ++j) {
            BiddingOffer biddingOffer = biddingOfferList.get(j);
            if (biddingOfferList.get(0).getAllBidding().equals("0")) {
                if (CollectionUtils.isEmpty(codeReducedRates)) {
                    throw new CommonException("\u5168\u90e8\u6295\u6807\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e\u4e2d\u6807\u4f9b\u5e94\u5546", "most_set_bid_supplier");
                }
                biddingOffer.setBidShare("0");
                biddingOffer.setIsBidding("0");
                for (TemporaryCodeReducedRate temporaryCodeReducedRate : codeReducedRates) {
                    if (!temporaryCodeReducedRate.getTemporaryCode().equals(biddingOffer.getSupplierTemporaryCode())) continue;
                    biddingOffer.setBidShare(temporaryCodeReducedRate.getReducedRate());
                    biddingOffer.setIsBidding("1");
                }
            }
            if (StringUtils.isNotBlank((String)saveOrSubmit) && saveOrSubmit.equals("submit")) {
                biddingOffer.setIsSubmitBid("1");
            }
            biddingOffer.setLastUpdateUser(user.getNickName());
            biddingOffer.setLastUpdateTime(new Date());
            this.biddingOfferMapper.updateByPrimaryKeySelective(biddingOffer);
        }
        BiddingContent biddingContent = saveBidInfoVo.getBiddingContent();
        if (biddingContent != null) {
            BiddingContent bidContent = new BiddingContent();
            bidContent.setId(biddingContent.getId());
            bidContent.setBidExplain(biddingContent.getBidExplain());
            this.biddingContentService.modifyObj(bidContent);
        }
        if (StringUtils.isNotBlank((String)saveOrSubmit) && saveOrSubmit.equals("submit") && (boo = this.isAllSetBidSupplier(biddingOfferList))) {
            BiddingHeaderExample headerExample = new BiddingHeaderExample();
            headerExample.createCriteria().andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo());
            List biddingHeaders = this.biddingHeaderService.queryAllObjByExample(headerExample);
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(((BiddingHeader)biddingHeaders.get(0)).getId());
            biddingHeader.setBiddingStatus(TenderStatusEumn.BIDOVER.getValue());
            biddingHeader.setBiddingAuditstatus("0");
            biddingHeader.setBidSubmitDate(new Date());
            this.biddingHeaderService.modifyObj(biddingHeader);
            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            supplierExample.createCriteria().andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo()).andSupBiddingStatusEqualTo(TenderStatusEumn.ISBID.getValue());
            supplierExample.or().andSupBiddingStatusEqualTo(TenderStatusEumn.INBID.getValue());
            List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample(supplierExample);
            for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
                BiddingSupplier biddingSupplier = new BiddingSupplier();
                biddingSupplier.setId(((BiddingSupplier)biddingSupplierList.get(i)).getId());
                biddingSupplier.setSupBiddingStatus(TenderStatusEumn.BIDOVER.getValue());
                this.biddingSupplierService.modifyObj(biddingSupplier);
            }
        }
    }

    private boolean isAllSetBidSupplier(List<BiddingOffer> biddingOfferList) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo()).andBiddingRoundsNumberEqualTo(biddingOfferList.get(0).getBiddingRoundsNumber());
        List<BiddingOffer> biddingOfferAllList = this.biddingOfferMapper.selectByExample(offerExample);
        ArrayList<String> biddingOfferMatterList = new ArrayList<String>();
        ArrayList<String> biddingOfferModelList = new ArrayList<String>();
        ArrayList<String> biddingOfferOtherList = new ArrayList<String>();
        ArrayList<String> booleanList = new ArrayList<String>();
        for (BiddingOffer biddingOffer : biddingOfferAllList) {
            if (biddingOffer.getRequirementTypeCode().equals("material")) {
                biddingOfferMatterList.add(biddingOffer.getIsSubmitBid());
                continue;
            }
            if (biddingOffer.getRequirementTypeCode().equals("die")) {
                biddingOfferModelList.add(biddingOffer.getIsSubmitBid());
                continue;
            }
            biddingOfferOtherList.add(biddingOffer.getIsSubmitBid());
        }
        if (CollectionUtils.isEmpty(biddingOfferMatterList) || biddingOfferMatterList.contains("1")) {
            booleanList.add("Y");
        } else {
            booleanList.add("N");
        }
        if (CollectionUtils.isEmpty(biddingOfferModelList) || biddingOfferModelList.contains("1")) {
            booleanList.add("Y");
        } else {
            booleanList.add("N");
        }
        if (CollectionUtils.isEmpty(biddingOfferOtherList) || biddingOfferOtherList.contains("1")) {
            booleanList.add("Y");
        } else {
            booleanList.add("N");
        }
        return Collections.frequency(booleanList, "Y") == booleanList.size();
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); ++j) {
            this.biddingOfferMapper.deleteByPrimaryKey(biddingOfferList.get(j).getId());
        }
    }

    @Override
    public void deleteBySupCompanyId(String biddingNo, String supCompanyId) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupCompanyIdEqualTo(supCompanyId);
        this.biddingOfferMapper.deleteByExample(offerExample);
    }

    @Override
    public List<TemporaryCodeReducedRate> findBidSupplier(String biddingNo, String type, String currentRound) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type).andBiddingRoundsNumberEqualTo(currentRound).andBidShareGreaterThan("0").andBidShareIsNotNull();
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        ArrayList<TemporaryCodeReducedRate> codeReducedRates = new ArrayList<TemporaryCodeReducedRate>();
        for (int i = 0; CollectionUtils.isNotEmpty(biddingOfferList) && i < biddingOfferList.size(); ++i) {
            TemporaryCodeReducedRate codeReducedRate = new TemporaryCodeReducedRate();
            codeReducedRate.setTemporaryCode(biddingOfferList.get(i).getSupplierTemporaryCode());
            codeReducedRate.setReducedRate(biddingOfferList.get(i).getBidShare());
            codeReducedRates.add(codeReducedRate);
        }
        TreeSet<TemporaryCodeReducedRate> personSet = new TreeSet<TemporaryCodeReducedRate>((o1, o2) -> o1.getTemporaryCode().compareTo(o2.getTemporaryCode()));
        personSet.addAll(codeReducedRates);
        return new ArrayList<TemporaryCodeReducedRate>(personSet);
    }

    @Override
    public ReportShow queryPriceReport(List<BiddingOffer> reportList) {
        ReportShow monthlyReportShow = new ReportShow();
        ArrayList<Map<String, String>> fristTitleList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> secondTitleList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> dataToTypeMapList = new ArrayList<Map<String, String>>();
        for (int i = 0; CollectionUtils.isNotEmpty(reportList) && i < reportList.size(); ++i) {
            HashMap<String, String> titleMapFristList = new HashMap<String, String>();
            titleMapFristList.put("projectType", reportList.get(i).getSupCompanySrmCode());
            titleMapFristList.put("projectTypeName", reportList.get(i).getSupCompanyName());
            fristTitleList.add(titleMapFristList);
            HashMap<String, String> titleMapSecondList = new HashMap<String, String>();
            titleMapSecondList.put("projectType", reportList.get(i).getSupCompanySrmCode());
            titleMapSecondList.put("projectCode", reportList.get(i).getSupCompanySrmCode());
            titleMapSecondList.put("projectName", reportList.get(i).getSupCompanyName());
            secondTitleList.add(titleMapSecondList);
            HashMap<String, String> mapFinalData = new HashMap<String, String>();
            mapFinalData.put("projectCode", reportList.get(i).getSupCompanySrmCode());
            mapFinalData.put("projectDesc", reportList.get(i).getProjectDesc());
            mapFinalData.put("price", reportList.get(i).getOfferUnitPrice() == null ? "" : reportList.get(i).getOfferUnitPrice().toString());
            dataToTypeMapList.add(mapFinalData);
        }
        monthlyReportShow.setFristTitleList(this.removalOfRepetitionList(fristTitleList, "projectType"));
        monthlyReportShow.setSecondTitleList(this.removalOfRepetitionList(secondTitleList, "projectCode"));
        TreeSet<BiddingOffer> personSet = new TreeSet<BiddingOffer>((o1, o2) -> o1.getProjectDesc().compareTo(o2.getProjectDesc()));
        personSet.addAll(reportList);
        ArrayList<BiddingOffer> finalDataList = new ArrayList<BiddingOffer>(personSet);
        for (int i = 0; CollectionUtils.isNotEmpty(finalDataList) && i < finalDataList.size(); ++i) {
            String projectDesc = ((BiddingOffer)finalDataList.get(i)).getProjectDesc();
            BiddingOffer kpiMonthReport = (BiddingOffer)finalDataList.get(i);
            kpiMonthReport.setDataToTypeMapList(this.selectPointsOfSupCompanyIdScore(projectDesc, dataToTypeMapList));
        }
        monthlyReportShow.setFinalDataList(finalDataList);
        return monthlyReportShow;
    }

    @Override
    public ReportShow queryPriceReport2(List<BiddingOffer> reportList) {
        ReportShow monthlyReportShow = new ReportShow();
        ArrayList<Map<String, String>> titles = new ArrayList<Map<String, String>>();
        StringBuffer titleBuffer = new StringBuffer();
        for (int i = 0; CollectionUtils.isNotEmpty(reportList) && i < reportList.size(); ++i) {
            HashMap<String, String> titleMap = new HashMap<String, String>();
            titleBuffer.setLength(0);
            titleBuffer.append(reportList.get(i).getSupCompanySrmCode()).append("\u3010").append(reportList.get(i).getSupCompanyName()).append("\u3011");
            titleMap.put("supCompanyId", reportList.get(i).getSupCompanyId());
            titleMap.put("supCompanySrmCode", reportList.get(i).getSupCompanySrmCode());
            titleMap.put("supplierTemporaryCode", reportList.get(i).getSupplierTemporaryCode());
            titleMap.put("supCompanyName", reportList.get(i).getSupCompanyName());
            titleMap.put("supCompanyRemark", titleBuffer.toString());
            titleMap.put("type", "\u62a5\u4ef7");
            titles.add(titleMap);
        }
        monthlyReportShow.setTitles(this.removalOfRepetitionList(titles, "supCompanyId"));
        TreeSet<BiddingOffer> personSet = new TreeSet<BiddingOffer>((o1, o2) -> o1.getProjectDesc().compareTo(o2.getProjectDesc()));
        personSet.addAll(reportList);
        ArrayList finalDataList = new ArrayList(personSet);
        ArrayList<Map<String, Object>> itemList = new ArrayList<Map<String, Object>>();
        for (int i = 0; CollectionUtils.isNotEmpty(finalDataList) && i < finalDataList.size(); ++i) {
            String projectDesc = ((BiddingOffer)finalDataList.get(i)).getProjectDesc();
            String projectNo = ((BiddingOffer)finalDataList.get(i)).getProjectNo();
            String tempMaterialNo = ((BiddingOffer)finalDataList.get(i)).getTempMaterialNo();
            HashMap<String, String> item = new HashMap<String, String>();
            for (int j = 0; CollectionUtils.isNotEmpty(reportList) && j < reportList.size(); ++j) {
                if (!projectDesc.equals(reportList.get(j).getProjectDesc())) continue;
                item.put("tempMaterialNo", tempMaterialNo);
                item.put("projectNo", projectNo);
                item.put("projectDesc", projectDesc);
                item.put(reportList.get(j).getSupCompanyId(), reportList.get(j).getOfferUnitPrice());
            }
            itemList.add(item);
        }
        monthlyReportShow.setItemList(itemList);
        return monthlyReportShow;
    }

    private List<Map<String, String>> removalOfRepetitionList(List<Map<String, String>> titleList, String string) {
        ArrayList<Map<String, String>> newList = new ArrayList<Map<String, String>>();
        for (int i = 0; CollectionUtils.isNotEmpty(titleList) && i < titleList.size(); ++i) {
            Map<String, String> oldMap = titleList.get(i);
            if (StringUtils.isBlank((String)oldMap.get(string))) continue;
            if (newList.size() > 0) {
                boolean isContain = false;
                for (int j = 0; j < newList.size(); ++j) {
                    Map newMap = (Map)newList.get(j);
                    if (!((String)newMap.get(string)).equals(oldMap.get(string))) continue;
                    for (String key : oldMap.keySet()) {
                        newMap.put(key, oldMap.get(key));
                    }
                    isContain = true;
                    break;
                }
                if (isContain) continue;
                newList.add(oldMap);
                continue;
            }
            newList.add(oldMap);
        }
        return newList;
    }

    private List<Map<String, String>> selectPointsOfSupCompanyIdScore(String projectDesc, List<Map<String, String>> dataToTypeMapList) {
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        for (int j = 0; CollectionUtils.isNotEmpty(dataToTypeMapList) && j < dataToTypeMapList.size(); ++j) {
            Map<String, String> map = dataToTypeMapList.get(j);
            if (StringUtils.isBlank((String)map.get("projectCode")) || !map.get("projectDesc").equals(projectDesc)) continue;
            maps.add(map);
        }
        return maps;
    }

    @Override
    public void ImportBiddingToSap(ImportBiddingToSapVo vo) {
        Assert.isNotNull(vo.getInformationRecord(), "\u4fe1\u606f\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(vo.getBiddingOfferIdList(), "\u4e2d\u6807\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(vo.getInformationRecord().getInformationRecordCategory(), "\u4fe1\u606f\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(vo.getInformationRecord().getConditionalType(), "\u6761\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(vo.getInformationRecord().getPurchaseOrganization(), "\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(vo.getInformationRecord().getPurchasingGroup(), "\u91c7\u8d2d\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(vo.getInformationRecord().getFactoryCode(), "\u5de5\u5382\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList biddingOfferList = new ArrayList();
        vo.getBiddingOfferIdList().stream().forEach(id -> {
            BiddingOffer biddingOffer = this.queryObjById((String)id);
            if (Constant.YES_INT.equals(biddingOffer.getIsImportSap())) {
                throw new CommonException("\u542b\u5df2\u5bfc\u5165\u5355\u636e,\u65e0\u6cd5\u5bfc\u5165");
            }
            BiddingMatterStepSupExample biddingMatterStepSupExample = new BiddingMatterStepSupExample();
            biddingMatterStepSupExample.createCriteria().andBiddingOfferIdEqualTo(biddingOffer.getId());
            List<BiddingMatterStepSup> biddingMatterStepSups = this.biddingMatterStepSupService.queryAllObjByExample(biddingMatterStepSupExample);
            if (CollectionUtils.isNotEmpty(biddingMatterStepSups)) {
                biddingOffer.setBiddingMatterStepSupList(biddingMatterStepSups);
            }
            biddingOfferList.add(biddingOffer);
        });
        biddingOfferList.stream().filter(data -> Constant.YES_INT.toString().equals(data.getIsBidding())).forEach(data -> {
            vo.getInformationRecord().setPurOrderId(data.getId());
            this.informationRecordService.addObj(vo.getInformationRecord());
            this.validOfferHis((BiddingOffer)data);
            SystemPrice sys = this.buildSystemPrice((BiddingOffer)data, vo.getInformationRecord());
            SyncBiddingService syncBiddingService = (SyncBiddingService)SpringContextHolder.getOneBean(SyncBiddingService.class);
            if (syncBiddingService == null) {
                throw new CommonException("\u7cfb\u7edf\u8fd8\u6ca1\u6709\u542f\u52a8\u4ef7\u683c\u56de\u5199\u5230sap\u7684\u914d\u7f6e");
            }
            try {
                syncBiddingService.sendBidding(sys, (BiddingOffer)data);
            }
            catch (Exception e) {
                throw new CommonException("\u4f9b\u5e94\u5546\u62a5\u4ef7\u4fe1\u606f\u53cd\u5199SAP\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:" + e.getMessage());
            }
            this.systemPriceService.addObj(sys);
            BiddingOffer biddingOffer = new BiddingOffer();
            biddingOffer.setId(data.getId());
            biddingOffer.setIsImportSap(Constant.YES_INT);
            this.modifyObj(biddingOffer);
        });
    }

    private SystemPrice buildSystemPrice(BiddingOffer data, InformationRecord infor) {
        SystemPrice sys = new SystemPrice();
        sys.setInformationRecordCategory(infor.getInformationRecordCategory());
        sys.setFactoryCode(infor.getFactoryCode());
        sys.setPurchaseOrganization(infor.getPurchaseOrganization());
        sys.setPurchasingGroup(infor.getPurchasingGroup());
        sys.setConditionalType(infor.getConditionalType());
        sys.setOrderItemId(data.getId());
        sys.setCreateTime(new Date());
        sys.setUpdateTime(new Date());
        sys.setIsEnable(Constant.YES_INT);
        sys.setUntaxedUnitPrice(new BigDecimal(data.getOfferUnitPrice()));
        sys.setCompanySapCode(data.getSupCompanySapCode());
        sys.setCurrency(data.getCurrency());
        sys.setMaterialCode(data.getProjectNo());
        sys.setPurPriceUnit(data.getUnit());
        String supMaterialCode = this.getSupMaterialCode(data.getProjectNo(), data.getSupCompanySapCode());
        if (StringUtils.isNotBlank((String)supMaterialCode)) {
            sys.setSupMaterialCode(supMaterialCode);
        }
        return sys;
    }

    private String getSupMaterialCode(String projectNo, String supCompanySapCode) {
        SupplierMaterialExample materExample = new SupplierMaterialExample();
        materExample.createCriteria().andCompanySapCodeEqualTo(supCompanySapCode).andMaterialCodeEqualTo(projectNo);
        SupplierMaterialService service = (SupplierMaterialService)SpringContextHolder.getOneBean(SupplierMaterialService.class);
        List materialList = service.queryAllObjByExample(materExample);
        if (CollectionUtils.isNotEmpty(materialList) && StringUtils.isNotBlank((String)((SupplierMaterial)materialList.get(0)).getSupplierMaterial())) {
            return ((SupplierMaterial)materialList.get(0)).getSupplierMaterial();
        }
        return null;
    }

    private void validOfferHis(BiddingOffer data) {
        Assert.isNotNull(data.getOfferUnitPrice(), "\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(data.getCurrency(), "\u5e01\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(data.getProjectDesc(), "\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(data.getProjectNo(), "\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(data.getUnit(), "\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

