/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingQuestion;
import com.els.base.bidding.entity.BiddingQuestionExample;
import com.els.base.bidding.service.BiddingQuestionService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u62db\u6295\u6807\u5728\u7ebf\u7b54\u7591")
@Controller
@RequestMapping(value={"biddingQuestion"})
public class BiddingQuestionController {
    @Resource
    protected BiddingQuestionService biddingQuestionService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6295\u6807\u5728\u7ebf\u7b54\u7591")
    @RequestMapping(value={"service/sup/createBiddingQuestion"})
    @ResponseBody
    public ResponseResult<String> createBiddingQuestion(@RequestBody BiddingQuestion question) {
        Assert.isNotNull(question, "\u95ee\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
        this.biddingQuestionService.createBiddingQuestion(question, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5728\u7ebf\u7b54\u7591\u95ee\u9898")
    @RequestMapping(value={"service/sup/deleteQuestion"})
    @ResponseBody
    public ResponseResult<String> deleteQuestion(@RequestBody List<String> ids) {
        this.biddingQuestionService.deleteQuestion(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u4f9b\u5e94\u5546\u67e5\u770b\u95ee\u9898\u8be6\u60c5")
    @RequestMapping(value={"service/sup/findDetailById"})
    @ResponseBody
    public ResponseResult<BiddingQuestion> findDetailByIdForSup(@RequestParam String id) {
        BiddingQuestion question = this.biddingQuestionService.findDetailById(id, CompanyUtils.currentCompany());
        return ResponseResult.success(question);
    }

    @ApiOperation(httpMethod="GET", value="\u4f9b\u5e94\u5546\u67e5\u770b\u7ea2\u5708\u6570\u91cf")
    @RequestMapping(value={"service/sup/countSupplierQuestionInfo"})
    @ResponseBody
    public ResponseResult<Integer> countSupplierQuestionInfo(@RequestParam String biddingNo) {
        int count = this.biddingQuestionService.countSupplierQuestionInfo(biddingNo, CompanyUtils.currentCompany());
        return ResponseResult.success(count);
    }

    @ApiOperation(httpMethod="GET", value="\u91c7\u8d2d\u65b9\u67e5\u770b\u7ea2\u5708\u6570\u91cf")
    @RequestMapping(value={"service/pur/countPurQuestionInfo"})
    @ResponseBody
    public ResponseResult<Integer> countPurQuestionInfo(@RequestParam String biddingNo) {
        int count = this.biddingQuestionService.countPurQuestionInfo(biddingNo);
        return ResponseResult.success(count);
    }

    @ApiOperation(httpMethod="GET", value="\u91c7\u8d2d\u5546\u67e5\u770b\u95ee\u9898\u8be6\u60c5")
    @RequestMapping(value={"service/pur/findDetailById"})
    @ResponseBody
    public ResponseResult<BiddingQuestion> findDetailByIdForPur(@RequestParam String id) {
        BiddingQuestion question = (BiddingQuestion)this.biddingQuestionService.queryObjById(id);
        return ResponseResult.success(question);
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u62db\u6295\u6807\u5728\u7ebf\u7b54\u7591(\u4f9b\u5e94\u5546\u65b9)")
    @RequestMapping(value={"service/sup/editQuestionForSup"})
    @ResponseBody
    public ResponseResult<String> editQuestionForSup(@RequestBody BiddingQuestion question) {
        this.biddingQuestionService.editQuestionForSup(question);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u7b54\u590d\u4f9b\u5e94\u5546\u95ee\u9898")
    @RequestMapping(value={"service/pur/answerSupQuestion"})
    @ResponseBody
    public ResponseResult<String> answerSupQuestion(@RequestBody BiddingQuestion question) {
        this.biddingQuestionService.answerSupQuestion(question, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6295\u6807\u5728\u7ebf\u7b54\u7591(\u4f9b\u5e94\u5546\u65b9)")
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingQuestion>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam String biddingNo) {
        Assert.isNotBlank(biddingNo, "\u62db\u6295\u6807\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        BiddingQuestionExample example = new BiddingQuestionExample();
        example.setPageView(new PageView<BiddingQuestion>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BiddingQuestionExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andBiddingNoEqualTo(biddingNo);
        example.or().andBiddingNoEqualTo(biddingNo).andIsEnableEqualTo(Constant.YES_INT).andQuestionTypeEqualTo(Constant.YES_INT);
        PageView pageData = this.biddingQuestionService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6295\u6807\u5728\u7ebf\u7b54\u7591(\u91c7\u8d2d\u65b9)")
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingQuestion>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam String biddingNo) {
        Assert.isNotBlank(biddingNo, "\u62db\u6295\u6807\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        BiddingQuestionExample example = new BiddingQuestionExample();
        example.setPageView(new PageView<BiddingQuestion>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BiddingQuestionExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBiddingNoEqualTo(biddingNo);
        PageView pageData = this.biddingQuestionService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

