/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.template;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.template.CreateOrderItemDetailTplCmd;
import com.els.base.inquiry.command.template.IsTemplateConfInUsedCmd;
import com.els.base.inquiry.command.template.ModifyTemplateConfCmd;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ModifyOrderItemDetailTplCmd
extends AbstractInquiryCommand<String> {
    private TplOrderItemDetail tplOrderItemDetail;

    public ModifyOrderItemDetailTplCmd(TplOrderItemDetail tplOrderItemDetail) {
        this.tplOrderItemDetail = tplOrderItemDetail;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotBlank(this.tplOrderItemDetail.getId(), "\u6a21\u677fId\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.isDeleteable(this.tplOrderItemDetail.getId())) {
            invoker.getPropertyDefService().moveAllToHisByTpl(this.tplOrderItemDetail.getId(), PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
            TplOrderItemDetail tmp = new TplOrderItemDetail();
            tmp.setId(this.tplOrderItemDetail.getId());
            tmp.setIsHis(Constant.YES_INT);
            invoker.getTplOrderItemDetailService().modifyObj(tmp);
            this.tplOrderItemDetail.setId(null);
            CreateOrderItemDetailTplCmd cmd = new CreateOrderItemDetailTplCmd(this.tplOrderItemDetail);
            cmd.copyProperties(this);
            invoker.invoke(cmd);
            List<TemplateConf> templateConfList = this.queryTemplateConf(tmp.getId());
            if (CollectionUtils.isEmpty(templateConfList)) {
                return null;
            }
            for (TemplateConf templateConf : templateConfList) {
                if (Constant.YES_INT.equals(templateConf.getIsHis())) continue;
                templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(templateConf.getId());
                templateConf.setTplOrderItemDetail(this.tplOrderItemDetail);
                templateConf.setOrderItemDtlTplId(this.tplOrderItemDetail.getId());
                ModifyTemplateConfCmd templateConfCmd = new ModifyTemplateConfCmd(templateConf);
                invoker.invoke(templateConfCmd);
            }
            return null;
        }
        invoker.getPropertyDefService().removeAllByTpl(this.tplOrderItemDetail.getId(), PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
        invoker.getTplOrderItemDetailService().deleteObjById(this.tplOrderItemDetail.getId());
        CreateOrderItemDetailTplCmd cmd = new CreateOrderItemDetailTplCmd(this.tplOrderItemDetail);
        cmd.copyProperties(this);
        return invoker.invoke(cmd);
    }

    private boolean isDeleteable(String orderItemTplId) {
        boolean isContain = this.invoker.getPropertyValueService().isContainTpl(this.tplOrderItemDetail.getId(), PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
        if (isContain) {
            return false;
        }
        List<TemplateConf> templateConfList = this.queryTemplateConf(orderItemTplId);
        if (CollectionUtils.isEmpty(templateConfList)) {
            return true;
        }
        return templateConfList.stream().noneMatch(template -> {
            IsTemplateConfInUsedCmd cmd = new IsTemplateConfInUsedCmd(template.getId());
            return this.invoker.invoke(cmd);
        });
    }

    private List<TemplateConf> queryTemplateConf(String orderItemTplId) {
        TemplateConfExample example = new TemplateConfExample();
        example.createCriteria().andOrderItemDtlTplIdEqualTo(orderItemTplId);
        return this.invoker.getTemplateConfService().queryAllObjByExample(example);
    }
}

