/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.InquirySupReadMapper;
import com.els.base.inquiry.entity.InquirySupRead;
import com.els.base.inquiry.entity.InquirySupReadExample;
import com.els.base.inquiry.service.InquirySupReadService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultInquirySupReadService")
public class InquirySupReadServiceImpl
implements InquirySupReadService {
    @Resource
    protected InquirySupReadMapper inquirySupReadMapper;

    @Override
    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    public void addObj(InquirySupRead t) {
        this.inquirySupReadMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    public void addAll(List<InquirySupRead> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.inquirySupReadMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    public void deleteObjById(String id) {
        this.inquirySupReadMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    public void modifyObj(InquirySupRead t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.inquirySupReadMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"inquirySupRead"}, keyGenerator="redisKeyGenerator")
    public InquirySupRead queryObjById(String id) {
        return this.inquirySupReadMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"inquirySupRead"}, keyGenerator="redisKeyGenerator")
    public List<InquirySupRead> queryAllObjByExample(InquirySupReadExample example) {
        return this.inquirySupReadMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"inquirySupRead"}, keyGenerator="redisKeyGenerator")
    public PageView<InquirySupRead> queryObjByPage(InquirySupReadExample example) {
        PageView<InquirySupRead> pageView = example.getPageView();
        pageView.setQueryResult(this.inquirySupReadMapper.selectByExampleByPage(example));
        return pageView;
    }
}

