/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ClassReflectionUtils {
    private ClassReflectionUtils() {
    }

    public static Class getClassByName(String className) {
        Assert.isNotBlank(className, "\u6a21\u677f\u914d\u7f6e\u5f02\u5e38\uff0c\u7c7b\u540d\u4e3a\u7a7a");
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new CommonException(String.format("\u6a21\u677f\u914d\u7f6e\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u8be5\u7c7b[%s]", className));
        }
    }

    public static <T> T newInstatnce(Class<T> orderItemClass) {
        try {
            return orderItemClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CommonException(String.format("\u6a21\u677f\u914d\u7f6e\u5f02\u5e38\uff0c\u8be5\u7c7b\u521d\u59cb\u5316\u5f02\u5e38[%s]", orderItemClass.getName()));
        }
    }

    public static List<Field> getPrimitiveField(Class clazz) {
        List<Field> fieldArray = ClassReflectionUtils.getAllField(clazz);
        List<Method> methodArray = ClassReflectionUtils.getAllMethod(clazz);
        return fieldArray.stream().filter(field -> {
            String setMethodName = String.format("set%s", StringUtils.capitalize((String)field.getName()));
            return methodArray.stream().anyMatch(methodObj -> setMethodName.equals(methodObj.getName()));
        }).collect(Collectors.toList());
    }

    private static List<Method> getAllMethod(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        Class supClass = clazz.getSuperclass();
        if (supClass == null) {
            return Arrays.asList(methodArray);
        }
        List<Method> supMethods = Arrays.stream(supClass.getDeclaredMethods()).filter(supMethodObj -> Arrays.stream(methodArray).noneMatch(method -> method.getName().equals(supMethodObj.getName()))).collect(Collectors.toList());
        supMethods.addAll(Arrays.asList(methodArray));
        return supMethods;
    }

    private static List<Field> getAllField(Class clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        Class supClass = clazz.getSuperclass();
        if (supClass == null) {
            return Arrays.asList(fieldArray);
        }
        List<Field> supFieldList = Arrays.stream(supClass.getDeclaredFields()).filter(supField -> Arrays.stream(fieldArray).noneMatch(field -> field.getName().equals(supField.getName()))).collect(Collectors.toList());
        supFieldList.addAll(Arrays.asList(fieldArray));
        return supFieldList;
    }
}

