/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.service.impl;

import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.im.MouldImTemplete;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.entity.MouldMaterial;
import com.els.base.mould.master.entity.MouldMaterialExample;
import com.els.base.mould.master.service.MouldMaterialService;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.notice.dao.MouldNoticeMapper;
import com.els.base.mould.notice.entity.MouldNotice;
import com.els.base.mould.notice.entity.MouldNoticeExample;
import com.els.base.mould.notice.entity.MouldNoticeMaterial;
import com.els.base.mould.notice.entity.MouldNoticePlan;
import com.els.base.mould.notice.entity.MouldNoticePlanExample;
import com.els.base.mould.notice.service.MouldNoticePlanService;
import com.els.base.mould.notice.service.MouldNoticeService;
import com.els.base.mould.notice.utils.TransFormUtils;
import com.els.base.mould.notice.vo.MouldNoticeColumnData;
import com.els.base.mould.notice.vo.MouldNoticeItemVO;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service(value="defaultMouldNoticeService")
public class MouldNoticeServiceImpl
implements MouldNoticeService {
    private static final String IM_CODE = "MOULD_NOTICE_IM";
    private static final String EXPIRED_CONFIRM_IM_CODE = "EXPIRED_CONFIRM_IM_CODE";
    @Resource
    protected MouldNoticeMapper mouldNoticeMapper;
    @Resource
    private MouldService mouldService;
    @Resource
    private MouldMaterialService mouldMaterialService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private MouldNoticePlanService mouldNoticePlanService;
    @Resource
    protected ThreadPoolTaskExecutor defaultThreadPool;

    @Override
    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void addObj(MouldNotice t) {
        this.mouldNoticeMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mouldNoticeMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void modifyObj(MouldNotice t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mouldNoticeMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"mouldNotice"}, keyGenerator="redisKeyGenerator")
    public MouldNotice queryObjById(String id) {
        return this.mouldNoticeMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"mouldNotice"}, keyGenerator="redisKeyGenerator")
    public List<MouldNotice> queryAllObjByExample(MouldNoticeExample example) {
        return this.mouldNoticeMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"mouldNotice"}, keyGenerator="redisKeyGenerator")
    public PageView<MouldNotice> queryObjByPage(MouldNoticeExample example) {
        PageView<MouldNotice> pageView = example.getPageView();
        pageView.setQueryResult(this.mouldNoticeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void deleteMouldNotices(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u5220\u9664\u6a21\u5177!");
        }
        MouldNoticeExample example = new MouldNoticeExample();
        example.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.YES_INT);
        if (this.mouldNoticeMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u5220\u9664\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        MouldNotice mn = new MouldNotice();
        mn.setIsEnable(Constant.NO_INT);
        mn.setUpdateTime(new Date());
        this.mouldNoticeMapper.updateByExampleSelective(mn, example);
    }

    @Override
    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void sendToSup(List<String> ids, final com.els.base.auth.entity.User user) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684id\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u53d1\u9001\u5355\u636e!");
        }
        MouldNoticeExample example = new MouldNoticeExample();
        example.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.YES_INT);
        if (this.mouldNoticeMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u4e86\u5df2\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u91cd\u590d\u53d1\u9001\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        MouldNotice mn = new MouldNotice();
        mn.setPurUserId(user.getId());
        mn.setSendStatus(Constant.YES_INT);
        mn.setSendTime(new Date());
        mn.setUpdateTime(new Date());
        this.mouldNoticeMapper.updateByExampleSelective(mn, example);
        final List<MouldNotice> list = this.queryAllObjByExample(example);
        Map<String, List<MouldNotice>> groupMap = this.groupMouldNotice(list);
        if (null == groupMap) {
            return;
        }
        Set<String> keySet = groupMap.keySet();
        for (String key : keySet) {
            final List<MouldNotice> noticeList = groupMap.get(key);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    MouldImTemplete tem = MouldNoticeServiceImpl.this.constructImInfo(1, "\u53d1\u9001", noticeList);
                    MouldNoticeServiceImpl.this.sendMessagesToSup(user, tem, (MouldNotice)list.get(0));
                }
            });
        }
    }

    public void sendMessagesToSup(com.els.base.auth.entity.User loginUser, MouldImTemplete templet, MouldNotice data) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    private Map<String, List<MouldNotice>> groupMouldNotice(List<MouldNotice> list) {
        if (null == list) {
            return null;
        }
        HashMap<String, List<MouldNotice>> groupMap = new HashMap<String, List<MouldNotice>>();
        for (MouldNotice mn : list) {
            String supCompanySrmCode = mn.getSupCompanySrmCode();
            ArrayList<MouldNotice> noticeList = (ArrayList<MouldNotice>)groupMap.get(supCompanySrmCode);
            if (null == noticeList) {
                noticeList = new ArrayList<MouldNotice>();
            }
            noticeList.add(mn);
            groupMap.put(supCompanySrmCode, noticeList);
        }
        return groupMap;
    }

    public void sendMessagesToPur(MouldNotice data, MouldImTemplete templet) {
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(data.getSupCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(data.getSupUserId()).addReceiverId(data.getPurUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    private MouldImTemplete constructImInfo(int role, String operate, List<MouldNotice> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u5217\u8868\u4e3a\u7a7a,\u65e0\u6cd5\u751f\u6210\u6d88\u606f\u6a21\u677f!");
        }
        MouldImTemplete tem = new MouldImTemplete();
        if (role == 1) {
            tem.setRole("\u91c7\u8d2d\u5546");
            if (StringUtils.isNotEmpty((String)list.get(0).getPurCompanyName())) {
                tem.setCompanyName(list.get(0).getPurCompanyName());
            } else {
                tem.setCompanyName("");
            }
        } else {
            tem.setRole("\u4f9b\u5e94\u5546");
            if (StringUtils.isNotEmpty((String)list.get(0).getSupCompanyName())) {
                tem.setCompanyName(list.get(0).getSupCompanyName());
            } else {
                tem.setCompanyName("");
            }
        }
        Assert.isNotBlank(operate, "\u6ca1\u6709\u4f20\u5165\u64cd\u4f5c\u5b57\u6bb5,\u65e0\u6cd5\u751f\u6210\u6d88\u606f\u6a21\u677f!");
        tem.setOperate(operate);
        tem.setOtherInfo("\u4e86\u65b0\u7684\u5f00\u6a21\u53d8\u66f4\u901a\u77e5\u5355,\u5355\u636e\u53f7\u5305\u62ec\uff1a");
        ArrayList<String> noList = new ArrayList<String>();
        for (MouldNotice item : list) {
            noList.add(item.getMouldNoticeBillNo());
        }
        String billData = StringUtils.join(noList, (String)",");
        tem.setBillList(billData);
        return tem;
    }

    @Override
    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void confirmMouldNotices(List<String> ids, com.els.base.auth.entity.User user) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684id\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u786e\u8ba4\u5355\u636e!");
        }
        MouldNoticeExample example = new MouldNoticeExample();
        example.createCriteria().andIdIn((List)ids).andConfirmStatusEqualTo(Constant.YES_INT);
        if (this.mouldNoticeMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u4e86\u5df2\u786e\u8ba4\u7684\u5355\u636e,\u65e0\u6cd5\u91cd\u590d\u786e\u8ba4\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        final List<MouldNotice> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u67e5\u8be2\u7684\u5355\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u786e\u8ba4\u5355\u636e!");
        }
        for (MouldNotice mouldNotice : list) {
            MouldNoticePlanExample planExample = new MouldNoticePlanExample();
            planExample.createCriteria().andMouldNoticeIdEqualTo(mouldNotice.getId());
            List planList = this.mouldNoticePlanService.queryAllObjByExample(planExample);
            if (CollectionUtils.isEmpty(planList)) {
                throw new CommonException("\u67e5\u8be2\u7684\u8ba1\u5212\u4fe1\u606f\u4e3a\u7a7a,\u65e0\u6cd5\u786e\u8ba4\u5355\u636e!");
            }
            for (MouldNoticePlan plan : planList) {
                Assert.isNotNull(plan.getPlanCompleteTime(), "\u6a21\u5177\u4e2d\u8fd8\u6709\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u672a\u586b,\u65e0\u6cd5\u786e\u8ba4\u5355\u636e!");
            }
        }
        MouldNotice mn = new MouldNotice();
        mn.setSupUserId(user.getId());
        mn.setConfirmStatus(Constant.YES_INT);
        mn.setUpdateTime(new Date());
        this.mouldNoticeMapper.updateByExampleSelective(mn, example);
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                MouldImTemplete templet = MouldNoticeServiceImpl.this.constructImInfo(2, "\u786e\u8ba4", list);
                MouldNoticeServiceImpl.this.sendMessagesToPur((MouldNotice)list.get(0), templet);
            }
        });
    }

    @Override
    public List<MouldNoticeItemVO> generateNoticeItemByMouldId(List<String> mouldIds) {
        if (CollectionUtils.isEmpty(mouldIds)) {
            throw new CommonException("\u6a21\u5177id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MouldExample example = new MouldExample();
        example.createCriteria().andIdIn((List)mouldIds);
        List mouldList = this.mouldService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(mouldList)) {
            throw new CommonException("\u67e5\u8be2\u5230\u7684\u6a21\u5177\u4fe1\u606f\u4e3a\u7a7a!");
        }
        ArrayList<MouldNoticeItemVO> itemVoList = new ArrayList<MouldNoticeItemVO>();
        for (Mould mould : mouldList) {
            MouldNoticeItemVO itemVo = new MouldNoticeItemVO();
            BeanUtils.copyProperties((Object)mould, (Object)itemVo);
            MouldMaterialExample materialExample = new MouldMaterialExample();
            materialExample.createCriteria().andMouldIdEqualTo(mould.getId());
            List materialList = this.mouldMaterialService.queryAllObjByExample(materialExample);
            if (CollectionUtils.isEmpty(materialList)) {
                throw new CommonException("\u6a21\u5177\u67e5\u8be2\u7684\u7269\u6599\u4fe1\u606f\u4e3a\u7a7a!");
            }
            ArrayList<MouldNoticeMaterial> noticeMaterialList = new ArrayList<MouldNoticeMaterial>();
            for (MouldMaterial mouldMaterial : materialList) {
                MouldNoticeMaterial noticeMaterial = new MouldNoticeMaterial();
                noticeMaterial.setMaterialCode(mouldMaterial.getMaterialCode());
                noticeMaterial.setMaterialDesc(mouldMaterial.getMaterialDesc());
                noticeMaterial.setProductMouldQuantity(mouldMaterial.getProductMouldQuantity());
                noticeMaterialList.add(noticeMaterial);
            }
            itemVo.setMaterialList(noticeMaterialList);
            List<MouldNoticePlan> noticePlanList = this.generatePlanInfo();
            List<Map<String, MouldNoticeColumnData>> planList = TransFormUtils.transform(noticePlanList);
            itemVo.setPlanList(planList);
            itemVoList.add(itemVo);
        }
        return itemVoList;
    }

    @Override
    public void expiredConfirmImNotify() {
        List<MouldNotice> list = this.mouldNoticeMapper.findExpiredConfirmInfo();
        if (null == list) {
            return;
        }
        Map<String, List<MouldNotice>> groupList = this.groupMouldNotice(list);
        Set<String> keySet = groupList.keySet();
        for (String key : keySet) {
            final List<MouldNotice> noticeList = groupList.get(key);
            if (null == noticeList) continue;
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    MouldImTemplete tem = MouldNoticeServiceImpl.this.constructExpiredConfirmImInfo(noticeList);
                    MouldNoticeServiceImpl.this.sendExpiredConfirmMessagesToSup(tem, (MouldNotice)noticeList.get(0));
                }
            });
        }
    }

    private MouldImTemplete constructExpiredConfirmImInfo(List<MouldNotice> list) {
        MouldImTemplete tem = new MouldImTemplete();
        tem.setOtherInfo("\u91c7\u8d2d\u5546\u53d1\u9001\u7684\u5f00\u6a21\u53d8\u66f4\u901a\u77e5\u5355\u5e94\u57283\u5929\u5185\u786e\u8ba4,\u60a8\u6709\u903e\u671f\u672a\u786e\u8ba4\u7684\u5f00\u6a21\u53d8\u66f4\u901a\u77e5\u5355,\u8bf7\u5c3d\u5feb\u786e\u8ba4\u5355\u636e,\u5355\u636e\u53f7\u5305\u62ec\uff1a");
        ArrayList<String> noList = new ArrayList<String>();
        for (MouldNotice item : list) {
            noList.add(item.getMouldNoticeBillNo());
        }
        String billData = StringUtils.join(noList, (String)",");
        tem.setBillList(billData);
        return tem;
    }

    public void sendExpiredConfirmMessagesToSup(MouldImTemplete templet, MouldNotice data) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        Message message = Message.init((Object)templet).setBusinessTypeCode(EXPIRED_CONFIRM_IM_CODE).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(data.getPurUserId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    public List<MouldNoticePlan> generatePlanInfo() {
        ArrayList<MouldNoticePlan> planList = new ArrayList<MouldNoticePlan>();
        planList.add(new MouldNoticePlan("\u5f00\u6a21\u65e5\u671f", 1));
        planList.add(new MouldNoticePlan("\u6a21\u5177\u8bbe\u8ba1", 2));
        planList.add(new MouldNoticePlan("\u8ba2\u6599", 3));
        planList.add(new MouldNoticePlan("\u673a\u52a0\u5de5/CNC\u52a0\u5de5", 4));
        planList.add(new MouldNoticePlan("\u7ebf\u5272", 5));
        planList.add(new MouldNoticePlan("\u7535\u706b\u82b1", 6));
        planList.add(new MouldNoticePlan("FIT\u6a21", 7));
        planList.add(new MouldNoticePlan("\u7701\u6a21", 8));
        planList.add(new MouldNoticePlan("\u6a21\u5177\u7ec4\u88c5\u5b8c\u6210\u65e5\u671f", 9));
        planList.add(new MouldNoticePlan("\u5149\u8eab\u677f\u5230\u6837\u65e5\u671f", 10));
        return planList;
    }
}

