/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.workflow.common.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.workflow.common.entity.RoleResult;
import com.els.base.workflow.common.entity.UserReponse;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"actuser"})
public class ActivitiUserController {
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private UserService userService;

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6\u6240\u6709\u89d2\u8272")
    @RequestMapping(value={"service/getAllRole"})
    @ResponseBody
    public List<RoleResult> getAllRole() throws IOException {
        RoleExample example = new RoleExample();
        example.createCriteria();
        List roleList = this.roleService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)roleList)) {
            return Collections.emptyList();
        }
        return roleList.stream().map(role -> new RoleResult((Role)role)).collect(Collectors.toList());
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"service/getUserListByRoleId"})
    @ResponseBody
    public UserReponse getUserListByRoleId(@RequestParam(required=true) String roleId, @RequestParam(required=true) int pageNo, int pageSize, HttpServletResponse httpServletResponse) throws IOException {
        List userIds = this.userRoleService.queryUserIdsForRoleId(roleId);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            httpServletResponse.setStatus(503);
            Assert.isNotEmpty(userIds, "\u8be5\u89d2\u8272\u4e0b\u7684\u7528\u6237\u4e3a\u7a7a");
        }
        UserExample example = new UserExample();
        example.createCriteria().andIdIn(userIds);
        example.setPageView(new PageView<User>(pageNo, pageSize));
        PageView pageView = this.userService.queryObjByPage(example);
        List<User> queryResult = pageView.getQueryResult();
        UserReponse userReponse = new UserReponse();
        userReponse.setTotals(pageView.getiTotalRecords());
        userReponse.setUsers(queryResult);
        return userReponse;
    }
}

