
CREATE TABLE T_BASE_MOULD_HIS (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"MOULD_CODE" VARCHAR2(255 BYTE) NULL ,
"MOULD_DESC" VARCHAR2(255 BYTE) NULL ,
"MOULD_NO" VARCHAR2(255 BYTE) NULL ,
"MOULD_MATERIAL" VARCHAR2(255 BYTE) NULL ,
"HIS_UPDATE_TIME" DATE NULL ,
"CHANGE_TYPE" NUMBER(7) NULL ,
"ADJUST_BILL_NO" VARCHAR2(255 BYTE) NULL ,
"MANUFACTURER" VARCHAR2(255 BYTE) NULL ,
"ASSET_CONTRACT_NUMBER" VARCHAR2(255 BYTE) NULL ,
"BELONGED_YEAR" VARCHAR2(255 BYTE) NULL ,
"MOULD_LIFETIME" NUMBER(13,2) NULL ,
"MOULD_PROPERTY_RIGHT_STATE" VARCHAR2(255 BYTE) NULL ,
"MOULD_ASCRIPTION" VARCHAR2(255 BYTE) NULL ,
"LEADING_OFFICIAL" VARCHAR2(255 BYTE) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"UPDATE_TIME" DATE NULL ,
"PUR_REMARK" VARCHAR2(1000 BYTE) NULL ,
"SUP_REMARK" VARCHAR2(1000 BYTE) NULL 
)
;
COMMENT ON TABLE T_BASE_MOULD_HIS IS '资产管理-模具调整履历报表';
COMMENT ON COLUMN T_BASE_MOULD_HIS."ID" IS '主键';
COMMENT ON COLUMN T_BASE_MOULD_HIS."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN T_BASE_MOULD_HIS."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN T_BASE_MOULD_HIS."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_MOULD_HIS."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN T_BASE_MOULD_HIS."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN T_BASE_MOULD_HIS."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN T_BASE_MOULD_HIS."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_MOULD_HIS."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN T_BASE_MOULD_HIS."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN T_BASE_MOULD_HIS."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN T_BASE_MOULD_HIS."MOULD_CODE" IS '模具编码';
COMMENT ON COLUMN T_BASE_MOULD_HIS."MOULD_DESC" IS '模具名称';
COMMENT ON COLUMN T_BASE_MOULD_HIS."MOULD_NO" IS '模具编号';
COMMENT ON COLUMN T_BASE_MOULD_HIS."MOULD_MATERIAL" IS '模具材料';
COMMENT ON COLUMN T_BASE_MOULD_HIS."HIS_UPDATE_TIME" IS '历史变更日期';
COMMENT ON COLUMN T_BASE_MOULD_HIS."CHANGE_TYPE" IS '变更类型(0=寿命调整,1=移模,2=变更供应商,3=报废)';
COMMENT ON COLUMN T_BASE_MOULD_HIS."ADJUST_BILL_NO" IS '模具寿命/移模调整单单据号';
COMMENT ON COLUMN T_BASE_MOULD_HIS."MANUFACTURER" IS '制造商';
COMMENT ON COLUMN T_BASE_MOULD_HIS."ASSET_CONTRACT_NUMBER" IS '资产/合同编号';
COMMENT ON COLUMN T_BASE_MOULD_HIS."BELONGED_YEAR" IS '所属年份';
COMMENT ON COLUMN T_BASE_MOULD_HIS."MOULD_LIFETIME" IS '模具寿命';
COMMENT ON COLUMN T_BASE_MOULD_HIS."MOULD_PROPERTY_RIGHT_STATE" IS '模具产权状况';
COMMENT ON COLUMN T_BASE_MOULD_HIS."MOULD_ASCRIPTION" IS '开模归属';
COMMENT ON COLUMN T_BASE_MOULD_HIS."LEADING_OFFICIAL" IS '责任人';
COMMENT ON COLUMN T_BASE_MOULD_HIS."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_MOULD_HIS."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN T_BASE_MOULD_HIS."PUR_REMARK" IS '采购商备注';
COMMENT ON COLUMN T_BASE_MOULD_HIS."SUP_REMARK" IS '供应商备注';


ALTER TABLE T_BASE_MOULD_HIS ADD CHECK ("ID" IS NOT NULL);


ALTER TABLE T_BASE_MOULD_HIS ADD PRIMARY KEY ("ID");
