/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.DeleteCommand;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class BatchDeleteCommand
extends AbstractInquiryCommand<String> {
    private List<String> ids;

    public BatchDeleteCommand(List<String> ids) {
        this.ids = ids;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.valid(this.ids);
        for (String id : this.ids) {
            DeleteCommand deleteCommand = new DeleteCommand(id);
            deleteCommand.copyProperties(this);
            invoker.invoke(deleteCommand);
        }
        return null;
    }

    private void valid(List<String> idList) {
        Assert.isNotEmpty(idList, "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        PurOrderExample example = new PurOrderExample();
        PurOrderExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn((List)idList);
        List purOrders = this.invoker.getPurOrderService().queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(purOrders)) {
            throw new CommonException("\u8be2\u4ef7\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        for (PurOrder purOrder : purOrders) {
            if (InquiryOrderStatus.UNPUBLISHED.getCode().equals(purOrder.getInquiryOrderStatus())) continue;
            throw new CommonException(String.format("\u53ea\u80fd\u5220\u9664\u672a\u53d1\u5e03\u7684\u8be2\u4ef7\u5355\uff0c\u8bf7\u68c0\u67e5\u8be2\u4ef7\u5355[%s]", purOrder.getOrderNo()));
        }
    }
}

