/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanySapRelation;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.CreateCommand;
import com.els.base.inquiry.command.pur.ModifyCommand;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryLadderBelongType;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.MessageNotify;
import com.els.base.inquiry.utils.LaddPriceValider;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class PublishCommand
extends AbstractInquiryCommand<String> {
    private PurOrder purOrder;
    private TemplateConf templateConf;

    public PublishCommand(PurOrder purOrder) {
        this.purOrder = purOrder;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.purOrder.getTemplateId());
        this.valid(this.purOrder);
        this.init(this.purOrder);
        this.createOrModifyPurOrder(this.purOrder);
        List<InquirySupOrder> inquirySupOrders = this.publish(this.purOrder);
        this.sendMsg(inquirySupOrders);
        return null;
    }

    private void sendMsg(List<InquirySupOrder> inquirySupOrders) {
        inquirySupOrders.sort(Comparator.comparing(InquirySupOrder::getSupCompanyId));
        for (int i = 0; i < inquirySupOrders.size(); ++i) {
            InquirySupOrder inquirySupOrder = inquirySupOrders.get(i);
            if (i != 0 && inquirySupOrder.getSupCompanyId().equals(inquirySupOrders.get(i - 1).getSupCompanyId())) continue;
            String supUserId = this.invoker.getCompanyUserRefService().queryMainUserOfCompany(inquirySupOrder.getSupCompanyId()).getId();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("inquirySupOrderId", inquirySupOrder.getId());
            data.put("orderNo", inquirySupOrder.getOrderNo());
            Message msg = Message.init(data).setCompanyCode(this.getPurCompany().getCompanyCode()).setBusinessTypeCode(MessageNotify.INQUIRY_ORDER_PUBLISH.getCode()).setSenderId(this.purOrder.getPurUserId()).addReceiverId(supUserId).setMsgLevel(MessageLevelEnum.HIGH);
            MessageSendUtils.sendMessage((Message)msg);
        }
    }

    private List<InquirySupOrder> publish(PurOrder purOrder) {
        List<InquirySupOrder> supOrderList = this.addSupOrderList(purOrder);
        this.addOrderItemList(purOrder, supOrderList);
        this.saveDataToOrder(supOrderList);
        this.addBusiConditionList(purOrder, supOrderList);
        this.addMouldList(purOrder, supOrderList);
        this.transformToPublishStatus(purOrder);
        return supOrderList;
    }

    private void saveDataToOrder(List<InquirySupOrder> supOrderList) {
        supOrderList.forEach(supOrder -> {
            List itemList = this.templateConf.getOrderItemService().queryBySupOrderId(supOrder.getId());
            String tempMaterialCode = itemList.stream().map(item -> item.getMaterialCode() != null ? item.getMaterialCode() : null).distinct().filter(materialCode -> materialCode != null).collect(Collectors.joining("&"));
            String tempMaterialDesc = itemList.stream().map(item -> item.getMaterialDesc() != null ? item.getMaterialDesc() : null).distinct().filter(materialDesc -> materialDesc != null).collect(Collectors.joining("&"));
            String tempBrand = itemList.stream().map(item -> item.getBrand() != null ? item.getBrand() : null).distinct().filter(brand -> brand != null).collect(Collectors.joining("&"));
            InquirySupOrder tempSupOrder = new InquirySupOrder();
            tempSupOrder.setId(supOrder.getId());
            tempSupOrder.setBrandList(tempBrand);
            tempSupOrder.setMaterialCodeList(tempMaterialCode);
            tempSupOrder.setMaterialDescList(tempMaterialDesc);
            this.invoker.getInquirySupOrderService().modifyObj(tempSupOrder);
        });
    }

    private void addMouldList(PurOrder purOrder, List<InquirySupOrder> supOrderList) {
        if (CollectionUtils.isEmpty(purOrder.getMouldList())) {
            return;
        }
        List<IMould> allMouldList = purOrder.getMouldList().parallelStream().flatMap(mould -> supOrderList.stream().map(supOrder -> {
            IMould newMould = mould.build(purOrder, (InquirySupOrder)supOrder);
            newMould.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(newMould));
            return newMould;
        })).collect(Collectors.toList());
        this.templateConf.getMouldService().deleteByPurOrder(purOrder.getId());
        this.templateConf.getMouldService().addAll(allMouldList);
        if (Constant.YES_INT.equals(this.templateConf.getIsMouldDetailEnable())) {
            this.addMouldDetail(allMouldList);
        }
    }

    private void addMouldDetail(List<IMould> allMouldList) {
        if (CollectionUtils.isEmpty(allMouldList)) {
            return;
        }
        List allMouldDetailList = allMouldList.parallelStream().map(mould -> {
            IMouldDetail mouldDetail;
            try {
                mouldDetail = this.templateConf.getTplMouLdDetail().getMouldDetailClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            mouldDetail.build((IMould)mould);
            mouldDetail.setTemplateId(this.templateConf.getTplMouLdDetail().getId());
            mouldDetail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(mouldDetail));
            return mouldDetail;
        }).collect(Collectors.toList());
        this.templateConf.getTplMouLdDetail().getMouldDetailService().addAll(allMouldDetailList);
    }

    private void addBusiConditionList(PurOrder purOrder, List<InquirySupOrder> supOrderList) {
        if (Constant.NO_INT.equals(this.templateConf.getIsBusiCondEnable())) {
            return;
        }
        InquiryBusiConditionExample example = new InquiryBusiConditionExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrder.getId());
        this.invoker.getInquiryBusiConditionService().deleteByExample(example);
        List<InquiryBusiCondition> busiConditionList = supOrderList.stream().map(supOrder -> {
            InquiryBusiCondition inquiryBusiCondition = new InquiryBusiCondition();
            inquiryBusiCondition.setSupOrderId(supOrder.getId());
            inquiryBusiCondition.setPurOrderId(purOrder.getId());
            inquiryBusiCondition.setSupCompanyId(supOrder.getSupCompanyId());
            inquiryBusiCondition.setSupCompanyName(supOrder.getSupCompanyName());
            inquiryBusiCondition.setSupCompanySrmCode(supOrder.getSupCompanySrmCode());
            if (StringUtils.isNotBlank((String)supOrder.getSupCompanySapCode())) {
                inquiryBusiCondition.setSupCompanySapCode(supOrder.getSupCompanySapCode());
                CompanySapRelation companySapRelation = this.invoker.getCompanySapRelationService().findBySrmCodeAndSapCode(supOrder.getSupCompanySrmCode(), supOrder.getSupCompanySapCode());
                inquiryBusiCondition.setCurrency(companySapRelation.getOrderCurren());
                inquiryBusiCondition.setTaxRate(companySapRelation.getTaxRateCode());
                inquiryBusiCondition.setTaxType(companySapRelation.getTaxType());
                inquiryBusiCondition.setPayTerms(companySapRelation.getPaymentMode());
            } else {
                Company company = (Company)this.invoker.getCompanyService().queryObjById(supOrder.getSupCompanyId());
                if (company == null) {
                    throw new CommonException("\u4f9b\u5e94\u5546ID\u9519\u8bef,\u751f\u6210\u4fe1\u606f\u5931\u8d25");
                }
                inquiryBusiCondition.setCurrency(company.getOrderCurren());
                inquiryBusiCondition.setTaxRate(company.getTax());
                inquiryBusiCondition.setTaxType(company.getTaxType());
                inquiryBusiCondition.setPayTerms(company.getPayConditionsCode());
            }
            inquiryBusiCondition.setTemplateConfId(purOrder.getTemplateId());
            inquiryBusiCondition.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(inquiryBusiCondition));
            return inquiryBusiCondition;
        }).collect(Collectors.toList());
        this.invoker.getInquiryBusiConditionService().addAll(busiConditionList);
    }

    private void addOrderItemList(PurOrder order, List<InquirySupOrder> supOrderList) {
        List<IOrderItem> allOrderItemList = supOrderList.parallelStream().flatMap(supOrder -> order.getTargetList().stream().map(target -> {
            Class<? extends IOrderItem> orderItemCls = this.templateConf.getOrderItemClass();
            IOrderItem orderItem = null;
            try {
                orderItem = orderItemCls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            orderItem.build(order, (InquirySupOrder)supOrder, (ITarget)target);
            orderItem.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(orderItem));
            return orderItem;
        })).collect(Collectors.toList());
        int purOrderIndex = 1;
        for (IOrderItem orderItem : allOrderItemList) {
            orderItem.setOrderItemNo(purOrderIndex++);
        }
        this.templateConf.getOrderItemService().addAll(allOrderItemList);
        this.addOrderItemQuoteLadderList(order, allOrderItemList);
        if (Constant.YES_INT.equals(this.templateConf.getIsOrderItemDetailEnable())) {
            this.addOrderItemDetail(allOrderItemList);
        }
    }

    private void addOrderItemDetail(List<IOrderItem> allOrderItemList) {
        if (CollectionUtils.isEmpty(allOrderItemList)) {
            return;
        }
        List detailList = allOrderItemList.stream().map(item -> {
            IOrderItemDetail detail = null;
            try {
                detail = this.templateConf.getTplOrderItemDetail().getOrderItemDetailClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            detail.build((IOrderItem)item);
            detail.setTemplateId(this.templateConf.getTplOrderItemDetail().getId());
            detail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(detail));
            return detail;
        }).collect(Collectors.toList());
        this.templateConf.getTplOrderItemDetail().getOrderItemDetailService().addAll(detailList);
    }

    private void addOrderItemQuoteLadderList(PurOrder order, List<IOrderItem> allOrderItemList) {
        Stream stream = allOrderItemList.stream().flatMap(orderItem -> order.getTargetList().stream().filter(target -> CollectionUtils.isNotEmpty(target.getInquiryQuoteLadders()) && InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(target.getQuoteType())).filter(target -> target.getId().equals(orderItem.getTargetId())).flatMap(target -> target.getInquiryQuoteLadders().stream().map(ladder -> {
            InquiryQuoteLadder inquiryQuoteLadder = new InquiryQuoteLadder();
            BeanUtils.copyProperties((Object)ladder, (Object)inquiryQuoteLadder);
            inquiryQuoteLadder.setId(null);
            inquiryQuoteLadder.setBelongType(InquiryLadderBelongType.BELONG_TO_ITEM.getCode());
            inquiryQuoteLadder.setItemId(orderItem.getId());
            inquiryQuoteLadder.setCreateCompanyType("PUR");
            return inquiryQuoteLadder;
        })));
        this.invoker.getInquiryQuoteLadderService().addAll(stream.collect(Collectors.toList()));
    }

    private List<InquirySupOrder> addSupOrderList(PurOrder order) {
        List<InquirySupOrder> supOrderList = order.getInquirySuppliers().stream().map(inquirySupplier -> {
            InquirySupOrder inquirySupOrder = new InquirySupOrder();
            inquirySupOrder.setSupCompanyName(inquirySupplier.getSupCompanyName());
            inquirySupOrder.setSupCompanySrmCode(inquirySupplier.getSupCompanySrmCode());
            Company company = this.invoker.getCompanyService().queryCompanyByCode(inquirySupplier.getSupCompanySrmCode());
            if (company.getId().equals(inquirySupplier.getSupCompanyId())) {
                inquirySupOrder.setSupCompanyId(inquirySupplier.getSupCompanyId());
            } else {
                inquirySupOrder.setSupCompanyId(company.getId());
            }
            inquirySupOrder.setSupCompanySapCode(inquirySupplier.getSupCompanySapCode());
            inquirySupOrder.setSupTempCompanyId(inquirySupplier.getId());
            inquirySupOrder.setType(order.getType());
            inquirySupOrder.setTemplateId(order.getTemplateId());
            inquirySupOrder.setPurOrderId(order.getId());
            inquirySupOrder.setOrderNo(order.getOrderNo());
            inquirySupOrder.setDigestExplain(order.getDigestExplain());
            inquirySupOrder.setPublishDate(order.getPublishDate());
            inquirySupOrder.setQuoteStartDate(order.getQuoteStartDate());
            inquirySupOrder.setQuoteEndDate(order.getQuoteEndDate());
            inquirySupOrder.setRemark(order.getRemark());
            inquirySupOrder.setPurCompanyId(order.getPurCompanyId());
            inquirySupOrder.setPurCompanyName(order.getPurCompanyName());
            inquirySupOrder.setPurUserId(order.getPurUserId());
            inquirySupOrder.setPurUserName(order.getPurUserName());
            inquirySupOrder.setCreateDate(order.getCreateDate());
            inquirySupOrder.setInquiryOrderStatus(InquiryOrderStatus.PUBLISHED.getCode());
            inquirySupOrder.setQuoteStatus(InquiryQuoteStatus.UNQUOTED.getCode());
            inquirySupOrder.setTemplateId(order.getTemplateId());
            return inquirySupOrder;
        }).collect(Collectors.toList());
        this.invoker.getInquirySupOrderService().addAll(supOrderList);
        return supOrderList;
    }

    private void createOrModifyPurOrder(PurOrder purOrder) {
        AbstractInquiryCommand command = StringUtils.isBlank((String)purOrder.getId()) ? new CreateCommand(purOrder) : new ModifyCommand(purOrder);
        command.copyProperties(this);
        this.invoker.invoke(command);
    }

    private void valid(PurOrder order) {
        Assert.isNotBlank(order.getTemplateId(), "\u8ba2\u5355\u7684\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(this.templateConf, "\u8ba2\u5355\u7684\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(order.getInquiryOrderStatus(), "\u8be2\u4ef7\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        if (!InquiryOrderStatus.UNPUBLISHED.getCode().equals(order.getInquiryOrderStatus())) {
            throw new CommonException(String.format("\u53ea\u6709\u5904\u4e8e\u672a\u53d1\u5e03\u72b6\u6001\u8be2\u4ef7\u5355\u624d\u80fd\u6267\u884c\u53d1\u5e03\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u8be2\u4ef7\u5355[%s]", order.getOrderNo()));
        }
        Assert.isNotEmpty(order.getInquirySuppliers(), String.format("\u53d1\u5e03\u8be2\u4ef7\u5355\u65f6\u5fc5\u987b\u9009\u62e9\u4f9b\u5e94\u5546\uff0c\u8bf7\u68c0\u67e5\u8be2\u4ef7\u5355[%s]", order.getOrderNo()));
        order.getInquirySuppliers().forEach(supCompany -> {
            Assert.isNotBlank(supCompany.getId(), "\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(supCompany.getSupCompanyName(), "\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(supCompany.getSupCompanySrmCode(), "\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        });
        Assert.isNotEmpty(order.getTargetList(), String.format("\u7269\u6599\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8be2\u4ef7\u5355[%s]", order.getOrderNo()));
        order.getTargetList().forEach(target -> {
            Assert.isNotBlank(target.getMaterialDesc(), "\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            if (!(Constant.YES_INT.equals(this.templateConf.getIsOrderItemDetailEnable()) || InquiryQuoteLadderType.CONVENTIONAL_QUOTE.getCode().equals(target.getQuoteType()) || InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(target.getQuoteType()))) {
                throw new CommonException(String.format("\u62a5\u4ef7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u7269\u6599[%s]", target.getMaterialDesc()));
            }
        });
        order.getTargetList().stream().filter(target -> InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(target.getQuoteType())).forEach(target -> {
            if (CollectionUtils.isEmpty(target.getInquiryQuoteLadders())) {
                throw new CommonException(String.format("\u7269\u6599[%s] \u9009\u62e9\u4e86\u62a5\u4ef7\u65b9\u5f0f\u4e3a\u201c\u9636\u68af\u62a5\u4ef7\u201d\uff0c\u4f46\u672a\u8bbe\u7f6e\u62a5\u4ef7\u9636\u68af\uff01", target.getMaterialDesc()));
            }
            target.getInquiryQuoteLadders().forEach(quoteLadder -> {
                Assert.isNotNull(quoteLadder.getMaterialDesc(), "\u9636\u68af\u62a5\u4ef7\u7f3a\u5c11\u7269\u6599\u63cf\u8ff0");
                Assert.isNotNull(quoteLadder.getNumberLevel(), String.format("\u7269\u6599[%s]\u9636\u68af\u62a5\u4ef7\u7f3a\u5c11\"\u6570\u91cf\u7b49\u7ea7\"", quoteLadder.getMaterialDesc()));
                LaddPriceValider.valid(target.getInquiryQuoteLadders());
            });
        });
        if (Constant.YES_INT.equals(this.templateConf.getIsMouldEnable()) && CollectionUtils.isNotEmpty(order.getMouldList())) {
            order.getMouldList().forEach(mould -> Assert.isNotBlank(mould.getMouldCode(), "\u6a21\u5177\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        }
    }

    private void transformToPublishStatus(PurOrder order) {
        PurOrder temp = new PurOrder();
        temp.setId(order.getId());
        temp.setInquiryOrderStatus(InquiryOrderStatus.PUBLISHED.getCode());
        temp.setPublishDate(new Date());
        this.invoker.getPurOrderService().modifyObj(temp);
    }

    private void init(PurOrder purOrder) {
        purOrder.setPublishDate(new Date());
    }
}

