/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils.json;

import com.els.base.inquiry.IExtendable;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.utils.ClassReflectionUtils;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendableObjectJsonSerialzer
extends JsonSerializer<IExtendable> {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    private List<String> ignoreList() {
        ArrayList<String> ignoreList = new ArrayList<String>();
        ignoreList.add("propertyValueList");
        return ignoreList;
    }

    public void serialize(IExtendable value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        if (value == null) {
            gen.writeNull();
        }
        Map<String, Object> valueMap = this.buildMap(value);
        this.validMap(valueMap, value);
        gen.writeObject(valueMap);
    }

    public Map<String, Object> buildMap(IExtendable value) {
        Map<String, Object> valueMap = new HashMap<String, Object>();
        valueMap = this.setPrimitiveFieldIntoMap(valueMap, value);
        valueMap = this.setPropertyValue(valueMap, value);
        return valueMap;
    }

    private void validMap(Map<String, Object> valueMap, IExtendable value) {
        List<PropertyDef> defList = value.getPropertyDefList();
        if (CollectionUtils.isNotEmpty(defList = defList.stream().filter(def -> valueMap.keySet().stream().noneMatch(key -> def.getCode().equals(key))).filter(def -> def != null).collect(Collectors.toList()))) {
            String fieldName = StringUtils.join(defList, (String)",");
            throw new RuntimeException(String.format("\u53cd\u5e8f\u5217\u5316\uff0c\u5c11\u4e86\u5b57\u6bb5:%s", fieldName));
        }
    }

    private Map<String, Object> setPropertyValue(Map<String, Object> valueMap, IExtendable value) {
        List<PropertyDef> proDefList = this.filtePropertyDef(value);
        if (CollectionUtils.isEmpty(value.getPropertyValueList())) {
            value.setPropertyValueList(new ArrayList<PropertyValue>());
        }
        this.completePropertyValue(value, proDefList);
        value.getPropertyValueList().forEach(properyValue -> {
            Object valueObj = PropertyValueUtils.parseStr(properyValue.getValueStr(), properyValue.getType(), properyValue.getCode());
            valueMap.putIfAbsent(properyValue.getCode(), valueObj);
        });
        return valueMap;
    }

    private List<PropertyDef> filtePropertyDef(IExtendable value) {
        if (CollectionUtils.isEmpty(value.getPropertyDefList())) {
            return null;
        }
        List<Field> primitiveFieldList = ClassReflectionUtils.getPrimitiveField(value.getClass());
        List<PropertyDef> proDefList = value.getPropertyDefList().stream().filter(proDef -> primitiveFieldList.stream().noneMatch(field -> field.getName().equals(proDef.getCode()))).collect(Collectors.toList());
        return proDefList;
    }

    private void completePropertyValue(IExtendable value, List<PropertyDef> proDefList) {
        if (CollectionUtils.isEmpty(proDefList)) {
            return;
        }
        List<PropertyValue> absentValueList = proDefList.stream().map(preDef -> {
            Optional<PropertyValue> proValueOpl = value.getPropertyValueList().stream().filter(proValue -> preDef.getCode().equals(proValue.getCode())).findAny();
            return proValueOpl.orElseGet(() -> preDef.buildValue());
        }).collect(Collectors.toList());
        value.setPropertyValueList(absentValueList);
    }

    private Map<String, Object> setPrimitiveFieldIntoMap(Map<String, Object> valueMap, IExtendable value) {
        List<Field> primitiveFieldList = ClassReflectionUtils.getPrimitiveField(value.getClass());
        primitiveFieldList.stream().filter(field -> !this.ignoreList().contains(field.getName())).forEach(field -> {
            try {
                Object fieldValue = ReflectUtils.getValue((Object)value, (String)field.getName());
                valueMap.put(field.getName(), fieldValue);
            }
            catch (IllegalArgumentException e) {
                this.logger.error(String.format("\u5e8f\u5217\u5316\u5b57\u6bb5field\u5931\u8d25\uff0c[%s]", field.getName()), (Throwable)e);
                throw new RuntimeException(e);
            }
        });
        return valueMap;
    }
}

