/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.InquirySupplier;
import com.els.base.inquiry.entity.TemplateConf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SelectSupPricingCommand
extends AbstractInquiryCommand<Map<String, Object>> {
    private List<String> supplierIds;
    private String purOrderId;
    private TemplateConf templateConf;

    public SelectSupPricingCommand(List<String> companyIds, String purOrderId) {
        this.supplierIds = companyIds;
        this.purOrderId = purOrderId;
    }

    @Override
    public Map<String, Object> execute(InquiryCommandInvoker invoker) {
        ArrayList itemLists = new ArrayList();
        ArrayList<Map<String, Object>> companyList = new ArrayList<Map<String, Object>>();
        for (String id : this.supplierIds) {
            Map<String, Object> companyMap = this.getCompanyMap(id);
            companyList.add(companyMap);
            InquirySupOrderExample inquirySupOrderExample = new InquirySupOrderExample();
            inquirySupOrderExample.createCriteria().andPurOrderIdEqualTo(this.purOrderId).andSupTempCompanyIdEqualTo(id);
            InquirySupOrder supOrder = (InquirySupOrder)invoker.getInquirySupOrderService().queryAllObjByExample(inquirySupOrderExample).get(0);
            this.templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(supOrder.getTemplateId());
            supOrder.setTemplateConf(this.templateConf);
            List itemList = this.templateConf.getOrderItemService().queryBySupOrderId(supOrder.getId());
            itemLists.addAll(itemList);
        }
        Map<String, List<IOrderItem>> materialPrice = itemLists.stream().collect(Collectors.groupingBy(IOrderItem::getMaterialDesc));
        List mapList = materialPrice.keySet().stream().map(materialDesc -> this.transfer((String)materialDesc, (List)materialPrice.get(materialDesc))).collect(Collectors.toList());
        HashMap<String, Object> materialAndPrice = new HashMap<String, Object>();
        materialAndPrice.put("tableKey", companyList);
        materialAndPrice.put("tableValue", mapList);
        return materialAndPrice;
    }

    private Map<String, Object> getCompanyMap(String id) {
        HashMap<String, Object> companyMap = new HashMap<String, Object>();
        InquirySupplier inquirySupplier = (InquirySupplier)this.invoker.getInquirySupplierService().queryObjById(id);
        companyMap.put("supCompanyId", inquirySupplier.getId());
        companyMap.put("supCompanySrmCode", inquirySupplier.getSupCompanySrmCode());
        companyMap.put("supCompanyName", inquirySupplier.getSupCompanyName());
        return companyMap;
    }

    private Map<String, Object> transfer(String materialDesc, List<IOrderItem> iOrderItems) {
        if (CollectionUtils.isEmpty(iOrderItems)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (IOrderItem iOrderItem : iOrderItems) {
            map.put("materialDesc", materialDesc);
            if (StringUtils.isNotBlank((String)iOrderItem.getMaterialCode())) {
                map.put("materialCode", iOrderItem.getMaterialCode());
            }
            map.put(iOrderItem.getSupTempCompanyId(), iOrderItem.getUntaxedUnitPrice());
        }
        return map;
    }
}

