/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.utils;

import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.json.DetailDeSerializer;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.json.JsonUtils;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class BiddingContentDeSerializer
extends JsonDeserializer<BiddingContent> {
    protected static TplOrderItemDetailService tplOrderItemDetailService = (TplOrderItemDetailService)SpringContextHolder.getOneBean(TplOrderItemDetailService.class);
    protected static TplMouldDetailService tplMouldDetailService = (TplMouldDetailService)SpringContextHolder.getOneBean(TplMouldDetailService.class);
    private String itemsJson;
    private String mouldJson;

    public BiddingContent deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        BiddingContent content = new BiddingContent();
        ObjectNode objectNode = (ObjectNode)p.readValueAsTree();
        JsonNode valueMatter = objectNode.get("biddingOfferMatterList");
        JsonNode valueModel = objectNode.get("biddingOfferModelList");
        JsonNode valueOther = objectNode.get("biddingOfferOtherList");
        List<BiddingOffer> listMatter = this.deserialize(valueMatter);
        content.setBiddingOfferMatterList(listMatter);
        List<BiddingOffer> listModel = this.deserialize(valueModel);
        content.setBiddingOfferModelList(listModel);
        List<BiddingOffer> listOther = this.deserialize(valueOther);
        content.setBiddingOfferOtherList(listOther);
        Iterator fieldNamesIterator = objectNode.fieldNames();
        while (fieldNamesIterator.hasNext()) {
            String fieldName = (String)fieldNamesIterator.next();
            JsonNode value = objectNode.get(fieldName);
            if ("biddingOfferMatterList".equals(fieldName) || "biddingOfferModelList".equals(fieldName) || "biddingOfferOtherList".equals(fieldName)) continue;
            if ("biddingContentMatterList".equals(fieldName)) {
                List biddingContentMatterList = (List)JsonUtils.convertCollection((String)value.toString(), List.class, null, (Class[])new Class[]{BiddingContentMatter.class});
                content.setBiddingContentMatterList(biddingContentMatterList);
                continue;
            }
            if ("biddingContentModelList".equals(fieldName)) {
                List biddingContentModelList = (List)JsonUtils.convertCollection((String)value.toString(), List.class, null, (Class[])new Class[]{BiddingContentModel.class});
                content.setBiddingContentModelList(biddingContentModelList);
                continue;
            }
            if ("biddingContentOtherList".equals(fieldName)) {
                List biddingContentOtherList = (List)JsonUtils.convertCollection((String)value.toString(), List.class, null, (Class[])new Class[]{BiddingContentOther.class});
                content.setBiddingContentOtherList(biddingContentOtherList);
                continue;
            }
            Field field = null;
            try {
                field = BiddingContent.class.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            if (!StringUtils.isNotBlank((String)value.toString())) continue;
            try {
                ReflectUtils.setValue((Object)content, (String)fieldName, (Object)JsonUtils.convertValue((String)value.toString(), field.getType()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    private List<BiddingOffer> deserialize(JsonNode value) throws JsonParseException, JsonMappingException, IOException {
        if (value == null || !value.isArray()) {
            return null;
        }
        ArrayNode arrayNode = (ArrayNode)value;
        if (arrayNode.size() == 0) {
            return null;
        }
        ArrayList<BiddingOffer> list = new ArrayList<BiddingOffer>();
        for (int i = 0; i < arrayNode.size(); ++i) {
            JsonNode itemNode = arrayNode.get(i);
            BiddingOffer item = this.deserializeItem(itemNode);
            list.add(item);
        }
        return list;
    }

    private BiddingOffer deserializeItem(JsonNode objectNode1) throws JsonParseException, JsonMappingException, IOException {
        ObjectNode objectNode = (ObjectNode)objectNode1;
        JsonNode orderItemDetailNode = objectNode.get("orderItemDetail");
        JsonNode mouldItemDetailNode = objectNode.get("mouldDetail");
        objectNode.remove("orderItemDetail");
        objectNode.remove("mouldDetail");
        BiddingOffer biddingOffer = (BiddingOffer)JsonUtils.convertValue((String)objectNode.toString(), BiddingOffer.class);
        TplOrderItemDetail tplOrderItemDetail = (TplOrderItemDetail)tplOrderItemDetailService.queryObjById((Object)biddingOffer.getCostAnalysisId());
        TplMouldDetail tplMouldDetail = (TplMouldDetail)tplMouldDetailService.queryObjById((Object)biddingOffer.getCostAnalysisId());
        String jsonOrderItem = orderItemDetailNode.toString();
        String jsonMould = mouldItemDetailNode.toString();
        IOrderItemDetail orderItemDetail = null;
        IMouldDetail mouldDetail = null;
        try {
            if (tplOrderItemDetail != null) {
                DetailDeSerializer orderItemDeSerializer = new DetailDeSerializer(tplOrderItemDetail.getOrderItemDetailClass());
                orderItemDetail = (IOrderItemDetail)orderItemDeSerializer.serializer(jsonOrderItem);
                biddingOffer.setOrderItemDetail(orderItemDetail);
            }
            if (tplMouldDetail != null) {
                DetailDeSerializer mouldDeSerializer = new DetailDeSerializer(tplMouldDetail.getMouldDetailClass());
                mouldDetail = (IMouldDetail)mouldDeSerializer.serializer(jsonMould);
                biddingOffer.setMouldDetail(mouldDetail);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return biddingOffer;
    }
}

