/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.bidding.dao.BiddingOfferMapper;
import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentMatterExample;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentModelExample;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingContentOtherExample;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingMatterStepSup;
import com.els.base.bidding.entity.BiddingMatterStepSupExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.SaveBidInfoVo;
import com.els.base.bidding.entity.vo.TemporaryCodeReducedRate;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingContentMatterService;
import com.els.base.bidding.service.BiddingContentModelService;
import com.els.base.bidding.service.BiddingContentOtherService;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.BaseService;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.IMouldDetailService;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyValueUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingOfferService")
public class BiddingOfferServiceImpl
implements BiddingOfferService {
    @Resource
    protected BiddingOfferMapper biddingOfferMapper;
    @Resource
    protected BiddingContentMatterService biddingContentMatterService;
    @Resource
    protected BiddingContentModelService biddingContentModelService;
    @Resource
    protected BiddingContentOtherService biddingContentOtherService;
    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected BiddingContentService biddingContentService;
    @Resource
    protected BiddingHeaderService biddingHeaderService;
    @Resource
    protected BiddingSupplierService biddingSupplierService;
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;
    @Resource
    protected TplMouldDetailService tplMouldDetailService;

    @Override
    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    public void addObj(BiddingOffer t) {
        this.biddingOfferMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingOfferMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    public void modifyObj(BiddingOffer t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingOfferMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"biddingOffer"}, keyGenerator="redisKeyGenerator")
    public BiddingOffer queryObjById(String id) {
        return this.biddingOfferMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"biddingOffer"}, keyGenerator="redisKeyGenerator")
    public List<BiddingOffer> queryAllObjByExample(BiddingOfferExample example) {
        return this.biddingOfferMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"biddingOffer"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingOffer> queryObjByPage(BiddingOfferExample example) {
        PageView<BiddingOffer> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingOfferMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    @Transactional
    public void saveUnitPrice(BiddingBaseVo biddingBaseVo) throws InstantiationException, IllegalAccessException {
        Company supCompany = biddingBaseVo.getCompany();
        User supUser = biddingBaseVo.getUser();
        String handleType = biddingBaseVo.getHandleType();
        BiddingContent biddingContent = biddingBaseVo.getBiddingContent();
        if (biddingContent != null) {
            this.updateBiddingOfferPrice(biddingContent, supCompany, supUser, handleType);
            if ("send".equals(handleType)) {
                BiddingSupplier biddingSupplier = new BiddingSupplier();
                biddingSupplier.setLastUpdateTime(new Date());
                biddingSupplier.setLastUpdateUser(supUser.getNickName());
                biddingSupplier.setSupBidding("1");
                BiddingSupplierExample example = new BiddingSupplierExample();
                BiddingSupplierExample.Criteria biddingCriteria = example.createCriteria();
                biddingCriteria.andBiddingNoEqualTo(biddingBaseVo.getBiddingHeader().getBiddingNo());
                biddingCriteria.andSupCompanyIdEqualTo(supCompany.getId());
                this.biddingSupplierService.modifyObjSup(biddingSupplier, example);
            }
        }
    }

    private boolean isUpdateOfferPrice(BiddingOffer biddingOffer) {
        biddingOffer.getEffectiveNumber();
        biddingOffer.getRestEffectiveNumber();
        return Integer.valueOf(biddingOffer.getRestEffectiveNumber() == null ? "0" : biddingOffer.getRestEffectiveNumber()) > 0;
    }

    private void updatebiddingOfferRestEffectiveNumber(BiddingOffer BiddingOffer2, String requirementTypeCode, Company supCompany) {
        BiddingOfferExample example = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = example.createCriteria();
        criteria.andBiddingNoEqualTo(BiddingOffer2.getBiddingNo());
        criteria.andSupCompanyIdEqualTo(supCompany.getId());
        criteria.andBiddingRoundsNumberEqualTo(BiddingOffer2.getBiddingRoundsNumber());
        criteria.andRequirementTypeCodeEqualTo(requirementTypeCode);
        List<BiddingOffer> biddingOfferMatterList = this.biddingOfferMapper.selectByExample(example);
        for (BiddingOffer biddingOffer : biddingOfferMatterList) {
            BiddingOffer offer = new BiddingOffer();
            offer.setId(biddingOffer.getId());
            offer.setRestEffectiveNumber(String.valueOf(Integer.valueOf(biddingOffer.getRestEffectiveNumber()) - 1));
            this.biddingOfferMapper.updateByPrimaryKeySelective(offer);
        }
    }

    private void updateBiddingOfferPrice(BiddingContent biddingContent, Company supCompany, User supUser, String handleType) throws InstantiationException, IllegalAccessException {
        if (biddingContent != null) {
            boolean flag;
            BiddingOffer biddingOffer;
            if (CollectionUtils.isNotEmpty(biddingContent.getBiddingOfferMatterList())) {
                List<BiddingOffer> biddingOfferMatterList = biddingContent.getBiddingOfferMatterList();
                biddingOffer = new BiddingOffer();
                biddingOffer.setEffectiveNumber(biddingOfferMatterList.get(0).getEffectiveNumber());
                biddingOffer.setRestEffectiveNumber(biddingOfferMatterList.get(0).getRestEffectiveNumber());
                flag = this.isUpdateOfferPrice(biddingOffer);
                if (flag) {
                    this.updateBiddingOfferMatter(biddingOfferMatterList, supCompany, supUser, handleType);
                    if ("send".equals(handleType)) {
                        this.updatebiddingOfferRestEffectiveNumber(biddingOfferMatterList.get(0), "material", supCompany);
                    }
                } else {
                    throw new CommonException("\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4fdd\u5b58\u5931\u8d25", "finish_status", "\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u4ef7\uff01");
                }
            }
            if (CollectionUtils.isNotEmpty(biddingContent.getBiddingOfferModelList())) {
                List<BiddingOffer> biddingOfferModelList = biddingContent.getBiddingOfferModelList();
                biddingOffer = new BiddingOffer();
                biddingOffer.setEffectiveNumber(biddingOfferModelList.get(0).getEffectiveNumber());
                biddingOffer.setRestEffectiveNumber(biddingOfferModelList.get(0).getRestEffectiveNumber());
                flag = this.isUpdateOfferPrice(biddingOffer);
                if (flag) {
                    this.updateBiddingOffer(biddingOfferModelList, supCompany, supUser, "die", handleType);
                    if ("send".equals(handleType)) {
                        this.updatebiddingOfferRestEffectiveNumber(biddingOfferModelList.get(0), "die", supCompany);
                    }
                } else {
                    throw new CommonException("\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4fdd\u5b58\u5931\u8d25", "finish_status", "\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u4ef7\uff01");
                }
            }
            if (CollectionUtils.isNotEmpty(biddingContent.getBiddingOfferOtherList())) {
                List<BiddingOffer> biddingOfferOtherList = biddingContent.getBiddingOfferOtherList();
                biddingOffer = new BiddingOffer();
                biddingOffer.setEffectiveNumber(biddingOfferOtherList.get(0).getEffectiveNumber());
                biddingOffer.setRestEffectiveNumber(biddingOfferOtherList.get(0).getRestEffectiveNumber());
                flag = this.isUpdateOfferPrice(biddingOffer);
                if (flag) {
                    this.updateBiddingOffer(biddingOfferOtherList, supCompany, supUser, "device", handleType);
                    if ("send".equals(handleType)) {
                        this.updatebiddingOfferRestEffectiveNumber(biddingOfferOtherList.get(0), "device", supCompany);
                    }
                } else {
                    throw new CommonException("\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4fdd\u5b58\u5931\u8d25", "finish_status", "\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u4ef7\uff01");
                }
            }
        }
    }

    private void updateBiddingOfferMatter(List<BiddingOffer> BiddingOfferList, Company supCompany, User supUser, String handleType) throws InstantiationException, IllegalAccessException {
        for (BiddingOffer biddingOfferMatter : BiddingOfferList) {
            BiddingOffer offer = new BiddingOffer();
            offer.setId(biddingOfferMatter.getId());
            offer.setPromiseReducedRate(biddingOfferMatter.getPromiseReducedRate());
            if ("save".equals(handleType)) {
                offer.setTempOfferUnitPrice(biddingOfferMatter.getTempOfferUnitPrice());
                offer.setTempOfferSetPrice(biddingOfferMatter.getTempOfferSetPrice());
            } else if ("send".equals(handleType)) {
                offer.setTempOfferUnitPrice(biddingOfferMatter.getTempOfferUnitPrice());
                offer.setTempOfferSetPrice(biddingOfferMatter.getTempOfferSetPrice());
                if (StringUtils.isNotBlank((String)biddingOfferMatter.getOfferUnitPrice())) {
                    Assert.isNotBlank(biddingOfferMatter.getTaxCode(), "\u7269\u6599\u4e2d\u5df2\u586b\u5199\u62a5\u4ef7\u5355\u4ef7\u7684\u6807\u7684\uff0c\u8bf7\u9009\u62e9\u5176\u7a0e\u7801");
                    Assert.isNotNull(biddingOfferMatter.getPriceUnit(), "\u7269\u6599\u4e2d\u5df2\u586b\u5199\u62a5\u4ef7\u5355\u4ef7\u7684\u6807\u7684\uff0c\u4ef7\u683c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    Assert.isNotNull(biddingOfferMatter.getPriceEffectiveFrom(), "\u7269\u6599\u4e2d\u5df2\u586b\u5199\u62a5\u4ef7\u5355\u4ef7\u7684\u6807\u7684\uff0c\u8bf7\u9009\u62e9\u5176\u4ef7\u683c\u6709\u6548\u671f");
                    Assert.isNotNull(biddingOfferMatter.getPriceEffectiveTo(), "\u7269\u6599\u4e2d\u5df2\u586b\u5199\u62a5\u4ef7\u5355\u4ef7\u7684\u6807\u7684\uff0c\u8bf7\u9009\u62e9\u5176\u4ef7\u683c\u6709\u6548\u671f");
                }
                offer.setOfferUnitPrice(biddingOfferMatter.getOfferUnitPrice());
                offer.setOfferSetPrice(biddingOfferMatter.getOfferSetPrice());
            }
            offer.setFactBarnd(biddingOfferMatter.getFactBarnd());
            offer.setFactSpec(biddingOfferMatter.getFactSpec());
            offer.setFactModel(biddingOfferMatter.getFactModel());
            offer.setLastUpdateUser(supUser.getNickName());
            offer.setLastUpdateTime(new Date());
            offer.setPriceUnit(biddingOfferMatter.getPriceUnit());
            offer.setTaxCode(biddingOfferMatter.getTaxCode());
            offer.setPriceEffectiveFrom(biddingOfferMatter.getPriceEffectiveFrom());
            offer.setPriceEffectiveTo(biddingOfferMatter.getPriceEffectiveTo());
            this.biddingOfferMapper.updateByPrimaryKeySelective(offer);
            List<BiddingMatterStepSup> biddingMatterStepSupList = biddingOfferMatter.getBiddingMatterStepSupList();
            if (CollectionUtils.isNotEmpty(biddingMatterStepSupList)) {
                for (BiddingMatterStepSup biddingMatterStepSup : biddingMatterStepSupList) {
                    BiddingMatterStepSup mstepsup = new BiddingMatterStepSup();
                    mstepsup.setId(biddingMatterStepSup.getId());
                    mstepsup.setOfferUnitPrice(biddingMatterStepSup.getOfferUnitPrice());
                    mstepsup.setOfferSetPrice(biddingMatterStepSup.getOfferSetPrice());
                    mstepsup.setLastUpdateUser(supUser.getNickName());
                    mstepsup.setLastUpdateTime(new Date());
                    this.biddingMatterStepSupService.modifyObj(mstepsup);
                }
            }
            if ("send".equals(handleType)) {
                this.updateCurrentRanking(biddingOfferMatter, "material");
            }
            if (!StringUtils.isNotBlank((String)biddingOfferMatter.getCostAnalysisId())) continue;
            this.updateMaterialAcostAnalysis(biddingOfferMatter);
        }
    }

    private void updateMaterialAcostAnalysis(BiddingOffer biddingOfferMatter) throws InstantiationException, IllegalAccessException {
        TplOrderItemDetail tpl = (TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId());
        IOrderItemDetailService service = tpl.getOrderItemDetailService();
        ArrayList<String> orderItemIdList = new ArrayList<String>();
        orderItemIdList.add(biddingOfferMatter.getId());
        service.deleteByOrderItemIds(orderItemIdList);
        ArrayList<IOrderItemDetail> detailList = new ArrayList<IOrderItemDetail>();
        IOrderItemDetail detail = biddingOfferMatter.getOrderItemDetail();
        detail.setOrderItemId(biddingOfferMatter.getId());
        detail.setTemplateId(biddingOfferMatter.getCostAnalysisId());
        detail.setMaterialCode(biddingOfferMatter.getProjectNo() == null ? "" : biddingOfferMatter.getProjectNo());
        detail.setMaterialDesc(biddingOfferMatter.getProjectDesc() == null ? "" : biddingOfferMatter.getProjectDesc());
        detailList.add(detail);
        service.addAll(detailList);
    }

    private void updateMouldAcostAnalysis(BiddingOffer biddingOfferMatter) {
        IMouldDetailService service = ((TplMouldDetail)this.tplMouldDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId())).getMouldDetailService();
        ArrayList<String> orderItemIdList = new ArrayList<String>();
        orderItemIdList.add(biddingOfferMatter.getId());
        service.deleteByMouldIdList(orderItemIdList);
        ArrayList<IMouldDetail> mouldDetailList = new ArrayList<IMouldDetail>();
        IMouldDetail mouldDetail = biddingOfferMatter.getMouldDetail();
        mouldDetail.setMouldId(biddingOfferMatter.getId());
        mouldDetail.setTemplateId(biddingOfferMatter.getCostAnalysisId());
        mouldDetail.setSupCompanyId(biddingOfferMatter.getSupCompanyId());
        mouldDetail.setSupCompanyName(biddingOfferMatter.getSupCompanyName());
        mouldDetail.setSupCompanySapCode(biddingOfferMatter.getSupCompanySapCode() == null ? "" : biddingOfferMatter.getSupCompanySapCode());
        mouldDetail.setSupCompanySrmCode(biddingOfferMatter.getSupCompanySrmCode() == null ? "" : biddingOfferMatter.getSupCompanySrmCode());
        mouldDetail.setPurOrderId(biddingOfferMatter.getBiddingNo());
        mouldDetail.setSupOrderId(biddingOfferMatter.getBiddingNo());
        mouldDetail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(mouldDetail));
        mouldDetailList.add(mouldDetail);
        service.addAll(mouldDetailList);
    }

    private void updateCurrentRanking(BiddingOffer BiddingOffer2, String requirementTypeCode) {
        BiddingOfferExample matterExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria matterCriteria = matterExample.createCriteria();
        matterCriteria.andBiddingNoEqualTo(BiddingOffer2.getBiddingNo());
        switch (requirementTypeCode) {
            case "material": {
                matterCriteria.andMatterIdEqualTo(BiddingOffer2.getMatterId());
                break;
            }
            case "die": {
                matterCriteria.andModelIdEqualTo(BiddingOffer2.getModelId());
                break;
            }
            case "device": {
                matterCriteria.andOtherIdEqualTo(BiddingOffer2.getOtherId());
            }
        }
        matterCriteria.andBiddingRoundsNumberEqualTo(BiddingOffer2.getBiddingRoundsNumber());
        matterCriteria.andRequirementTypeCodeEqualTo(requirementTypeCode);
        matterCriteria.andOfferUnitPriceGreaterThan("0");
        List<BiddingOffer> biddingOfferMatterList = this.biddingOfferMapper.selectByExample(matterExample);
        Collections.sort(biddingOfferMatterList, new Comparator<BiddingOffer>(){

            @Override
            public int compare(BiddingOffer o1, BiddingOffer o2) {
                return new BigDecimal(o1.getOfferUnitPrice() == null ? "0" : o1.getOfferUnitPrice()).compareTo(new BigDecimal(o2.getOfferUnitPrice() == null ? "0" : o2.getOfferUnitPrice()));
            }
        });
        int index = 1;
        int tamp = 0;
        HashSet<String> set = new HashSet<String>();
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferMatterList) && j < biddingOfferMatterList.size(); ++j) {
            BiddingOffer offerSort = new BiddingOffer();
            offerSort.setId(biddingOfferMatterList.get(j).getId());
            if (set.add(biddingOfferMatterList.get(j).getOfferUnitPrice())) {
                offerSort.setCurrentRanking(String.valueOf(index));
                tamp = index++;
            } else {
                offerSort.setCurrentRanking(String.valueOf(tamp));
            }
            this.biddingOfferMapper.updateByPrimaryKeySelective(offerSort);
        }
    }

    private void updateBiddingOffer(List<BiddingOffer> BiddingOfferList, Company supCompany, User supUser, String requirementTypeCode, String handleType) {
        for (BiddingOffer biddingOffer : BiddingOfferList) {
            BiddingOffer offer = new BiddingOffer();
            offer.setId(biddingOffer.getId());
            if ("save".equals(handleType)) {
                offer.setTempOfferUnitPrice(biddingOffer.getTempOfferUnitPrice());
                offer.setTempOfferSetPrice(biddingOffer.getTempOfferSetPrice());
            } else if ("send".equals(handleType)) {
                if (StringUtils.isNotBlank((String)biddingOffer.getOfferUnitPrice())) {
                    Assert.isNotBlank(biddingOffer.getTaxCode(), "\u5df2\u586b\u5199\u62a5\u4ef7\u5355\u4ef7\u7684\u6807\u7684\uff0c\u8bf7\u9009\u62e9\u5176\u7a0e\u7801");
                    Assert.isNotNull(biddingOffer.getPriceUnit(), "\u5df2\u586b\u5199\u62a5\u4ef7\u5355\u4ef7\u7684\u6807\u7684\uff0c\u4ef7\u683c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    Assert.isNotNull(biddingOffer.getPriceEffectiveFrom(), "\u5df2\u586b\u5199\u62a5\u4ef7\u5355\u4ef7\u7684\u6807\u7684\uff0c\u8bf7\u9009\u62e9\u5176\u4ef7\u683c\u6709\u6548\u671f");
                    Assert.isNotNull(biddingOffer.getPriceEffectiveTo(), "\u5df2\u586b\u5199\u62a5\u4ef7\u5355\u4ef7\u7684\u6807\u7684\uff0c\u8bf7\u9009\u62e9\u5176\u4ef7\u683c\u6709\u6548\u671f");
                }
                offer.setOfferUnitPrice(biddingOffer.getOfferUnitPrice());
                offer.setOfferSetPrice(biddingOffer.getOfferSetPrice());
                offer.setTempOfferUnitPrice(biddingOffer.getTempOfferUnitPrice());
                offer.setTempOfferSetPrice(biddingOffer.getTempOfferSetPrice());
            }
            offer.setLastUpdateUser(supUser.getNickName());
            offer.setLastUpdateTime(new Date());
            offer.setPriceUnit(biddingOffer.getPriceUnit());
            offer.setTaxCode(biddingOffer.getTaxCode());
            offer.setPriceEffectiveFrom(biddingOffer.getPriceEffectiveFrom());
            offer.setPriceEffectiveTo(biddingOffer.getPriceEffectiveTo());
            this.biddingOfferMapper.updateByPrimaryKeySelective(offer);
            if ("send".equals(handleType)) {
                this.updateCurrentRanking(biddingOffer, requirementTypeCode);
            }
            if (!"die".equals(requirementTypeCode) || !StringUtils.isNotBlank((String)biddingOffer.getCostAnalysisId())) continue;
            this.updateMouldAcostAnalysis(biddingOffer);
        }
    }

    @Override
    public List<BiddingOffer> findBidInfo(String biddingNo, String type, String isBidding, String currentRound) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.setOrderByClause(" SUP_COMPANY_SRM_CODE DESC,PROJECT_DESC DESC,MATERIAL_DEVEL ASC ");
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type).andBiddingRoundsNumberEqualTo(currentRound);
        if (StringUtils.isNotBlank((String)isBidding)) {
            criteria.andIsBiddingEqualTo(isBidding);
        }
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        List<String> stringsCodeList = this.getStringsCode(biddingNo, type);
        for (int i = 0; CollectionUtils.isNotEmpty(stringsCodeList) && i < stringsCodeList.size(); ++i) {
            ArrayList<BiddingOffer> sameProjectNoList = new ArrayList<BiddingOffer>();
            block11: for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); ++j) {
                BiddingOffer biddingOffer = biddingOfferList.get(j);
                if (type.equals("material")) {
                    Object example = new BiddingMatterStepSupExample();
                    ((BiddingMatterStepSupExample)example).createCriteria().andBiddingOfferIdEqualTo(biddingOffer.getId()).andBiddingRoundsNumberEqualTo(currentRound);
                    ((BiddingMatterStepSupExample)example).setOrderByClause(" QUANTITY_START ASC");
                    List<BiddingMatterStepSup> biddingMatterStepSups = this.biddingMatterStepSupService.queryAllObjByExample(example);
                    biddingOffer.setBiddingMatterStepSupList(biddingMatterStepSups);
                    BigDecimal offerUnitPrice = biddingOffer.getOfferUnitPrice() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getOfferUnitPrice());
                    BigDecimal biddingQuantity = biddingOffer.getBiddingQuantity() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getBiddingQuantity());
                    biddingOffer.setSupplierQuotedPrice(offerUnitPrice.multiply(biddingQuantity));
                }
                switch (type) {
                    case "material": {
                        if (!stringsCodeList.get(i).equals(biddingOffer.getMatterId())) continue block11;
                        sameProjectNoList.add(biddingOffer);
                        continue block11;
                    }
                    case "die": {
                        if (!stringsCodeList.get(i).equals(biddingOffer.getModelId())) continue block11;
                        sameProjectNoList.add(biddingOffer);
                        continue block11;
                    }
                    case "device": {
                        if (!stringsCodeList.get(i).equals(biddingOffer.getOtherId())) continue block11;
                        sameProjectNoList.add(biddingOffer);
                    }
                }
            }
            ArrayList<String> maxDevelList = new ArrayList<String>();
            ArrayList<BiddingOffer> maxDevelOffers = new ArrayList<BiddingOffer>();
            for (BiddingOffer biddingOffer : sameProjectNoList) {
                if (StringUtils.isNotBlank((String)((BiddingOffer)sameProjectNoList.get(0)).getMaterialDevel()) && !((BiddingOffer)sameProjectNoList.get(0)).getMaterialDevel().equals(biddingOffer.getMaterialDevel())) continue;
                maxDevelList.add(biddingOffer.getId());
                maxDevelOffers.add(biddingOffer);
            }
            if (CollectionUtils.isNotEmpty(maxDevelList) && maxDevelList.size() == 1) {
                for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); ++j) {
                    BiddingOffer biddingOffer = biddingOfferList.get(j);
                    if (!biddingOffer.getId().equals(maxDevelList.get(0))) continue;
                    biddingOffer.setIsGroomMaterial("1");
                    break;
                }
            }
            if (!CollectionUtils.isEmpty(maxDevelList) && maxDevelList.size() <= 1) continue;
            ArrayList<BiddingOffer> reducedRateOffers = new ArrayList<BiddingOffer>();
            if (CollectionUtils.isEmpty(maxDevelList)) {
                reducedRateOffers.addAll(sameProjectNoList);
            } else {
                reducedRateOffers.addAll(maxDevelOffers);
            }
            ArrayList<Iterator<BiddingOffer>> reducedRateList = new ArrayList<Iterator<BiddingOffer>>();
            for (BiddingOffer offer : reducedRateOffers) {
                Iterator<BiddingOffer> company = (Company)this.companyService.queryObjById(offer.getSupCompanyId());
                reducedRateList.add(company);
            }
            ArrayList<String> maxIdList = new ArrayList<String>();
            ArrayList<BiddingOffer> maxReducedRateOffers = new ArrayList<BiddingOffer>();
            for (Company company : reducedRateList) {
                maxIdList.add(company.getId());
            }
            if (CollectionUtils.isNotEmpty(maxIdList)) {
                for (BiddingOffer biddingOffer : biddingOfferList) {
                    if (maxIdList.size() == 1 && maxIdList.contains(biddingOffer.getSupCompanyId())) {
                        biddingOffer.setIsGroomMaterial("1");
                        maxReducedRateOffers.add(biddingOffer);
                    }
                    if (maxIdList.size() <= 1 || !maxIdList.contains(biddingOffer.getSupCompanyId())) continue;
                    maxReducedRateOffers.add(biddingOffer);
                }
            }
            if (!CollectionUtils.isEmpty(maxIdList) && maxIdList.size() <= 1) continue;
            ArrayList<BiddingOffer> priceOffers = new ArrayList<BiddingOffer>();
            if (CollectionUtils.isEmpty(maxIdList)) {
                priceOffers.addAll(sameProjectNoList);
            } else {
                priceOffers.addAll(maxReducedRateOffers);
            }
            Collections.sort(priceOffers, new Comparator<BiddingOffer>(){

                @Override
                public int compare(BiddingOffer o1, BiddingOffer o2) {
                    if (StringUtils.isBlank((String)o1.getOfferUnitPrice())) {
                        return 1;
                    }
                    if (StringUtils.isBlank((String)o2.getOfferUnitPrice())) {
                        return -1;
                    }
                    return new BigDecimal(o1.getOfferUnitPrice()).compareTo(new BigDecimal(o2.getOfferUnitPrice()));
                }
            });
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BiddingOffer offer : sameProjectNoList) {
                if (StringUtils.isBlank((String)offer.getOfferUnitPrice()) || ((BiddingOffer)priceOffers.get(0)).getOfferUnitPrice().compareTo(offer.getOfferUnitPrice()) != 0) continue;
                arrayList.add(offer.getId());
            }
            if (!CollectionUtils.isNotEmpty(arrayList)) continue;
            for (BiddingOffer offer : biddingOfferList) {
                if (!arrayList.contains(offer.getId())) continue;
                offer.setIsGroomMaterial("1");
            }
        }
        for (BiddingOffer offer : biddingOfferList) {
            BaseService service;
            if (!StringUtils.isNotBlank((String)offer.getCostAnalysisId())) continue;
            if (type.equals("material")) {
                service = ((TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById(offer.getCostAnalysisId())).getOrderItemDetailService();
                offer.setOrderItemDetail(service.queryObjByOrderItemId(offer.getId()));
                continue;
            }
            if (!type.equals("die")) continue;
            service = ((TplMouldDetail)this.tplMouldDetailService.queryObjById(offer.getCostAnalysisId())).getMouldDetailService();
            offer.setMouldDetail(service.queryByMouldId(offer.getId()));
        }
        return biddingOfferList;
    }

    @Override
    public List<BiddingOffer> findBidInfoSup(String biddingNo, String type, String isBidding, String currentRound, User user, Company company) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.setOrderByClause(" SUP_COMPANY_SRM_CODE DESC,PROJECT_DESC DESC,MATERIAL_DEVEL ASC ");
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type).andBiddingRoundsNumberEqualTo(currentRound).andSupCompanyIdEqualTo(company.getId());
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); ++j) {
            BiddingOffer biddingOffer = biddingOfferList.get(j);
            if (type.equals(type)) {
                BiddingMatterStepSupExample example = new BiddingMatterStepSupExample();
                example.createCriteria().andBiddingOfferIdEqualTo(biddingOffer.getId()).andBiddingRoundsNumberEqualTo(currentRound).andSupCompanyIdEqualTo(company.getId());
                List<BiddingMatterStepSup> biddingMatterStepSups = this.biddingMatterStepSupService.queryAllObjByExample(example);
                biddingOffer.setBiddingMatterStepSupList(biddingMatterStepSups);
                BigDecimal offerUnitPrice = biddingOffer.getOfferUnitPrice() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getOfferUnitPrice());
                BigDecimal quantity = biddingOffer.getQuantity() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getQuantity());
                biddingOffer.setOfferSetPrice(offerUnitPrice.multiply(quantity).toString());
            }
            BiddingHeaderExample headerExample = new BiddingHeaderExample();
            headerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
            List biddingHeaders = this.biddingHeaderService.queryAllObjByExample(headerExample);
            String biddingSendBidder = ((BiddingHeader)biddingHeaders.get(0)).getBiddingSendBidder();
            if ("0".equals(biddingSendBidder)) {
                biddingOffer.setUnitPrice(BigDecimal.valueOf(-1L));
                biddingOffer.setAmount(BigDecimal.valueOf(-1L));
                continue;
            }
            if (!"1".equals(biddingSendBidder) || !"0".equals(biddingOffer.getIsBidding())) continue;
            biddingOffer.setUnitPrice(BigDecimal.valueOf(-1L));
            biddingOffer.setAmount(BigDecimal.valueOf(-1L));
        }
        return biddingOfferList;
    }

    private List<String> getStringsCode(String biddingNo, String type) {
        ArrayList<String> stringsCode = new ArrayList<String>();
        switch (type) {
            case "material": {
                BiddingContentMatterExample contentMatterExample = new BiddingContentMatterExample();
                contentMatterExample.createCriteria().andBiddingNoEqualTo(biddingNo);
                List biddingContentMatters = this.biddingContentMatterService.queryAllObjByExample(contentMatterExample);
                for (int j = 0; CollectionUtils.isNotEmpty(biddingContentMatters) && j < biddingContentMatters.size(); ++j) {
                    stringsCode.add(((BiddingContentMatter)biddingContentMatters.get(j)).getId());
                }
                break;
            }
            case "die": {
                BiddingContentModelExample contentModelExample = new BiddingContentModelExample();
                contentModelExample.createCriteria().andBiddingNoEqualTo(biddingNo);
                List biddingContentModels = this.biddingContentModelService.queryAllObjByExample(contentModelExample);
                for (int j = 0; CollectionUtils.isNotEmpty(biddingContentModels) && j < biddingContentModels.size(); ++j) {
                    stringsCode.add(((BiddingContentModel)biddingContentModels.get(j)).getId());
                }
                break;
            }
            case "device": {
                BiddingContentOtherExample contentOtherExample = new BiddingContentOtherExample();
                contentOtherExample.createCriteria().andBiddingNoEqualTo(biddingNo);
                List biddingContentOthers = this.biddingContentOtherService.queryAllObjByExample(contentOtherExample);
                for (int j = 0; CollectionUtils.isNotEmpty(biddingContentOthers) && j < biddingContentOthers.size(); ++j) {
                    stringsCode.add(((BiddingContentOther)biddingContentOthers.get(j)).getId());
                }
                break;
            }
        }
        return stringsCode;
    }

    @Override
    public void save(SaveBidInfoVo saveBidInfoVo, String saveOrSubmit) {
        boolean boo;
        List<BiddingOffer> biddingOfferList = saveBidInfoVo.getBiddingOfferList();
        List<TemporaryCodeReducedRate> codeReducedRates = saveBidInfoVo.getCodeReducedRates();
        if (CollectionUtils.isEmpty(biddingOfferList)) {
            throw new CommonException("\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u53ef\u64cd\u4f5c", "isNull", "\u6570\u636e");
        }
        for (int j = 0; j < biddingOfferList.size(); ++j) {
            BiddingOffer biddingOffer = biddingOfferList.get(j);
            if (biddingOfferList.get(0).getAllBidding().equals("0")) {
                if (CollectionUtils.isEmpty(codeReducedRates)) {
                    throw new CommonException("\u5168\u90e8\u6295\u6807\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e\u4e2d\u6807\u4f9b\u5e94\u5546", "most_set_bid_supplier");
                }
                biddingOffer.setBidShare("0");
                for (TemporaryCodeReducedRate temporaryCodeReducedRate : codeReducedRates) {
                    if (!temporaryCodeReducedRate.getTemporaryCode().equals(biddingOffer.getSupplierTemporaryCode())) continue;
                    biddingOffer.setBidShare(temporaryCodeReducedRate.getReducedRate());
                    biddingOffer.setIsBidding("1");
                }
            }
            if (StringUtils.isNotBlank((String)saveOrSubmit) && saveOrSubmit.equals("submit")) {
                biddingOffer.setIsSubmitBid("1");
            }
            this.biddingOfferMapper.updateByPrimaryKeySelective(biddingOffer);
        }
        BiddingContent biddingContent = saveBidInfoVo.getBiddingContent();
        if (biddingContent != null) {
            BiddingContent bidContent = new BiddingContent();
            bidContent.setId(biddingContent.getId());
            bidContent.setBidExplain(biddingContent.getBidExplain());
            this.biddingContentService.modifyObj(bidContent);
        }
        if (StringUtils.isNotBlank((String)saveOrSubmit) && saveOrSubmit.equals("submit") && (boo = this.isAllSetBidSupplier(biddingOfferList))) {
            BiddingHeaderExample headerExample = new BiddingHeaderExample();
            headerExample.createCriteria().andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo());
            List biddingHeaders = this.biddingHeaderService.queryAllObjByExample(headerExample);
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(((BiddingHeader)biddingHeaders.get(0)).getId());
            biddingHeader.setBiddingStatus(TenderStatusEumn.BIDOVER.getValue());
            biddingHeader.setBiddingAuditstatus("0");
            biddingHeader.setBidSubmitDate(new Date());
            this.biddingHeaderService.modifyObj(biddingHeader);
            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            supplierExample.createCriteria().andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo()).andSupBiddingStatusEqualTo(TenderStatusEumn.ISBID.getValue());
            supplierExample.or().andSupBiddingStatusEqualTo(TenderStatusEumn.INBID.getValue());
            List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample(supplierExample);
            for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
                BiddingSupplier biddingSupplier = new BiddingSupplier();
                biddingSupplier.setId(((BiddingSupplier)biddingSupplierList.get(i)).getId());
                biddingSupplier.setSupBiddingStatus(TenderStatusEumn.BIDOVER.getValue());
                this.biddingSupplierService.modifyObj(biddingSupplier);
            }
        }
    }

    private boolean isAllSetBidSupplier(List<BiddingOffer> biddingOfferList) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo()).andBiddingRoundsNumberEqualTo(biddingOfferList.get(0).getBiddingRoundsNumber());
        List<BiddingOffer> biddingOfferAllList = this.biddingOfferMapper.selectByExample(offerExample);
        ArrayList<String> biddingOfferMatterList = new ArrayList<String>();
        ArrayList<String> biddingOfferModelList = new ArrayList<String>();
        ArrayList<String> biddingOfferOtherList = new ArrayList<String>();
        ArrayList<String> booleanList = new ArrayList<String>();
        for (BiddingOffer biddingOffer : biddingOfferAllList) {
            if (biddingOffer.getRequirementTypeCode().equals("material")) {
                biddingOfferMatterList.add(biddingOffer.getIsSubmitBid());
                continue;
            }
            if (biddingOffer.getRequirementTypeCode().equals("die")) {
                biddingOfferModelList.add(biddingOffer.getIsSubmitBid());
                continue;
            }
            biddingOfferOtherList.add(biddingOffer.getIsSubmitBid());
        }
        if (CollectionUtils.isEmpty(biddingOfferMatterList) || biddingOfferMatterList.contains("1")) {
            booleanList.add("Y");
        } else {
            booleanList.add("N");
        }
        if (CollectionUtils.isEmpty(biddingOfferModelList) || biddingOfferModelList.contains("1")) {
            booleanList.add("Y");
        } else {
            booleanList.add("N");
        }
        if (CollectionUtils.isEmpty(biddingOfferOtherList) || biddingOfferOtherList.contains("1")) {
            booleanList.add("Y");
        } else {
            booleanList.add("N");
        }
        return Collections.frequency(booleanList, "Y") == booleanList.size();
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); ++j) {
            this.biddingOfferMapper.deleteByPrimaryKey(biddingOfferList.get(j).getId());
        }
    }

    @Override
    public void deleteBySupCompanyId(String biddingNo, String supCompanyId) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupCompanyIdEqualTo(supCompanyId);
        this.biddingOfferMapper.deleteByExample(offerExample);
    }

    @Override
    public List<TemporaryCodeReducedRate> findBidSupplier(String biddingNo, String type, String currentRound) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type).andBiddingRoundsNumberEqualTo(currentRound).andBidShareGreaterThan("0").andBidShareIsNotNull();
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        ArrayList<TemporaryCodeReducedRate> codeReducedRates = new ArrayList<TemporaryCodeReducedRate>();
        for (int i = 0; CollectionUtils.isNotEmpty(biddingOfferList) && i < biddingOfferList.size(); ++i) {
            TemporaryCodeReducedRate codeReducedRate = new TemporaryCodeReducedRate();
            codeReducedRate.setTemporaryCode(biddingOfferList.get(i).getSupplierTemporaryCode());
            codeReducedRate.setReducedRate(biddingOfferList.get(i).getBidShare());
            codeReducedRates.add(codeReducedRate);
        }
        TreeSet<TemporaryCodeReducedRate> personSet = new TreeSet<TemporaryCodeReducedRate>((o1, o2) -> o1.getTemporaryCode().compareTo(o2.getTemporaryCode()));
        personSet.addAll(codeReducedRates);
        return new ArrayList<TemporaryCodeReducedRate>(personSet);
    }
}

