/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingFileSupplier;
import com.els.base.bidding.entity.BiddingFileSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.service.BiddingFileSupplierService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u62db\u6807\u6587\u4ef6\u56de\u7b7e")
@Controller
@RequestMapping(value={"biddingFileSupplier"})
public class BiddingFileSupplierController {
    @Resource
    protected BiddingFileSupplierService biddingFileSupplierService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6807\u6587\u4ef6\u56de\u7b7e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingFileSupplier biddingFileSupplier) {
        this.biddingFileSupplierService.addObj(biddingFileSupplier);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u62db\u6807\u6587\u4ef6\u56de\u7b7e")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingFileSupplier biddingFileSupplier) {
        Assert.isNotBlank(biddingFileSupplier.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingFileSupplierService.modifyObj(biddingFileSupplier);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u62db\u6807\u6587\u4ef6\u56de\u7b7e")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingFileSupplierService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6807\u6587\u4ef6\u56de\u7b7e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingFileSupplier", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingFileSupplier>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingFileSupplierExample example = new BiddingFileSupplierExample();
        example.setPageView(new PageView<BiddingFileSupplier>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.biddingFileSupplierService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u56de\u7b7e\u6587\u4ef6\u4e0a\u4f20\u4fdd\u5b58")
    @RequestMapping(value={"service/saveFileSupplier"})
    @ResponseBody
    public ResponseResult<BiddingBaseVo> saveFileSupplier(@RequestBody BiddingBaseVo biddingBaseVo) {
        if (CollectionUtils.isEmpty(biddingBaseVo.getBiddingFileSupplier())) {
            throw new CommonException("\u5217\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u56de\u7b7e\u5217\u8868\u6570\u636e");
        }
        biddingBaseVo.setCompany(CompanyUtils.currentCompany());
        biddingBaseVo.setUser(SpringSecurityUtils.getLoginUser());
        this.biddingFileSupplierService.saveFileSupplier(biddingBaseVo);
        return ResponseResult.success(biddingBaseVo);
    }
}

