/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingOnline;
import com.els.base.bidding.entity.BiddingOnlineExample;
import com.els.base.bidding.entity.vo.BiddingOfferRankingVO;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingOnlineService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u62db\u6295\u6807-\u5728\u7ebf\u7ade\u4ef7")
@Controller
@RequestMapping(value={"biddingOnline"})
public class BiddingOnlineController {
    @Resource
    protected BiddingOnlineService biddingOnlineService;
    @Resource
    protected BiddingHeaderService biddingHeaderService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6295\u6807-\u5728\u7ebf\u7ade\u4ef7")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingOnline biddingOnline) {
        this.biddingOnlineService.addObj(biddingOnline);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u5728\u7ebf\u62a5\u4ef7")
    @RequestMapping(value={"service/quotation"})
    @ResponseBody
    public ResponseResult<String> quotation(@RequestBody BiddingOnline biddingOnline) {
        Assert.isNotNull(biddingOnline, "\u5728\u7ebf\u7ade\u4ef7\u4f9b\u5e94\u5546\u62a5\u4ef7\u4fe1\u606f\u5e76\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(biddingOnline.getUntaxedUnitPrice(), "\u672a\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(biddingOnline.getBiddingNo(), "\u62db\u6807\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(biddingOnline.getMaterialCode(), "\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(biddingOnline.getCurrency(), "\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(biddingOnline.getTaxCode(), "\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(biddingOnline.getPriceUnit(), "\u4ef7\u683c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(biddingOnline.getPriceEffectiveFrom(), "\u4ef7\u683c\u6709\u6548\u671f\u4ece\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(biddingOnline.getPriceEffectiveTo(), "\u4ef7\u683c\u6709\u6548\u671f\u5230\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingOnlineService.insert(CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), biddingOnline);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u62db\u6295\u6807-\u5728\u7ebf\u7ade\u4ef7")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingOnline biddingOnline) {
        Assert.isNotBlank(biddingOnline.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingOnlineService.modifyObj(biddingOnline);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u62db\u6295\u6807-\u5728\u7ebf\u7ade\u4ef7")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingOnlineService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u4f5c\u5e9f\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @RequestMapping(value={"service/batchInvalidation"})
    @ResponseBody
    public ResponseResult<String> batchInvalidation(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u4f5c\u5e9f\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingOnlineService.batchInvalidationById(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4e2d\u6807\u64cd\u4f5c\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @RequestMapping(value={"service/winTheBidding"})
    @ResponseBody
    public ResponseResult<String> winTheBidding(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingOnlineService.winTheBiddingById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u672a\u4e2d\u6807\u64cd\u4f5c\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @RequestMapping(value={"service/noWinTheBidding"})
    @ResponseBody
    public ResponseResult<String> noWinTheBidding(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingOnlineService.noWinTheBiddingById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u63d0\u4ea4\u8bc4\u6807\u7ed3\u679c")
    @RequestMapping(value={"service/submitBiddingResult"})
    @ResponseBody
    public ResponseResult<String> submitBiddingResult(@RequestBody(required=true) List<BiddingOnline> list) {
        Assert.isNotEmpty(list, "\u63d0\u4ea4\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        this.biddingOnlineService.submitResult(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6295\u6807-\u5728\u7ebf\u7ade\u4ef7\uff08\u91c7\u8d2d\u5546\uff09")
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<List<BiddingOnline>> findByPageForPur(@RequestParam(required=true) String biddingNo, @RequestParam String biddingRoundsNumber) {
        BiddingOnlineExample example = new BiddingOnlineExample();
        example.setOrderByClause("OFFER_TIME DESC");
        BiddingOnlineExample.Criteria criteria = example.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo);
        if (StringUtils.isNotBlank((String)biddingRoundsNumber)) {
            criteria.andBiddingRoundsNumberEqualTo(biddingRoundsNumber);
        }
        List pageData = this.biddingOnlineService.queryAllObjByExample(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6295\u6807-\u5728\u7ebf\u7ade\u4ef7\uff08\u4f9b\u5e94\u5546\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="biddingNo", required=true, value="\u62db\u6807\u7f16\u53f7", paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingOnline", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<BiddingOnline>> findByPageForSup(@RequestParam String biddingNo, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingOnlineExample example = new BiddingOnlineExample();
        example.setPageView(new PageView<BiddingOnline>(pageNo, pageSize));
        example.setOrderByClause("OFFER_TIME DESC");
        Company supCompany = CompanyUtils.currentCompany();
        String userId = SpringSecurityUtils.getLoginUserId();
        BiddingOnlineExample.Criteria criteria = example.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo);
        criteria.andSupCompanyIdEqualTo(supCompany.getId());
        criteria.andSupUserIdEqualTo(userId);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.biddingOnlineService.queryObjByPage(example);
        BiddingHeaderExample headerExample = new BiddingHeaderExample();
        headerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List headerList = this.biddingHeaderService.queryAllObjByExample(headerExample);
        if (CollectionUtils.isNotEmpty(headerList) && !"2".equals(((BiddingHeader)headerList.get(0)).getBiddingAuditstatus())) {
            pageData.getQueryResult().forEach(online -> {
                if ("2".equals(online.getQuotationState())) {
                    online.setQuotationState("1");
                }
            });
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u91c7\u8d2d\u5546\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u4ef7\u6392\u540d")
    @RequestMapping(value={"service/purFindSupCompanyRanking"})
    @ResponseBody
    public ResponseResult<List<BiddingOnline>> purFindSupCompanyRanking(@RequestParam(required=true) String biddingNo) {
        Assert.isNotBlank(biddingNo, "\u62db\u6807\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BiddingOnlineExample example = new BiddingOnlineExample();
        example.setOrderByClause("untaxedUnitPrice ASC,offerTime ASC");
        example.createCriteria().andBiddingNoEqualTo(biddingNo).andQuotationStateNotEqualTo("0");
        List<BiddingOnline> list = this.biddingOnlineService.queryAllObj(example);
        return ResponseResult.success(list);
    }

    /*
     * Enabled aggressive block sorting
     */
    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u4ef7\u6392\u540d")
    @RequestMapping(value={"service/supFindSupCompanyRanking"})
    @ResponseBody
    public ResponseResult<BiddingOfferRankingVO> supFindSupCompanyRanking(@RequestParam(required=true) String biddingNo) {
        Assert.isNotBlank(biddingNo, "\u62db\u6807\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Company supCompany = CompanyUtils.currentCompany();
        BiddingOnlineExample example = new BiddingOnlineExample();
        example.setOrderByClause("untaxedUnitPrice ASC,offerTime ASC");
        example.createCriteria().andBiddingNoEqualTo(biddingNo).andQuotationStateNotEqualTo("0");
        List<BiddingOnline> list = this.biddingOnlineService.queryAllObj(example);
        BiddingOfferRankingVO vo = new BiddingOfferRankingVO();
        vo.setOnlineList(list);
        int index = 1;
        int temp = 0;
        HashSet<BigDecimal> set = new HashSet<BigDecimal>();
        if (!CollectionUtils.isNotEmpty(list)) {
            vo.setRanking("");
            vo.setLowestPrice(BigDecimal.ZERO);
            return ResponseResult.success(vo);
        }
        int i = 0;
        while (i < list.size()) {
            if (set.add(list.get(i).getUntaxedUnitPrice())) {
                if (supCompany.getCompanyCode().equals(list.get(i).getSupCompanySrmCode())) {
                    vo.setRanking(String.valueOf(index));
                    vo.setLowestPrice(list.get(i).getUntaxedUnitPrice());
                    return ResponseResult.success(vo);
                }
                temp = index++;
            } else if (supCompany.getCompanyCode().equals(list.get(i).getSupCompanySrmCode())) {
                vo.setRanking(String.valueOf(temp));
                vo.setLowestPrice(list.get(i).getUntaxedUnitPrice());
                return ResponseResult.success(vo);
            }
            ++i;
        }
        return ResponseResult.success(vo);
    }
}

