/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u62db\u6295\u6807-\u62db\u6807\u610f\u5411\u4f9b\u5e94\u5546\u5217\u8868")
@Controller
@RequestMapping(value={"biddingSupplier"})
public class BiddingSupplierController {
    @Resource
    protected BiddingSupplierService biddingSupplierService;
    @Resource
    protected BiddingHeaderService biddingHeaderService;
    @Resource
    protected BiddingOfferService biddingOfferService;
    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6295\u6807-\u62db\u6807\u610f\u5411\u4f9b\u5e94\u5546\u5217\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingSupplier biddingSupplier) {
        this.biddingSupplierService.addObj(biddingSupplier);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58\u62db\u6807\u610f\u5411\u4f9b\u5e94\u5546\u5217\u8868")
    @RequestMapping(value={"service/save"})
    @ResponseBody
    public ResponseResult<String> save(@RequestBody BiddingBaseVo biddingBaseVo) throws InstantiationException, IllegalAccessException {
        this.biddingSupplierService.save(biddingBaseVo, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u62db\u6295\u6807-\u62db\u6807\u610f\u5411\u4f9b\u5e94\u5546\u5217\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingSupplier biddingSupplier) {
        Assert.isNotBlank(biddingSupplier.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingSupplierService.modifyObj(biddingSupplier);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u62db\u6295\u6807-\u4f9b\u5e94\u5546\u66f4\u65b0\u6295\u6807\u6216\u5e94\u6807\u72b6\u6001")
    @RequestMapping(value={"service/supEditStatus"})
    @ResponseBody
    public ResponseResult<String> supEditStatus(@RequestParam(required=true) String biddingNo, @RequestParam(required=true) String statuType, @RequestParam(required=true) String statu) {
        if (StringUtils.isBlank((String)biddingNo)) {
            throw new CommonException("\u62db\u6807\u5355\u53f7  \u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "base_canot_be_null", "\u62db\u6807\u5355\u53f7");
        }
        if (StringUtils.isBlank((String)statuType)) {
            throw new CommonException("\u72b6\u6001\u7c7b\u578b  \u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "base_canot_be_null", "\u72b6\u6001\u7c7b\u578b");
        }
        if (StringUtils.isBlank((String)statu)) {
            throw new CommonException("\u72b6\u6001  \u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "base_canot_be_null", "\u72b6\u6001");
        }
        User user = SpringSecurityUtils.getLoginUser();
        Company company = CompanyUtils.currentCompany();
        BiddingSupplier biddingSupplier = new BiddingSupplier();
        biddingSupplier.setLastUpdateTime(new Date());
        biddingSupplier.setLastUpdateUser(user.getNickName());
        this.biddingSupplierService.supEditStatus(biddingNo, statuType, statu, company, user);
        return ResponseResult.success();
    }

    private void updateBiddingStatus(BiddingSupplier biddingSupplier, String biddingNo, Company company) {
        BiddingSupplierExample example = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria biddingCriteria = example.createCriteria();
        biddingCriteria.andBiddingNoEqualTo(biddingNo);
        biddingCriteria.andSupCompanyIdEqualTo(company.getId());
        this.biddingSupplierService.editStatus(biddingSupplier, example);
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u62db\u6295\u6807-\u62db\u6807\u610f\u5411\u4f9b\u5e94\u5546\u5217\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingSupplierService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6295\u6807-\u62db\u6807\u610f\u5411\u4f9b\u5e94\u5546\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingSupplier", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingSupplier>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingSupplierExample example = new BiddingSupplierExample();
        example.setPageView(new PageView<BiddingSupplier>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.biddingSupplierService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

