/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.CompanyExtendMapper;
import com.els.base.company.entity.CompanyExtend;
import com.els.base.company.entity.CompanyExtendExample;
import com.els.base.company.service.CompanyExtendService;
import com.els.base.core.entity.PageView;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultCompanyExtendService")
public class CompanyExtendServiceImpl
implements CompanyExtendService {
    @Resource
    protected CompanyExtendMapper companyExtendMapper;

    @Override
    @CacheEvict(value={"companyExtend"}, allEntries=true)
    public void addObj(CompanyExtend t) {
        if (StringUtils.isBlank((String)t.getId())) {
            t.setCreateTime(new Date());
            this.companyExtendMapper.insertSelective(t);
        } else {
            t.setUpdateTime(new Date());
            this.companyExtendMapper.updateByPrimaryKeySelective(t);
        }
    }

    @Override
    @CacheEvict(value={"companyExtend"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyExtendMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyExtend"}, allEntries=true)
    public void modifyObj(CompanyExtend t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyExtendMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyExtend"}, keyGenerator="redisKeyGenerator")
    public CompanyExtend queryObjById(String id) {
        return this.companyExtendMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyExtend"}, keyGenerator="redisKeyGenerator")
    public List<CompanyExtend> queryAllObjByExample(CompanyExtendExample example) {
        return this.companyExtendMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyExtend"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyExtend> queryObjByPage(CompanyExtendExample example) {
        PageView<CompanyExtend> pageView = example.getPageView();
        pageView.setQueryResult(this.companyExtendMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"companyExtend"}, keyGenerator="redisKeyGenerator")
    public CompanyExtend queryByCompanyId(String companyId) {
        CompanyExtendExample example = new CompanyExtendExample();
        example.createCriteria().andCompanyIdEqualTo(companyId);
        List<CompanyExtend> list = this.companyExtendMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }
}

